/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.palette.customize;

import com.ibm.etools.webedit.palette.HTMLPaletteViewer;
import com.ibm.etools.webedit.palette.PaletteContextConstants;
import com.ibm.etools.webedit.palette.PaletteContextRegistryReader;
import com.ibm.etools.webedit.palette.customize.HTMLPaletteViewerPreferences;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorInput;
import org.eclipse.wst.html.core.internal.provisional.contenttype.ContentTypeIdForHTML;

public class ContextAction
extends Action
implements IMenuCreator {
    protected List actions;
    protected HTMLPaletteViewerPreferences prefs;

    public ContextAction(HTMLPaletteViewerPreferences newPrefs) {
        super(PaletteContextConstants.MENU_LABEL_CONTEXT);
        this.prefs = newPrefs;
        this.actions = this.createActions();
        this.setMenuCreator(this);
    }

    public ContextAction(String text, ImageDescriptor image) {
        super(text, image);
        this.actions = this.createActions();
        this.setMenuCreator(this);
    }

    protected List createActions() {
        ArrayList<ContextChangeAction> list = new ArrayList<ContextChangeAction>();
        ContextChangeAction action = new ContextChangeAction("HTML");
        action.setText(PaletteContextConstants.MENU_LABEL_HTML);
        list.add(action);
        HTMLPaletteViewer viewer = this.prefs.getHTMLPaletteViewer();
        if (viewer != null) {
            IProject project;
            List contexts;
            IFile file;
            if (viewer.getHtmlEditDomain().getActiveModel().getContentTypeIdentifier().equals(ContentTypeIdForHTML.ContentTypeID_HTML)) {
                return list;
            }
            IEditorInput input = viewer.getContributingEditorInput();
            if (input != null && (file = (IFile)input.getAdapter(IFile.class)) != null && (contexts = PaletteContextRegistryReader.getContextNames(project = file.getProject(), viewer.getHtmlEditDomain())) != null) {
                int max = contexts.size();
                int cnt = 0;
                while (cnt < max) {
                    PaletteContextRegistryReader.ContextDefinition definition = (PaletteContextRegistryReader.ContextDefinition)contexts.get(cnt);
                    if (definition != null && definition.id != null && definition.name != null) {
                        action = new ContextChangeAction(definition.id);
                        action.setText(definition.name);
                        list.add(action);
                    }
                    ++cnt;
                }
            }
        }
        return list;
    }

    public void dispose() {
    }

    public Menu getMenu(Control parent) {
        return null;
    }

    public Menu getMenu(Menu parent) {
        Menu menu = new Menu(parent);
        for (ContextChangeAction action : this.actions) {
            action.setChecked(action.getContext().equals(this.prefs.getContext()));
            ActionContributionItem item = new ActionContributionItem((IAction)action);
            item.fill(menu, -1);
        }
        this.setEnabled(!this.actions.isEmpty());
        return menu;
    }

    private class ContextChangeAction
    extends Action {
        private String context;

        public ContextChangeAction(String newContext) {
            this.context = newContext;
        }

        public String getContext() {
            return this.context;
        }

        public void run() {
            ContextAction.this.prefs.setContext(this.context);
        }
    }
}

