/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.palette;

import com.ibm.etools.palette.PaletteReader;
import com.ibm.etools.webedit.palette.HTMLPaletteViewer;
import com.ibm.etools.webedit.palette.PalettePlugin;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.swt.widgets.Display;

public class PaletteRefresher
implements Preferences.IPropertyChangeListener {
    private static PaletteRefresher instance;
    private static List<HTMLPaletteViewer> paletteViewers;

    public static PaletteRefresher getInstance() {
        if (instance == null) {
            instance = new PaletteRefresher();
        }
        return instance;
    }

    public void addViewer(HTMLPaletteViewer viewer) {
        if (paletteViewers == null) {
            paletteViewers = new ArrayList<HTMLPaletteViewer>();
        }
        paletteViewers.add(viewer);
        if (paletteViewers.size() == 1) {
            PalettePlugin.getDefault().getPluginPreferences().addPropertyChangeListener((Preferences.IPropertyChangeListener)this);
        }
    }

    public synchronized void refreshAll() {
        if (paletteViewers != null) {
            PaletteReader.getInstance().clearDefinitions();
            int i = 0;
            while (i < paletteViewers.size()) {
                paletteViewers.get(i).refreshModel();
                ++i;
            }
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    int i = 0;
                    while (i < paletteViewers.size()) {
                        ((HTMLPaletteViewer)paletteViewers.get(i)).refreshView();
                        ++i;
                    }
                }
            });
        }
    }

    public void removeViewer(HTMLPaletteViewer viewer) {
        if (paletteViewers != null) {
            paletteViewers.remove(viewer);
            if (paletteViewers.isEmpty()) {
                PalettePlugin.getDefault().getPluginPreferences().removePropertyChangeListener((Preferences.IPropertyChangeListener)this);
            }
        }
    }

    public void propertyChange(Preferences.PropertyChangeEvent event) {
        String prop = event.getProperty();
        if (prop != null && prop.equals("com.ibm.etools.webedit.palette.overlay") && event.getNewValue() != null && !event.getNewValue().equals("")) {
            this.refreshAll();
        }
    }
}

