/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.palette;

import com.ibm.etools.palette.PaletteDefinitions;
import com.ibm.etools.palette.PaletteReader;
import com.ibm.etools.palette.model.PaletteCategoryData;
import com.ibm.etools.palette.model.PaletteItemData;
import com.ibm.etools.webedit.palette.PaletteFactory;
import com.ibm.etools.webedit.palette.model.PaletteCategory;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;

class PaletteLoader {
    private static PaletteLoader instance = null;
    protected List<PaletteCategory> categories = new ArrayList<PaletteCategory>();
    protected List<PaletteEntry> items = new ArrayList<PaletteEntry>();

    private PaletteLoader() {
    }

    public PaletteDefinitions load() {
        PaletteDefinitions pluginDefinitions = (PaletteDefinitions)PaletteReader.getInstance().getDefinitions();
        this.createCategories(pluginDefinitions);
        return pluginDefinitions;
    }

    protected void createCategories(PaletteDefinitions definitions) {
        PaletteFactory pf = PaletteFactory.getInstance();
        List<PaletteCategoryData> categoryDefs = definitions.getCategories();
        PaletteCategory pc = null;
        PaletteEntry pe = null;
        for (PaletteCategoryData pcd : categoryDefs) {
            pc = pf.createCategory(pcd);
            this.categories.add(pc);
            List<PaletteItemData> itemDefs = pcd.getChildren();
            for (PaletteItemData pid : itemDefs) {
                pe = pf.createEntry(pid);
                this.items.add(pe);
                pc.add(pe);
            }
        }
    }

    public PaletteRoot createPaletteRoot() {
        this.categories.clear();
        this.load();
        PaletteRoot paletteRoot = new PaletteRoot();
        paletteRoot.addAll(this.categories);
        this.categories.clear();
        this.items.clear();
        return paletteRoot;
    }

    public static PaletteLoader getInstance() {
        if (instance == null) {
            instance = new PaletteLoader();
        }
        return instance;
    }
}

