/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.palette.model;

import com.ibm.etools.webedit.palette.view.HTMLPaletteVisibilityInspector;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public class PaletteVisibilityData {
    private List<FacetData[]> orList;
    private List<FacetData> requiredFacets;
    private static final String ATT_INSPECTOR_CLASS = "inspectorClass";
    private static final String FACET = "facet";
    private static final String OR = "or";
    private static final String AND = "AND";
    private static final String FACET_ID = "id";
    private static final String FACET_VERSION = "version";
    private static final String FACET_EXISTS = "exists";
    private HTMLPaletteVisibilityInspector inspector = null;
    private boolean hasInspector = false;
    private IConfigurationElement visibilityElement = null;

    public List<FacetData[]> getOrList() {
        return this.orList;
    }

    public void setOrList(List<FacetData[]> orList) {
        this.orList = orList;
    }

    public List<FacetData> getRequiredFacets() {
        return this.requiredFacets;
    }

    public void setRequiredFacets(List<FacetData> requiredFacets) {
        this.requiredFacets = requiredFacets;
    }

    public boolean hasInspector() {
        return this.hasInspector;
    }

    public HTMLPaletteVisibilityInspector getInspector() {
        if (this.inspector == null) {
            try {
                this.inspector = (HTMLPaletteVisibilityInspector)this.visibilityElement.createExecutableExtension(ATT_INSPECTOR_CLASS);
            }
            catch (CoreException ce) {
                ce.printStackTrace();
            }
        }
        return this.inspector;
    }

    public void setInspector(HTMLPaletteVisibilityInspector visibilityInspector) {
        if (visibilityInspector != null) {
            this.inspector = visibilityInspector;
            this.hasInspector = true;
        }
    }

    public void configure(IConfigurationElement visibilityElement) {
        String temp = visibilityElement.getAttribute(ATT_INSPECTOR_CLASS);
        if (temp != null) {
            this.hasInspector = true;
            this.visibilityElement = visibilityElement;
        }
        IConfigurationElement[] facets = visibilityElement.getChildren(FACET);
        this.configureRequiredFacets(facets);
        IConfigurationElement[] ors = visibilityElement.getChildren(OR);
        this.orList = this.parseORs(ors);
        IConfigurationElement[] ands = visibilityElement.getChildren(AND);
        List<FacetData[]> list = this.parseANDs(ands);
        if (list != null) {
            this.mergeToOrList(list);
        }
    }

    private void configureRequiredFacets(IConfigurationElement[] facets) {
        if (facets.length > 0) {
            this.requiredFacets = new ArrayList<FacetData>(facets.length);
            int i = 0;
            while (i < facets.length) {
                FacetData one = this.createFacetData(facets[i]);
                this.requiredFacets.add(one);
                ++i;
            }
        }
    }

    private FacetData createFacetData(IConfigurationElement facet) {
        FacetData one = new FacetData();
        one.id = facet.getAttribute(FACET_ID);
        one.version = facet.getAttribute(FACET_VERSION);
        one.existsString = facet.getAttribute(FACET_EXISTS);
        return one;
    }

    private List<FacetData[]> parseORs(IConfigurationElement[] ors) {
        if (ors.length > 0) {
            ArrayList<FacetData[]> list = new ArrayList<FacetData[]>(ors.length);
            int k = 0;
            while (k < ors.length) {
                FacetData[] data = this.createFacetDataArray(ors[k]);
                list.add(data);
                ++k;
            }
            return list;
        }
        return null;
    }

    private FacetData[] createFacetDataArray(IConfigurationElement orElement) {
        IConfigurationElement[] facets = orElement.getChildren();
        FacetData[] data = new FacetData[facets.length];
        int i = 0;
        while (i < facets.length) {
            FacetData one;
            data[i] = one = this.createFacetData(facets[i]);
            ++i;
        }
        return data;
    }

    private List<FacetData[]> parseANDs(IConfigurationElement[] ands) {
        if (ands.length > 0) {
            ArrayList<FacetData[]> temp = new ArrayList<FacetData[]>();
            int i = 0;
            while (i < ands.length) {
                IConfigurationElement[] ors = ands[i].getChildren(OR);
                if (ors.length > 0) {
                    int k = 0;
                    while (k < ors.length) {
                        FacetData[] array = this.createFacetDataArray(ors[k]);
                        temp.add(array);
                        ++k;
                    }
                }
                ++i;
            }
            return temp;
        }
        return null;
    }

    private void mergeToOrList(List<FacetData[]> list) {
        if (this.orList == null) {
            this.orList = list;
        } else {
            this.orList.addAll(list);
        }
    }

    public class FacetData {
        public String id;
        public String version;
        public String existsString;
    }
}

