/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.palette.model;

import com.ibm.etools.palette.PaletteReader;
import com.ibm.etools.palette.model.IVisibilityHelper;
import com.ibm.etools.palette.model.PaletteContextData;
import com.ibm.etools.palette.model.PaletteData;
import com.ibm.etools.palette.model.PaletteVisibilityData;
import com.ibm.etools.webedit.palette.HTMLPaletteViewer;
import com.ibm.etools.webedit.palette.model.PaletteVisibilityHelper;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.w3c.dom.Element;

public class PaletteDataImpl
implements PaletteData {
    private String id;
    private String label;
    private String description;
    private URL smallIcon;
    private URL largeIcon;
    private boolean isVisible = true;
    private String preferredOffset;
    private boolean isModifiable = true;
    private PaletteVisibilityData visibilityData;
    private List<PaletteContextData> applicableContexts;
    private IVisibilityHelper visibilityHelper = PaletteVisibilityHelper.getInstance();

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public URL getSmallIcon() {
        return this.smallIcon;
    }

    @Override
    public URL getLargeIcon() {
        return this.largeIcon;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void setSmallIcon(URL icon) {
        this.smallIcon = icon;
    }

    @Override
    public void setLargeIcon(URL icon) {
        this.largeIcon = icon;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    @Override
    public void setVisible(boolean visible) {
        this.isVisible = visible;
    }

    @Override
    public boolean isModifiable() {
        return this.isModifiable;
    }

    @Override
    public String getPreferredOffset() {
        return this.preferredOffset;
    }

    @Override
    public void setPreferredOffset(String preferredOffset) {
        this.preferredOffset = preferredOffset;
    }

    @Override
    public void setModifiable(boolean modifiable) {
        this.isModifiable = modifiable;
    }

    @Override
    public PaletteVisibilityData getVisibilityData() {
        return this.visibilityData;
    }

    @Override
    public void setVisibilityData(PaletteVisibilityData visibilityData) {
        this.visibilityData = visibilityData;
    }

    @Override
    public List<PaletteContextData> getApplicableContexts() {
        return this.applicableContexts;
    }

    @Override
    public void setApplicableContexts(List<PaletteContextData> applicableContexts) {
        this.applicableContexts = applicableContexts;
    }

    public void configure(IConfigurationElement categoryOrItemElement) {
        this.id = categoryOrItemElement.getAttribute("id");
        this.label = categoryOrItemElement.getAttribute("label");
        this.description = categoryOrItemElement.getAttribute("description");
        this.smallIcon = this.createURL(categoryOrItemElement, categoryOrItemElement.getAttribute("iconSmall"));
        this.largeIcon = this.createURL(categoryOrItemElement, categoryOrItemElement.getAttribute("iconLarge"));
        String visibleString = categoryOrItemElement.getAttribute("visible");
        this.isVisible = visibleString != null ? Boolean.valueOf(visibleString) : true;
        String modifiableString = categoryOrItemElement.getAttribute("modifiable");
        this.isModifiable = modifiableString != null ? Boolean.valueOf(modifiableString) : false;
        this.preferredOffset = categoryOrItemElement.getAttribute("preferredoffset");
        IConfigurationElement[] visibilityChildren = categoryOrItemElement.getChildren("visibility");
        if (visibilityChildren.length > 0) {
            this.visibilityData = new PaletteVisibilityData();
            this.visibilityData.configure(visibilityChildren[0]);
        }
        IConfigurationElement[] contexts = categoryOrItemElement.getChildren("context");
        this.configureContexts(contexts);
    }

    private void configureContexts(IConfigurationElement[] contextElements) {
        if (contextElements.length > 0) {
            IConfigurationElement[] contexts = contextElements[0].getChildren();
            this.applicableContexts = new ArrayList<PaletteContextData>(contexts.length);
            IConfigurationElement[] iConfigurationElementArray = contexts;
            int n = contexts.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement context = iConfigurationElementArray[n2];
                PaletteContextData one = new PaletteContextData();
                one.configure(context);
                this.applicableContexts.add(one);
                ++n2;
            }
        }
    }

    @Override
    public boolean isVisible(String currentContext, HTMLPaletteViewer viewer) {
        String isVisibleValue;
        boolean retVal = true;
        Element userModifiedItemElement = PaletteReader.getInstance().getUserModifiedItemElement(this.getId());
        if (userModifiedItemElement != null && (isVisibleValue = PaletteReader.getInstance().getUserModifiedAttributeValue(userModifiedItemElement, "visible")) != null && !isVisibleValue.equals("")) {
            retVal = Boolean.parseBoolean(isVisibleValue);
            return retVal;
        }
        PaletteContextData context = this.searchContext(currentContext);
        if (context != null && context.isVisible() != null) {
            retVal = Boolean.valueOf(context.isVisible());
        } else {
            if (this.getVisibilityData() != null) {
                return this.visibilityHelper.isVisible(this, viewer);
            }
            retVal = this.isVisible();
        }
        return retVal;
    }

    public void setVisible(boolean visible, String currentContext) {
        if (currentContext != null) {
            PaletteContextData context = this.searchContext(currentContext);
            if (context != null) {
                context.setVisible(Boolean.toString(visible));
            } else {
                this.setVisible(visible);
            }
        } else {
            this.setVisible(visible);
        }
    }

    @Override
    public void setVisibilityHelper(IVisibilityHelper helper) {
        this.visibilityHelper = helper;
    }

    protected PaletteContextData searchContext(String id) {
        if (this.applicableContexts != null) {
            for (PaletteContextData context : this.applicableContexts) {
                if (!context.getContextId().equals(id)) continue;
                return context;
            }
        }
        return null;
    }

    protected URL createURL(IConfigurationElement element, String bundleRelativePath) {
        if (bundleRelativePath != null) {
            String bundleName = element.getContributor().getName();
            Bundle bundle = Platform.getBundle((String)bundleName);
            return bundle.getEntry(bundleRelativePath);
        }
        return null;
    }

    public String toString() {
        return this.getLabel();
    }
}

