/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.palette.model;

import com.ibm.etools.palette.PaletteReader;
import com.ibm.etools.palette.model.PaletteCategoryData;
import com.ibm.etools.palette.model.PaletteContextData;
import com.ibm.etools.palette.model.PaletteDataImpl;
import com.ibm.etools.palette.model.PaletteItemData;
import com.ibm.etools.webedit.palette.HTMLPaletteViewer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.w3c.dom.Element;

public class PaletteCategoryDataImpl
extends PaletteDataImpl
implements PaletteCategoryData {
    protected List<PaletteItemData> children = new ArrayList<PaletteItemData>();
    private boolean isInitiallyOpen = false;
    private boolean isInitiallyPinned = false;

    @Override
    public List<PaletteItemData> getChildren() {
        return this.children;
    }

    @Override
    public void add(PaletteItemData item) {
        this.children.add(item);
        item.setCategory(this);
    }

    @Override
    public void add(PaletteItemData item, int offset) {
        if (offset < 0 || offset >= this.children.size()) {
            this.add(item);
        } else {
            this.children.add(offset, item);
            item.setCategory(this);
        }
    }

    @Override
    public void remove(PaletteItemData item) {
        this.children.remove(item);
    }

    @Override
    public boolean isInitiallyOpen() {
        return this.isInitiallyOpen;
    }

    @Override
    public boolean isInitiallyPinned() {
        return this.isInitiallyPinned;
    }

    @Override
    public void setInitiallyOpen(boolean open) {
        this.isInitiallyOpen = open;
    }

    @Override
    public void setInitiallyPinned(boolean pinned) {
        this.isInitiallyPinned = pinned;
    }

    public boolean isInitiallyOpen(String currentContext) {
        String isInitiallyOpenValue;
        boolean retVal = false;
        Element userModifiedCategoryElement = PaletteReader.getInstance().getUserModifiedCategoryElement(this.getId());
        if (userModifiedCategoryElement != null && (isInitiallyOpenValue = PaletteReader.getInstance().getUserModifiedAttributeValue(userModifiedCategoryElement, "initiallyopen")) != null && !isInitiallyOpenValue.equals("")) {
            retVal = Boolean.parseBoolean(isInitiallyOpenValue);
            return retVal;
        }
        PaletteContextData context = this.searchContext(currentContext);
        retVal = context != null && context.isInitiallyOpen() != null ? Boolean.valueOf(context.isInitiallyOpen()).booleanValue() : this.isInitiallyOpen();
        return retVal;
    }

    public boolean isInitiallyPinned(String currentContext) {
        String isInitiallyPinnedValue;
        boolean retVal = false;
        Element userModifiedCategoryElement = PaletteReader.getInstance().getUserModifiedCategoryElement(this.getId());
        if (userModifiedCategoryElement != null && (isInitiallyPinnedValue = PaletteReader.getInstance().getUserModifiedAttributeValue(userModifiedCategoryElement, "initiallypinned")) != null && !isInitiallyPinnedValue.equals("")) {
            retVal = Boolean.parseBoolean(isInitiallyPinnedValue);
            return retVal;
        }
        PaletteContextData context = this.searchContext(currentContext);
        retVal = context != null && context.isInitiallyPinned() != null ? Boolean.valueOf(context.isInitiallyPinned()).booleanValue() : this.isInitiallyPinned();
        return retVal;
    }

    public void setInitiallyOpen(boolean open, String currentContext) {
        if (currentContext != null) {
            PaletteContextData context = this.searchContext(currentContext);
            if (context != null) {
                context.setInitiallyOpen(Boolean.toString(open));
            } else {
                this.setInitiallyOpen(open);
            }
        } else {
            this.setInitiallyOpen(open);
        }
    }

    public void setInitiallyPinned(boolean pinned, String currentContext) {
        if (currentContext != null) {
            PaletteContextData context = this.searchContext(currentContext);
            if (context != null) {
                context.setInitiallyPinned(Boolean.toString(pinned));
            } else {
                this.setInitiallyPinned(pinned);
            }
        } else {
            this.setInitiallyPinned(pinned);
        }
    }

    @Override
    public void configure(IConfigurationElement categoryElement) {
        super.configure(categoryElement);
        this.setSmallIcon(this.createURL(categoryElement, categoryElement.getAttribute("icon")));
        String openString = categoryElement.getAttribute("initiallyopen");
        this.isInitiallyOpen = openString != null ? Boolean.valueOf(openString) : false;
        String pinnedString = categoryElement.getAttribute("initiallypinned");
        this.isInitiallyPinned = pinnedString != null ? Boolean.valueOf(pinnedString) : false;
    }

    @Override
    public boolean isVisible(String currentContext, HTMLPaletteViewer viewer) {
        String isVisible;
        boolean retVal = false;
        Element userModifiedCategoryElement = PaletteReader.getInstance().getUserModifiedCategoryElement(this.getId());
        if (userModifiedCategoryElement != null && (isVisible = PaletteReader.getInstance().getUserModifiedAttributeValue(userModifiedCategoryElement, "visible")) != null && !isVisible.equals("")) {
            retVal = Boolean.parseBoolean(isVisible);
            return retVal;
        }
        return super.isVisible(currentContext, viewer);
    }
}

