/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.palette;

import com.ibm.etools.palette.Logger;
import com.ibm.etools.palette.PaletteDefinitions;
import com.ibm.etools.palette.model.IDefinitions;
import com.ibm.etools.palette.model.PaletteCategoryData;
import com.ibm.etools.palette.model.PaletteCategoryDataImpl;
import com.ibm.etools.palette.model.PaletteData;
import com.ibm.etools.palette.model.PaletteItemData;
import com.ibm.etools.palette.model.PaletteItemDataImpl;
import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import com.ibm.etools.webedit.palette.PalettePlugin;
import com.ibm.etools.webedit.palette.PaletteProvider;
import com.ibm.etools.webedit.palette.PaletteUpdater;
import com.ibm.etools.webedit.palette.action.ActionContributorFactory;
import com.ibm.etools.webedit.palette.action.FeedbackContributorFactory;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class PaletteReader {
    private static final String CONTRIBUTIONS_EXT_PT_ID = "PageDesignerPaletteContributions";
    private static final String PROVIDERS_EXT_PT_ID = "PageDesignerPaletteProviders";
    private static final String PROVIDERS_EXT_PROVIDER = "provider";
    private static final String PROVIDERS_EXT_CLASS_NAME = "className";
    private static final String UPDATERS_EXT_PT_ID = "PageDesignerPaletteUpdaters";
    private static final String UPDATERS_EXT_UPDATER = "updater";
    private static final String UPDATERS_EXT_CLASS_NAME = "className";
    private static final String SEPERATOR_INDICATOR = "separator";
    private static PaletteReader reader = null;
    protected IDefinitions fDefinitions = null;
    protected String fCurrentVersionID = "3.0";
    protected List<PaletteItemData> fOrphans = new ArrayList<PaletteItemData>();
    private String preferences = PalettePlugin.getDefault().getPreferenceStore().getString("com.ibm.etools.webedit.palette.overlay");

    protected PaletteReader() {
    }

    public static PaletteReader getInstance() {
        if (reader == null) {
            reader = new PaletteReader();
        }
        return reader;
    }

    public IDefinitions getDefinitions() {
        if (this.fDefinitions == null || this.userPreferencesStale()) {
            this.loadDefinitions();
        }
        return this.fDefinitions;
    }

    private boolean userPreferencesStale() {
        String currentPrefString = PalettePlugin.getDefault().getPreferenceStore().getString("com.ibm.etools.webedit.palette.overlay");
        return !currentPrefString.equals(this.preferences);
    }

    private void loadDefinitions() {
        IExtensionPoint providersPoint;
        this.fDefinitions = new PaletteDefinitions();
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint point = extensionRegistry.getExtensionPoint("com.ibm.etools.webedit.palette", CONTRIBUTIONS_EXT_PT_ID);
        if (point != null) {
            IConfigurationElement[] elements = point.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                this.addDefinitionFromExtension(elements[i]);
                ++i;
            }
        }
        if ((providersPoint = extensionRegistry.getExtensionPoint("com.ibm.etools.webedit.palette", PROVIDERS_EXT_PT_ID)) != null) {
            IConfigurationElement[] elements = providersPoint.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                this.addDefinitionFromProvidersExtension(elements[i]);
                ++i;
            }
        }
        this.connectCategoriesAndItems();
        this.applyUserOverlay();
    }

    private void applyUserOverlay() {
        try {
            Document prefDocument = null;
            this.preferences = PalettePlugin.getDefault().getPreferenceStore().getString("com.ibm.etools.webedit.palette.overlay");
            if (!this.preferences.equals("")) {
                DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                prefDocument = builder.parse(new InputSource(new StringReader(this.preferences)));
                NodeList categories = prefDocument.getElementsByTagName("category");
                int i = 0;
                while (i < categories.getLength()) {
                    Element categoryElement = (Element)categories.item(i);
                    String id = categoryElement.getAttribute("id");
                    PaletteCategoryData categoryData = this.fDefinitions.getCategory(id);
                    if (categoryData != null) {
                        String userModifiedPreferredOffset;
                        String userModifiedInitallyPinned;
                        String userModifiedInitiallyOpen;
                        String userModifiedVisible;
                        String userModifiedDesc;
                        String userModifiedName = categoryElement.getAttribute("name");
                        if (!userModifiedName.equals("")) {
                            categoryData.setLabel(userModifiedName);
                        }
                        if (!(userModifiedDesc = categoryElement.getAttribute("description")).equals("")) {
                            categoryData.setDescription(userModifiedDesc);
                        }
                        if (!(userModifiedVisible = categoryElement.getAttribute("visible")).equals("")) {
                            categoryData.setVisible(Boolean.parseBoolean(userModifiedVisible));
                        }
                        if (!(userModifiedInitiallyOpen = categoryElement.getAttribute("initiallyopen")).equals("")) {
                            categoryData.setInitiallyOpen(Boolean.parseBoolean(userModifiedInitiallyOpen));
                        }
                        if (!(userModifiedInitallyPinned = categoryElement.getAttribute("initiallypinned")).equals("")) {
                            categoryData.setInitiallyPinned(Boolean.parseBoolean(userModifiedInitallyPinned));
                        }
                        if (!(userModifiedPreferredOffset = categoryElement.getAttribute("preferredoffset")).equals("")) {
                            this.fDefinitions.removeCategory(categoryData);
                            categoryData.setPreferredOffset(userModifiedPreferredOffset);
                            this.insertCategory(categoryData);
                        }
                    }
                    ++i;
                }
                NodeList items = prefDocument.getElementsByTagName("item");
                int i2 = 0;
                while (i2 < items.getLength()) {
                    Element itemElement = (Element)items.item(i2);
                    String id = itemElement.getAttribute("id");
                    PaletteItemData itemData = this.fDefinitions.getItem(id);
                    if (itemData != null) {
                        NodeList tagAttributes;
                        String userModifiedPreferredOffset;
                        String userModifiedVisible;
                        String userModifiedDesc;
                        String userModifiedName = itemElement.getAttribute("name");
                        if (!userModifiedName.equals("")) {
                            itemData.setLabel(userModifiedName);
                        }
                        if (!(userModifiedDesc = itemElement.getAttribute("description")).equals("")) {
                            itemData.setDescription(userModifiedDesc);
                        }
                        if (!(userModifiedVisible = itemElement.getAttribute("visible")).equals("")) {
                            itemData.setVisible(Boolean.parseBoolean(userModifiedVisible));
                        }
                        if (!(userModifiedPreferredOffset = itemElement.getAttribute("preferredoffset")).equals("")) {
                            this.removeItem(itemData);
                            itemData.setPreferredOffset(userModifiedPreferredOffset);
                            this.insertItem(itemData);
                        }
                        if ((tagAttributes = itemElement.getElementsByTagName("tagAttribute")) != null) {
                            int j = 0;
                            while (j < tagAttributes.getLength()) {
                                String name = ((Element)tagAttributes.item(j)).getAttribute("name");
                                String value = ((Element)tagAttributes.item(j)).getAttribute("value");
                                itemData.addTagAttribute(name, value);
                                ++j;
                            }
                        }
                    } else if (id != null && id.contains(SEPERATOR_INDICATOR)) {
                        PaletteItemData separator = this.createSeparator(itemElement.getAttribute("category"), id);
                        separator.setPreferredOffset(itemElement.getAttribute("preferredoffset"));
                        this.insertItem(separator);
                    }
                    ++i2;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isCategoryUserModified(String categoryID, String attribute) {
        boolean isUserModified;
        block4: {
            isUserModified = false;
            try {
                Document prefDocument = null;
                if (this.preferences.equals("")) break block4;
                DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                prefDocument = builder.parse(new InputSource(new StringReader(this.preferences)));
                NodeList categories = prefDocument.getElementsByTagName("category");
                int i = 0;
                while (i < categories.getLength()) {
                    String userModifiedAttribute;
                    Element categoryElement = (Element)categories.item(i);
                    String id = categoryElement.getAttribute("id");
                    if (id != null && id.equals(categoryID) && (userModifiedAttribute = categoryElement.getAttribute(attribute)) != null && !userModifiedAttribute.equals("")) {
                        isUserModified = true;
                        break;
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return isUserModified;
    }

    public Element getUserModifiedItemElement(String itemID) {
        Element userModifiedItemElement = null;
        try {
            Document prefDocument = null;
            if (!this.preferences.equals("")) {
                DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                prefDocument = builder.parse(new InputSource(new StringReader(this.preferences)));
                NodeList items = prefDocument.getElementsByTagName("item");
                int i = 0;
                while (i < items.getLength()) {
                    Element itemElement = (Element)items.item(i);
                    String id = itemElement.getAttribute("id");
                    if (id != null && id.equals(itemID)) {
                        userModifiedItemElement = itemElement;
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return userModifiedItemElement;
    }

    public Element getUserModifiedCategoryElement(String categoryID) {
        Element userModifiedCategoryElement = null;
        try {
            Document prefDocument = null;
            if (!this.preferences.equals("")) {
                DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                prefDocument = builder.parse(new InputSource(new StringReader(this.preferences)));
                NodeList categories = prefDocument.getElementsByTagName("category");
                int i = 0;
                while (i < categories.getLength()) {
                    Element categoryElement = (Element)categories.item(i);
                    String id = categoryElement.getAttribute("id");
                    if (id != null && id.equals(categoryID)) {
                        userModifiedCategoryElement = categoryElement;
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return userModifiedCategoryElement;
    }

    public boolean isItemUserModified(String itemID, String attribute) {
        boolean isUserModified;
        block4: {
            isUserModified = false;
            try {
                Document prefDocument = null;
                if (this.preferences.equals("")) break block4;
                DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                prefDocument = builder.parse(new InputSource(new StringReader(this.preferences)));
                NodeList items = prefDocument.getElementsByTagName("item");
                int i = 0;
                while (i < items.getLength()) {
                    String userModifiedAttribute;
                    Element itemElement = (Element)items.item(i);
                    String id = itemElement.getAttribute("id");
                    if (id != null && id.equals(itemID) && (userModifiedAttribute = itemElement.getAttribute(attribute)) != null && !userModifiedAttribute.equals("")) {
                        isUserModified = true;
                        break;
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return isUserModified;
    }

    public String getUserModifiedAttributeValue(Element element, String attribute) {
        String userModifiedAttributeValue = null;
        if (element != null && attribute != null) {
            userModifiedAttributeValue = element.getAttribute(attribute);
        }
        return userModifiedAttributeValue;
    }

    private void addDefinitionFromExtension(IConfigurationElement element) {
        String name = element.getName();
        if (name.equals("category")) {
            this.addCategory(element);
        } else if (name.equals("item")) {
            this.addItem(element);
        } else if (name.equals(SEPERATOR_INDICATOR)) {
            this.addItem(element);
        } else if (name.equals("actionContributor")) {
            this.addActionContributor(element);
        } else if (name.equals("feedbackContributor")) {
            this.addFeedbackContributor(element);
        }
    }

    protected void addDefinitionFromProvidersExtension(IConfigurationElement element) {
        String name = element.getName();
        if (name.equals(PROVIDERS_EXT_PROVIDER)) {
            PaletteProvider provider = null;
            try {
                provider = (PaletteProvider)element.createExecutableExtension("className");
            }
            catch (CoreException ce) {
                ce.printStackTrace();
            }
            PaletteData[] paletteEntries = provider.providePaletteItems();
            int i = 0;
            while (i < paletteEntries.length) {
                PaletteData entry = paletteEntries[i];
                if (entry instanceof PaletteCategoryData) {
                    this.insertCategory((PaletteCategoryData)entry);
                } else if (entry instanceof PaletteItemData) {
                    this.insertItem((PaletteItemData)entry);
                }
                ++i;
            }
        }
    }

    protected void addDefinitionFromUpdatersExtension(IConfigurationElement element, HTMLEditDomain domain) {
        String name = element.getName();
        if (name.equals(UPDATERS_EXT_UPDATER)) {
            PaletteUpdater updater = null;
            try {
                updater = (PaletteUpdater)element.createExecutableExtension("className");
            }
            catch (CoreException ce) {
                ce.printStackTrace();
            }
            PaletteData[] paletteEntries = updater.updatePaletteItems(domain);
            if (paletteEntries == null) {
                return;
            }
            int i = 0;
            while (i < paletteEntries.length) {
                PaletteData entry = paletteEntries[i];
                if (entry instanceof PaletteCategoryData) {
                    this.insertCategory((PaletteCategoryData)entry);
                } else if (entry instanceof PaletteItemData) {
                    this.insertItem((PaletteItemData)entry);
                }
                ++i;
            }
        }
    }

    public void addDefinitions(HTMLEditDomain domain) {
        IExtensionRegistry extensionRegistry;
        IExtensionPoint point;
        if (this.fDefinitions == null || this.userPreferencesStale()) {
            this.loadDefinitions();
        }
        if ((point = (extensionRegistry = Platform.getExtensionRegistry()).getExtensionPoint("com.ibm.etools.webedit.palette", UPDATERS_EXT_PT_ID)) != null) {
            IConfigurationElement[] elements = point.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                this.addDefinitionFromUpdatersExtension(elements[i], domain);
                ++i;
            }
        }
    }

    private void addCategory(IConfigurationElement element) {
        String id = element.getAttribute("id");
        if (id == null || id.length() < 1) {
            this.logCreationError("category", "no ID specified", element);
            return;
        }
        PaletteCategoryData category = this.fDefinitions.getCategory(id);
        if (category == null) {
            category = new PaletteCategoryDataImpl();
            ((PaletteCategoryDataImpl)category).configure(element);
            this.insertCategory(category);
        }
    }

    public void insertCategory(PaletteCategoryData category) {
        String preferredOffsetString = category.getPreferredOffset();
        if (preferredOffsetString != null && preferredOffsetString.length() > 0) {
            List<PaletteCategoryData> children = this.fDefinitions.getCategories();
            Iterator<PaletteCategoryData> i = children.iterator();
            PaletteData sibling = null;
            int cnt = 0;
            boolean found = false;
            int preferredOffset = Integer.valueOf(preferredOffsetString);
            while (i.hasNext() && !found) {
                sibling = i.next();
                String siblingPreferredOffsetString = sibling.getPreferredOffset();
                if (siblingPreferredOffsetString == null) {
                    found = true;
                    continue;
                }
                int siblingPreferredOffset = Integer.valueOf(siblingPreferredOffsetString);
                if (preferredOffset <= siblingPreferredOffset) {
                    found = true;
                    continue;
                }
                ++cnt;
            }
            this.fDefinitions.addCategory(cnt, category);
            category.setPreferredOffset(preferredOffsetString);
        } else {
            this.fDefinitions.addCategory(category);
        }
        this.pickupOrphanItems(category);
    }

    private void pickupOrphanItems(PaletteCategoryData category) {
        ArrayList<PaletteItemData> stillOrphans = new ArrayList<PaletteItemData>();
        boolean foundChildren = false;
        for (PaletteItemData item : this.fOrphans) {
            if (category.getId().equals(((PaletteItemDataImpl)item).getCategoryName())) {
                foundChildren = true;
                this.addItemToCategory(item, category);
                continue;
            }
            stillOrphans.add(item);
        }
        if (foundChildren) {
            this.fOrphans = stillOrphans;
        }
    }

    private void addItem(IConfigurationElement element) {
        String id = element.getAttribute("id");
        if (id == null || id.length() < 1) {
            this.logCreationError("item", "no ID specified", element);
            return;
        }
        String category = element.getAttribute("category");
        if (category == null || category.length() < 1) {
            this.logCreationError("item", "no category specified", element);
            return;
        }
        PaletteItemData item = this.fDefinitions.getItem(id);
        if (item == null) {
            item = new PaletteItemDataImpl();
            ((PaletteItemDataImpl)item).configure(element);
            if (element.getName().equals(SEPERATOR_INDICATOR)) {
                ((PaletteItemDataImpl)item).setIsSeparator(true);
            }
            this.insertItem(item);
        }
    }

    public void insertItem(PaletteItemData item) {
        PaletteCategoryData category = item.getCategory();
        String tmpCategory = category != null ? category.getId() : ((PaletteItemDataImpl)item).getCategoryName();
        this.fDefinitions.addItem(item);
        PaletteCategoryData parentCategory = this.fDefinitions.getCategory(tmpCategory);
        if (parentCategory != null) {
            this.addItemToCategory(item, parentCategory);
        } else {
            this.fOrphans.add(item);
        }
    }

    public void removeItem(PaletteItemData item) {
        PaletteCategoryData category = item.getCategory();
        String tmpCategory = category != null ? category.getId() : ((PaletteItemDataImpl)item).getCategoryName();
        this.fDefinitions.removeItem(item);
        PaletteCategoryData parentCategory = this.fDefinitions.getCategory(tmpCategory);
        if (parentCategory != null) {
            parentCategory.remove(item);
        }
    }

    private void addFeedbackContributor(IConfigurationElement element) {
        String id = element.getAttribute("id");
        if (id == null || id.length() < 1) {
            this.logCreationError("feedbackContributor", "no ID specified", element);
            return;
        }
        String feedbackClass = element.getAttribute("class");
        if (feedbackClass == null || feedbackClass.length() < 1) {
            this.logCreationError("feedbackContributor", "no class specified", element);
            return;
        }
        FeedbackContributorFactory.getInstance().addContributor(id, feedbackClass, element);
    }

    private void addActionContributor(IConfigurationElement element) {
        String id = element.getAttribute("id");
        if (id == null || id.length() < 1) {
            this.logCreationError("actioncontributor", "no ID specified", element);
            return;
        }
        String actionClass = element.getAttribute("class");
        if (actionClass == null || actionClass.length() < 1) {
            this.logCreationError("actioncontributor", "no class specified", element);
            return;
        }
        ActionContributorFactory.getInstance().addContributor(id, actionClass, element);
    }

    private void addItemToCategory(PaletteItemData item, PaletteCategoryData parentCategory) {
        String preferredOffsetString = item.getPreferredOffset();
        if (preferredOffsetString != null && preferredOffsetString.length() > 0) {
            int preferredOffset = Integer.valueOf(preferredOffsetString);
            List<PaletteItemData> children = parentCategory.getChildren();
            Iterator<PaletteItemData> i = children.iterator();
            PaletteData sibling = null;
            int cnt = 0;
            boolean found = false;
            while (i.hasNext() && !found) {
                sibling = i.next();
                String siblingPreferredOffsetString = sibling.getPreferredOffset();
                if (siblingPreferredOffsetString == null) {
                    found = true;
                    continue;
                }
                int siblingPreferredOffset = Integer.valueOf(siblingPreferredOffsetString);
                if (preferredOffset <= siblingPreferredOffset) {
                    found = true;
                    continue;
                }
                ++cnt;
            }
            parentCategory.add(item, cnt);
            item.setPreferredOffset(preferredOffsetString);
        } else {
            parentCategory.add(item);
        }
    }

    private String getElementAsString(IConfigurationElement element) {
        String elementAsString = "<" + element.getName();
        String[] attributeNames = element.getAttributeNames();
        if (attributeNames != null) {
            int i = 0;
            while (i < attributeNames.length) {
                elementAsString = String.valueOf(elementAsString) + " " + attributeNames[i] + "=" + element.getAttribute(attributeNames[i]);
                ++i;
            }
        }
        elementAsString = String.valueOf(elementAsString) + ">";
        return elementAsString;
    }

    private void logCreationError(String type, String reason, IConfigurationElement element) {
        Logger.log(4, "Plugin reader could not create " + type + ": (" + reason + ") " + this.getElementAsString(element));
    }

    private void connectCategoriesAndItems() {
        for (PaletteItemData item : this.fOrphans) {
            PaletteCategoryData category = item.getCategory();
            String categoryID = null;
            if (category != null) {
                categoryID = category.getId();
            }
            PaletteCategoryData parentCategory = null;
            if (categoryID != null) {
                parentCategory = this.fDefinitions.getCategory(categoryID);
            }
            if (parentCategory != null) {
                parentCategory.add(item);
                continue;
            }
            String itemId = item.getId();
            Logger.log(4, "Rejecting item " + itemId + " is missing category.");
        }
        this.fOrphans.clear();
    }

    public PaletteItemData createSeparator(String categoryID, String id) {
        PaletteItemDataImpl retVal = new PaletteItemDataImpl();
        PaletteCategoryData category = this.fDefinitions.getCategory(categoryID);
        if (id == null) {
            id = String.valueOf(category.getId()) + "." + SEPERATOR_INDICATOR + ".";
            int seperatorCount = 0;
            List<PaletteItemData> children = category.getChildren();
            int i = 0;
            while (i < children.size()) {
                if (children.get(i).isSeparator()) {
                    ++seperatorCount;
                }
                ++i;
            }
            id = String.valueOf(id) + seperatorCount;
        }
        retVal.setCategory(category);
        retVal.setId(id);
        retVal.setIsSeparator(true);
        return retVal;
    }

    public void clearDefinitions() {
        this.fDefinitions = null;
    }

    public void setPreferences(String preferences) {
        this.preferences = preferences;
    }

    public static interface NAMES {
        public static final String ACTIONCONTRIBUTOR = "actionContributor";
        public static final String FEEDBACKCONTRIBUTOR = "feedbackContributor";
        public static final String CATEGORY = "category";
        public static final String ITEM = "item";
        public static final String SEPARATOR = "separator";
        public static final String ID = "id";
        public static final String CLASS = "class";
        public static final String PREF_ID = "com.ibm.etools.webedit.palette.overlay";
        public static final String PREF_DOC_ROOT = "paletteOverlay";
    }
}

