/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.links.util;

import com.ibm.etools.webedit.links.util.ContextRootManager;
import com.ibm.etools.webedit.links.util.FileURL;
import com.ibm.etools.webedit.links.util.InvalidURLException;
import com.ibm.etools.webedit.links.util.ModuleUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class ProjectUtil {
    public static IContainer getContainerOfPath(IPath fullLocalIPath) {
        return ContextRootManager.getDocRootContainer(fullLocalIPath);
    }

    public static IProject getCurrentWebProject() {
        IWorkspaceRoot workspace = ResourcesPlugin.getWorkspace().getRoot();
        if (workspace == null) {
            return null;
        }
        IProject[] projects = workspace.getProjects();
        if (projects == null) {
            return null;
        }
        IProject project = null;
        int i = 0;
        while (i < projects.length) {
            project = projects[i];
            IVirtualComponent vc = ModuleUtil.getComponent((IResource)project);
            if (vc != null) {
                return vc.getProject();
            }
            ++i;
        }
        return null;
    }

    public static IPath getFullPathOfPath(IPath fullLocalIPath) {
        IPath fullPath;
        IContainer container = ProjectUtil.getContainerOfPath(fullLocalIPath);
        if (container != null && (fullPath = container.getFullPath()) != null) {
            return fullPath;
        }
        IWorkspaceRoot workspace = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] projects = workspace.getProjects();
        IProject project = null;
        int i = 0;
        while (i < projects.length) {
            project = projects[i];
            IPath ret = ProjectUtil.getFullPathOfPath(fullLocalIPath, project);
            if (ret != null) {
                return ret;
            }
            ++i;
        }
        return null;
    }

    public static IPath getFullPathOfPath(IPath fullLocalIPath, IContainer docRootContainer) {
        IPath fullPath;
        if (docRootContainer == null) {
            docRootContainer = ProjectUtil.getContainerOfPath(fullLocalIPath);
        }
        if (docRootContainer != null && (fullPath = docRootContainer.getFullPath()) != null) {
            return fullPath;
        }
        IWorkspaceRoot workspace = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] projects = workspace.getProjects();
        IProject project = null;
        int i = 0;
        while (i < projects.length) {
            project = projects[i];
            IPath ret = ProjectUtil.getFullPathOfPath(fullLocalIPath, project);
            if (ret != null) {
                return ret;
            }
            ++i;
        }
        return null;
    }

    public static IPath getFullPathOfPath(IPath fullLocalIPath, IProject project) {
        if (project == null) {
            return null;
        }
        IPath projLoc = project.getLocation();
        if (projLoc != null && projLoc.isPrefixOf(fullLocalIPath)) {
            int seg = projLoc.segmentCount();
            return project.getFullPath().append(fullLocalIPath.removeFirstSegments(seg));
        }
        return null;
    }

    public static IProject getProjectForIPath(IPath fullLocalIPath) {
        IProject project;
        IContainer container = ProjectUtil.getContainerOfPath(fullLocalIPath);
        if (container != null && (project = container.getProject()) != null) {
            return project;
        }
        IWorkspaceRoot workspace = ResourcesPlugin.getWorkspace().getRoot();
        if (workspace == null) {
            return null;
        }
        IProject[] projects = workspace.getProjects();
        if (projects == null) {
            return null;
        }
        IProject project2 = null;
        int i = 0;
        while (i < projects.length) {
            project2 = projects[i];
            if (project2.getLocation().isPrefixOf(fullLocalIPath)) {
                return project2;
            }
            ++i;
        }
        return null;
    }

    public static IProject getProjectForLocalFileURL(String url) {
        FileURL fileURL = null;
        try {
            fileURL = new FileURL(url);
        }
        catch (InvalidURLException invalidURLException) {
            return null;
        }
        return ProjectUtil.getProjectForIPath(fileURL.getPath());
    }

    public static IPath getRequestURIOfPath(IPath fullLocalIPath, IProject project) {
        if (project == null || fullLocalIPath == null) {
            return null;
        }
        IResource res = ProjectUtil.getResource(fullLocalIPath.toString());
        if (res != null) {
            IPath webAppTop = ContextRootManager.getWorkspaceRelativePath(project);
            if (webAppTop == null) {
                webAppTop = project.getLocation();
            }
            if (webAppTop == null) {
                return null;
            }
            if (webAppTop.isPrefixOf(fullLocalIPath)) {
                int seg = webAppTop.segmentCount();
                return fullLocalIPath.removeFirstSegments(seg).setDevice(null).makeAbsolute();
            }
        }
        return null;
    }

    public static IResource getResource(String someLocation) {
        Path rPath = new Path(someLocation);
        IFile resource = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)rPath);
        if (!resource.exists()) {
            resource = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)rPath);
        }
        return resource.exists() ? resource : null;
    }
}

