/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.links.util;

import com.ibm.etools.webedit.links.util.ModuleUtil;
import java.util.WeakHashMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class ContextRootManager {
    private static WeakHashMap serverContextRoots;
    private static WeakHashMap rootFolders;
    private static WeakHashMap projectFacets;
    private static WeakHashMap contextRootToProjects;
    private static WeakHashMap docRootContainers;
    private static int useCount;

    static {
        useCount = 0;
    }

    public static synchronized void initialize() {
        if (useCount <= 0) {
            serverContextRoots = new WeakHashMap(1);
            rootFolders = new WeakHashMap(1);
            projectFacets = new WeakHashMap(2);
            contextRootToProjects = new WeakHashMap(1);
            docRootContainers = new WeakHashMap(1);
        }
        ++useCount;
    }

    public static synchronized void finish() {
        if (--useCount <= 0) {
            serverContextRoots.clear();
            serverContextRoots = null;
            rootFolders.clear();
            rootFolders = null;
            projectFacets.clear();
            projectFacets = null;
            contextRootToProjects.clear();
            contextRootToProjects = null;
            docRootContainers.clear();
            docRootContainers = null;
        }
    }

    public static String getServerContextRoot(IProject project) {
        String serverContextRoot = null;
        try {
            if (project != null && serverContextRoots != null) {
                serverContextRoot = (String)serverContextRoots.get(project);
                if (serverContextRoot != null && serverContextRoot.length() > 0) {
                    return serverContextRoot;
                }
                serverContextRoot = ComponentUtilities.getServerContextRoot((IProject)project);
                if (serverContextRoot != null) {
                    serverContextRoots.put(project, serverContextRoot);
                }
            } else if (project != null) {
                return ComponentUtilities.getServerContextRoot((IProject)project);
            }
        }
        catch (ClassCastException classCastException) {}
        return serverContextRoot;
    }

    public static IPath getWorkspaceRelativePath(IProject project) {
        RootFolderContainer rootFolderContainer = null;
        if (project != null && rootFolders != null) {
            IVirtualComponent component;
            rootFolderContainer = (RootFolderContainer)rootFolders.get(project);
            if (rootFolderContainer == null) {
                rootFolderContainer = new RootFolderContainer();
                rootFolders.put(project, rootFolderContainer);
            }
            if (rootFolderContainer.workspaceRelativePath == null && (component = ModuleUtil.getComponent((IResource)project)) != null) {
                rootFolderContainer.workspaceRelativePath = component.getRootFolder().getWorkspaceRelativePath();
            }
            return rootFolderContainer.workspaceRelativePath;
        }
        IVirtualComponent component = ModuleUtil.getComponent((IResource)project);
        if (component != null) {
            return component.getRootFolder().getWorkspaceRelativePath();
        }
        return null;
    }

    public static IPath getWorkspaceRelativePath(IVirtualComponent component) {
        RootFolderContainer rootFolderContainer = null;
        if (component != null && rootFolders != null) {
            rootFolderContainer = (RootFolderContainer)rootFolders.get(component.getProject());
            if (rootFolderContainer == null) {
                rootFolderContainer = new RootFolderContainer();
                rootFolders.put(component.getProject(), rootFolderContainer);
            }
            if (rootFolderContainer.workspaceRelativePath == null) {
                rootFolderContainer.workspaceRelativePath = component.getRootFolder().getWorkspaceRelativePath();
            }
            return rootFolderContainer.workspaceRelativePath;
        }
        if (component != null) {
            return component.getRootFolder().getWorkspaceRelativePath();
        }
        return null;
    }

    public static String getWorkspaceRelativePathAsString(IVirtualComponent component) {
        IPath workspaceRelativePath = ContextRootManager.getWorkspaceRelativePath(component);
        if (workspaceRelativePath != null) {
            return workspaceRelativePath.toString();
        }
        return null;
    }

    public static String getWorkspaceRelativePathAsString(IProject project) {
        IPath workspaceRelativePath = ContextRootManager.getWorkspaceRelativePath(project);
        if (workspaceRelativePath != null) {
            return workspaceRelativePath.toString();
        }
        return null;
    }

    public static String getProjectRelativePathAsString(IProject project) {
        IPath workspaceRelativePath = ContextRootManager.getProjectRelativePath(project);
        if (workspaceRelativePath != null) {
            return workspaceRelativePath.toString();
        }
        return null;
    }

    public static LinkContainer getValidProjectForContextRoot(IPath relLoc, boolean isAbsolutePath, IProject containerProject, boolean checkForAmbiguity) {
        String key = null;
        LinkContainer validProject = null;
        if (contextRootToProjects != null && containerProject != null && relLoc != null && relLoc.segmentCount() > 0) {
            key = isAbsolutePath ? (checkForAmbiguity ? "11" + containerProject.getName() + relLoc.segment(0) : "10" + containerProject.getName() + relLoc.segment(0)) : (checkForAmbiguity ? "01" + containerProject.getName() + relLoc.segment(0) : "00" + containerProject.getName() + relLoc.segment(0));
            validProject = (LinkContainer)contextRootToProjects.get(key);
        }
        return validProject;
    }

    public static void addValidProjectForContextRoot(IPath relLoc, boolean isAbsolutePath, IProject containerProject, boolean checkForAmbiguity, IProject targetProject, boolean ambiguousLink) {
        String key = null;
        if (contextRootToProjects != null && containerProject != null && relLoc != null && relLoc.segmentCount() > 0) {
            key = isAbsolutePath ? (checkForAmbiguity ? "11" + containerProject.getName() + relLoc.segment(0) : "10" + containerProject.getName() + relLoc.segment(0)) : (checkForAmbiguity ? "01" + containerProject.getName() + relLoc.segment(0) : "00" + containerProject.getName() + relLoc.segment(0));
            contextRootToProjects.put(key, new LinkContainer(targetProject, ambiguousLink));
        }
    }

    private static IFacetedProject getFacetedProject(IProject project) {
        IFacetedProject fProject = null;
        if (project != null) {
            try {
                fProject = ProjectFacetsManager.create((IProject)project);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return fProject;
    }

    private static IProjectFacet getProjectFacet(String facetId) {
        try {
            if (ProjectFacetsManager.isProjectFacetDefined((String)facetId)) {
                return ProjectFacetsManager.getProjectFacet((String)facetId);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        return null;
    }

    public static boolean projectHasFacet(IProject project, String facet) {
        Boolean exists = null;
        if (project != null && projectFacets != null) {
            exists = (Boolean)projectFacets.get(String.valueOf(project.getName()) + facet);
            if (exists == null) {
                IFacetedProject fproject = ContextRootManager.getFacetedProject(project);
                exists = fproject != null && fproject.hasProjectFacet(ContextRootManager.getProjectFacet(facet)) ? new Boolean(true) : new Boolean(false);
                projectFacets.put(String.valueOf(project.getName()) + facet, exists);
            }
        } else {
            IFacetedProject fproject = ContextRootManager.getFacetedProject(project);
            exists = fproject != null && fproject.hasProjectFacet(ContextRootManager.getProjectFacet(facet)) ? new Boolean(true) : new Boolean(false);
        }
        if (exists != null) {
            return exists;
        }
        return false;
    }

    public static IPath getProjectRelativePath(IProject project) {
        RootFolderContainer rootFolderContainer = null;
        if (project != null && rootFolders != null) {
            IVirtualComponent component;
            rootFolderContainer = (RootFolderContainer)rootFolders.get(project);
            if (rootFolderContainer == null) {
                rootFolderContainer = new RootFolderContainer();
                rootFolders.put(project, rootFolderContainer);
            }
            if (rootFolderContainer.projectRelativePath == null && (component = ModuleUtil.getComponent((IResource)project)) != null) {
                rootFolderContainer.projectRelativePath = component.getRootFolder().getProjectRelativePath();
            }
            return rootFolderContainer.projectRelativePath;
        }
        IVirtualComponent component = ModuleUtil.getComponent((IResource)project);
        if (component != null) {
            return component.getRootFolder().getProjectRelativePath();
        }
        return null;
    }

    public static IPath getProjectRelativePath(IVirtualComponent component) {
        RootFolderContainer rootFolderContainer = null;
        if (component != null && rootFolders != null) {
            rootFolderContainer = (RootFolderContainer)rootFolders.get(component.getProject());
            if (rootFolderContainer == null) {
                rootFolderContainer = new RootFolderContainer();
                rootFolders.put(component.getProject(), rootFolderContainer);
            }
            if (rootFolderContainer.projectRelativePath == null) {
                rootFolderContainer.projectRelativePath = component.getRootFolder().getProjectRelativePath();
            }
            return rootFolderContainer.projectRelativePath;
        }
        if (component != null) {
            return component.getRootFolder().getProjectRelativePath();
        }
        return null;
    }

    public static String getRootLocation(IProject project) {
        RootFolderContainer rootFolderContainer = null;
        if (project != null && rootFolders != null) {
            IVirtualComponent component;
            rootFolderContainer = (RootFolderContainer)rootFolders.get(project);
            if (rootFolderContainer == null) {
                rootFolderContainer = new RootFolderContainer();
                rootFolders.put(project, rootFolderContainer);
            }
            if (rootFolderContainer.rootLocation == null && (component = ModuleUtil.getComponent((IResource)project)) != null) {
                rootFolderContainer.rootLocation = component.getRootFolder().getUnderlyingFolder().getLocation().addTrailingSeparator().toString();
            }
            return rootFolderContainer.rootLocation;
        }
        IVirtualComponent component = ModuleUtil.getComponent((IResource)project);
        if (component != null) {
            return component.getRootFolder().getUnderlyingFolder().getLocation().addTrailingSeparator().toString();
        }
        return null;
    }

    public static String getRootLocation(IVirtualComponent component) {
        RootFolderContainer rootFolderContainer = null;
        if (component != null && rootFolders != null) {
            rootFolderContainer = (RootFolderContainer)rootFolders.get(component.getProject());
            if (rootFolderContainer == null) {
                rootFolderContainer = new RootFolderContainer();
                rootFolders.put(component.getProject(), rootFolderContainer);
            }
            if (rootFolderContainer.rootLocation == null) {
                rootFolderContainer.rootLocation = component.getRootFolder().getUnderlyingFolder().getLocation().addTrailingSeparator().toString();
            }
            return rootFolderContainer.rootLocation;
        }
        if (component != null) {
            return component.getRootFolder().getUnderlyingFolder().getLocation().addTrailingSeparator().toString();
        }
        return null;
    }

    public static IContainer getDocRootContainer(IPath docRootPath) {
        if (docRootContainers != null) {
            IContainer docRootContainer = (IContainer)docRootContainers.get(docRootPath);
            if (docRootContainer == null) {
                IWorkspaceRoot workspace = ResourcesPlugin.getWorkspace().getRoot();
                docRootContainer = workspace.getContainerForLocation(docRootPath);
                docRootContainers.put(docRootPath, docRootContainer);
            }
            return docRootContainer;
        }
        IWorkspaceRoot workspace = ResourcesPlugin.getWorkspace().getRoot();
        IContainer docRootContainer = workspace.getContainerForLocation(docRootPath);
        return docRootContainer;
    }

    public static class LinkContainer {
        public IProject project;
        public boolean ambiguousLink;

        public LinkContainer(IProject project, boolean ambiguousLink) {
            this.project = project;
            this.ambiguousLink = ambiguousLink;
        }
    }

    static class RootFolderContainer {
        IPath workspaceRelativePath;
        IPath projectRelativePath;
        String rootLocation;

        RootFolderContainer() {
        }
    }
}

