/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.internal.extension;

import com.ibm.etools.webedit.common.commands.CompoundHTMLCommand;
import com.ibm.etools.webedit.common.commands.HTMLCommand;
import com.ibm.etools.webedit.common.internal.utils.Logger;
import com.ibm.etools.webedit.extension.override.ActionListener;
import com.ibm.etools.webedit.extension.override.ActionListenerProvider;
import com.ibm.etools.webedit.extension.override.CommandExtensionContext;
import com.ibm.etools.webedit.extension.override.CommandExtensionProvider;
import com.ibm.etools.webedit.extension.override.SubCommand;
import com.ibm.etools.webedit.extension.override.SubCommandProvider;
import com.ibm.etools.webedit.internal.extension.OverrideActionRegistryReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class OverrideActionRegistry {
    public static final String PRIORITY_HIGH = "high";
    public static final String PRIORITY_NORMAL = "normal";
    public static final String PRIORITY_LOW = "low";
    private static OverrideActionRegistry instance = new OverrideActionRegistry();
    private OverrideActionRegistryReader reader = OverrideActionRegistryReader.getInstance();
    private ActionListenerProvider[] actionListenerProviders;
    private SubCommandProvider[] subCommandProviders;

    private OverrideActionRegistry() {
    }

    public static OverrideActionRegistry getInstance() {
        return instance;
    }

    public ActionListener[] getActionListeners(String id) {
        if (this.actionListenerProviders == null) {
            this.actionListenerProviders = this.reader.getActionListenerProviders();
        }
        ArrayList<ActionListener> actionListeners = null;
        int i = 0;
        while (i < this.actionListenerProviders.length) {
            ActionListenerProvider provider = this.actionListenerProviders[i];
            ActionListener actionListener = provider.getActionListener(id);
            if (actionListener != null) {
                if (actionListeners == null) {
                    actionListeners = new ArrayList<ActionListener>();
                }
                actionListeners.add(actionListener);
            }
            ++i;
        }
        if (actionListeners == null) {
            return new ActionListener[0];
        }
        return actionListeners.toArray(new ActionListener[actionListeners.size()]);
    }

    public CommandExtensionProvider[] getCommandExtensionProviders(String id, String priority) {
        return this.reader.getCommandExtensionProvider(id, priority);
    }

    public Iterator createProviderIterator(String id) {
        return new IteratorImpl(id);
    }

    public SubCommand[] getSubCommands(String id) {
        if (this.subCommandProviders == null) {
            this.subCommandProviders = this.reader.getSubCommandProviders();
        }
        ArrayList<SubCommand> subCommands = null;
        int i = 0;
        while (i < this.subCommandProviders.length) {
            SubCommandProvider provider = this.subCommandProviders[i];
            SubCommand subCommand = provider.getSubCommand(id);
            if (subCommand != null) {
                if (subCommands == null) {
                    subCommands = new ArrayList<SubCommand>();
                }
                subCommands.add(subCommand);
            }
            ++i;
        }
        if (subCommands == null) {
            return new SubCommand[0];
        }
        return subCommands.toArray(new SubCommand[subCommands.size()]);
    }

    public static HTMLCommand generateExtendedCommand(HTMLCommand defaultCommand, CommandExtensionContext context, String overrideId) {
        HTMLCommand command = defaultCommand;
        Iterator it = OverrideActionRegistry.getInstance().createProviderIterator(overrideId);
        if (it == null || !it.hasNext()) {
            return command;
        }
        CompoundHTMLCommand compoundCommand = new CompoundHTMLCommand(defaultCommand != null ? defaultCommand.getLabel() : overrideId);
        try {
            HTMLCommand newCommand;
            CommandExtensionProvider ocp;
            while (it.hasNext()) {
                ocp = (CommandExtensionProvider)it.next();
                newCommand = ocp.getPreExecuteCommand(context, overrideId);
                if (newCommand == null) continue;
                compoundCommand.append(newCommand);
            }
            if (defaultCommand != null) {
                compoundCommand.append(defaultCommand);
            }
            it = OverrideActionRegistry.getInstance().createProviderIterator(overrideId);
            while (it.hasNext()) {
                ocp = (CommandExtensionProvider)it.next();
                newCommand = ocp.getPostExecuteCommand(context, overrideId);
                if (newCommand == null) continue;
                compoundCommand.append(newCommand);
            }
            int commands = compoundCommand.getCommandList().size();
            if (commands > 1 || defaultCommand == null && commands > 0) {
                command = compoundCommand;
            }
        }
        catch (Exception e) {
            Logger.log(e);
            return defaultCommand;
        }
        return command;
    }

    private class IteratorImpl
    implements Iterator {
        private String id;
        private CommandExtensionProvider[] providers;
        private String priority;
        private int index;

        private IteratorImpl(String id) {
            this.id = id;
            this.priority = OverrideActionRegistry.PRIORITY_HIGH;
            this.providers = OverrideActionRegistry.this.reader.getCommandExtensionProvider(id, this.priority);
        }

        @Override
        public boolean hasNext() {
            if (this.priority.equals(OverrideActionRegistry.PRIORITY_HIGH)) {
                if (this.index < this.providers.length) {
                    return true;
                }
                this.index = 0;
                this.priority = OverrideActionRegistry.PRIORITY_NORMAL;
                this.providers = OverrideActionRegistry.this.reader.getCommandExtensionProvider(this.id, this.priority);
            }
            if (this.priority.equals(OverrideActionRegistry.PRIORITY_NORMAL)) {
                if (this.index < this.providers.length) {
                    return true;
                }
                this.index = 0;
                this.priority = OverrideActionRegistry.PRIORITY_LOW;
                this.providers = OverrideActionRegistry.this.reader.getCommandExtensionProvider(this.id, this.priority);
            }
            return this.priority.equals(OverrideActionRegistry.PRIORITY_LOW) && this.index < this.providers.length;
        }

        public Object next() {
            if (this.hasNext()) {
                return this.providers[this.index++];
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
        }
    }
}

