/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.extension;

import com.ibm.etools.webedit.extension.CommandProvider;
import com.ibm.etools.webedit.extension.EditHint;
import com.ibm.etools.webedit.extension.Request;
import com.ibm.etools.webedit.internal.extension.AbstractRequest;
import com.ibm.etools.webedit.internal.extension.DesignActionProviderRegistry;
import com.ibm.etools.webedit.internal.extension.TaglibURIProvider;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.gef.commands.Command;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class PluggableCommandManager
implements CommandProvider {
    private HashMap map;
    private static PluggableCommandManager instance;
    private CommandProvider nullCommandProvider = new CommandProvider(){

        @Override
        public Command getCommand(String action, Request request) {
            return null;
        }

        @Override
        public EditHint getEditHint(String type, Node realNode, Node node) {
            return null;
        }
    };

    private PluggableCommandManager() {
    }

    public static PluggableCommandManager getInstance() {
        if (instance == null) {
            instance = new PluggableCommandManager();
        }
        return instance;
    }

    @Override
    public Command getCommand(String action, Request request) {
        Node realNode = ((AbstractRequest)request).getRealNode();
        String uri = this.getTaglibURI(realNode);
        List list = DesignActionProviderRegistry.getInstance().getCommandList(uri);
        if (list != null) {
            int i = 0;
            while (i < list.size()) {
                CommandProvider provider;
                Command command;
                IConfigurationElement e = (IConfigurationElement)list.get(i);
                String config = e.getAttribute("name");
                if (this.nameMatches(config, realNode) && (command = (provider = this.getCommandProvider(e)).getCommand(action, request)) != null) {
                    return command;
                }
                ++i;
            }
        }
        return null;
    }

    private CommandProvider getCommandProvider(IConfigurationElement e) {
        CommandProvider provider;
        if (this.map == null) {
            this.map = new HashMap();
        }
        if ((provider = (CommandProvider)this.map.get(e)) == null) {
            provider = DesignActionProviderRegistry.getInstance().createCommandProvider(e);
            if (provider == null) {
                provider = this.nullCommandProvider;
            }
            this.map.put(e, provider);
        }
        return provider;
    }

    @Override
    public EditHint getEditHint(String type, Node realNode, Node node) {
        String uri = this.getTaglibURI(realNode);
        List list = DesignActionProviderRegistry.getInstance().getCommandList(uri);
        if (list != null) {
            int i = 0;
            while (i < list.size()) {
                CommandProvider provider;
                EditHint hint;
                IConfigurationElement e = (IConfigurationElement)list.get(i);
                String config = e.getAttribute("name");
                if (this.nameMatches(config, realNode) && (hint = (provider = this.getCommandProvider(e)).getEditHint(type, realNode, node)) != null) {
                    return hint;
                }
                ++i;
            }
        }
        return null;
    }

    private String getTaglibURI(Node node) {
        TaglibURIProvider finder;
        if (node == null) {
            return null;
        }
        String prefix = null;
        String nodename = node.getNodeName();
        int index = nodename.indexOf(":");
        if (index > 0) {
            prefix = nodename.substring(0, index);
        }
        if (prefix == null) {
            return null;
        }
        Document doc = node.getOwnerDocument();
        if (doc == null) {
            doc = (Document)node;
        }
        if ((finder = (TaglibURIProvider)((INodeNotifier)doc).getAdapterFor(TaglibURIProvider.class)) == null) {
            return null;
        }
        Vector uris = finder.getURIsByPrefix(prefix);
        if (uris != null) {
            return (String)uris.get(0);
        }
        return null;
    }

    private boolean nameMatches(String config, Node node) {
        if (config == null || config.length() == 0) {
            return true;
        }
        String name = node.getLocalName();
        return name != null && config.equalsIgnoreCase(name);
    }
}

