/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.extension;

import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import com.ibm.etools.webedit.common.utils.ActionUtil;
import com.ibm.etools.webedit.extension.DropTargetObject;
import com.ibm.etools.webedit.extension.IDropVisualAction;
import com.ibm.etools.webedit.extension.IExtendedVisualEditor;
import com.ibm.etools.webedit.extension.IHTMLEditorPaneHandler;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.ui.internal.AbstractDropAction;
import org.eclipse.wst.sse.ui.internal.provisional.extensions.ISelfValidateEditAction;
import org.eclipse.wst.sse.ui.internal.provisional.extensions.ISourceEditingTextTools;
import org.w3c.dom.NodeList;
import org.w3c.dom.ranges.Range;

public abstract class AbstractEventDropAction
extends AbstractDropAction
implements IDropVisualAction,
ISelfValidateEditAction {
    static final String SPLIT_PAGE_ID = "Split";

    public final boolean run(DropTargetEvent event, IEditorPart targetEditor) {
        try {
            if (targetEditor instanceof HTMLEditDomain) {
                ISourceEditingTextTools tools;
                if (targetEditor instanceof IHTMLEditorPaneHandler && ((IHTMLEditorPaneHandler)targetEditor).getActivePaneForEditor().equals(SPLIT_PAGE_ID)) {
                    Point pointOfDrag = new Point(event.x, event.y);
                    ((IHTMLEditorPaneHandler)targetEditor).activatePaneAtPoint(pointOfDrag);
                }
                if (((HTMLEditDomain)targetEditor).getActivePageType() == 1 && (tools = (ISourceEditingTextTools)targetEditor.getAdapter(ISourceEditingTextTools.class)) != null) {
                    ITextEditor textEditor;
                    ITextSelection selection = tools.getSelection();
                    ITextSelection textSelection = null;
                    if (selection instanceof ITextSelection) {
                        textSelection = selection;
                    }
                    if ((textEditor = (ITextEditor)targetEditor.getAdapter(ITextEditor.class)) != null && textSelection != null) {
                        ISelectionProvider sp = textEditor.getSelectionProvider();
                        TextSelection sel = new TextSelection(textSelection.getOffset(), 0);
                        sp.setSelection((ISelection)sel);
                        textEditor.selectAndReveal(sel.getOffset(), sel.getLength());
                    }
                }
            }
            return this.doDrop(event, targetEditor);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    @Override
    public DropTargetObject getDropTargetObject(DropTargetEvent event, IEditorPart targetEditor, EditPartViewer viewer) {
        return new DropTargetObject();
    }

    protected Range getTargetRange(IEditorPart targetEditor) {
        if (!(targetEditor instanceof IExtendedVisualEditor)) {
            return null;
        }
        IExtendedVisualEditor visualEditor = (IExtendedVisualEditor)targetEditor;
        return visualEditor.getRange();
    }

    protected NodeList getTargetNodeList(IEditorPart targetEditor) {
        if (!(targetEditor instanceof IExtendedVisualEditor)) {
            return null;
        }
        IExtendedVisualEditor visualEditor = (IExtendedVisualEditor)targetEditor;
        return visualEditor.getSelectedNodeList();
    }

    protected Range getTargetVisualRange(IEditorPart targetEditor) {
        if (!(targetEditor instanceof IExtendedVisualEditor)) {
            return null;
        }
        IExtendedVisualEditor visualEditor = (IExtendedVisualEditor)targetEditor;
        return visualEditor.getVisualRange();
    }

    protected NodeList getTargetVisualNodeList(IEditorPart targetEditor) {
        if (!(targetEditor instanceof IExtendedVisualEditor)) {
            return null;
        }
        IExtendedVisualEditor visualEditor = (IExtendedVisualEditor)targetEditor;
        return visualEditor.getSelectedVisualNodeList();
    }

    protected abstract boolean doDrop(DropTargetEvent var1, IEditorPart var2);

    protected static final HTMLEditDomain getActiveHTMLEditDomain() {
        return ActionUtil.getActiveHTMLEditDomain();
    }
}

