/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.common.utils;

import com.ibm.etools.webedit.common.WebEditCommonPlugin;
import com.ibm.etools.webedit.common.internal.utils.StructuredModelFacade;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.IFileBuffer;
import org.eclipse.core.filebuffers.IFileBufferListener;
import org.eclipse.core.filebuffers.IStateValidationSupport;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;

public class ValidateEditUtil {
    private static final IStatus STATUS_OK = new Status(0, WebEditCommonPlugin.getDefault().getBundle().getSymbolicName(), 0, "OK", null);
    private static final IStatus STATUS_ERROR = new Status(4, WebEditCommonPlugin.getDefault().getBundle().getSymbolicName(), 1, "ERROR", null);

    public static IStatus validateEdit(IFile[] files, IProgressMonitor monitor, Object context, boolean force, boolean validateTextBuffer) {
        final IStatus[] result = new IStatus[1];
        final Context fileContext = new Context(files, force, validateTextBuffer);
        result[0] = fileContext.validateTargets(force);
        if (result[0] != null) {
            return result[0];
        }
        IFile[] candidates = fileContext.getValidateEditFiles();
        ISchedulingRule rule = ResourcesPlugin.getWorkspace().getRuleFactory().validateEditRule((IResource[])candidates);
        try {
            try {
                final boolean fForce = force;
                final Object fContext = context;
                IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        result[0] = fileContext.validateTargets(fForce);
                        if (result[0] != null) {
                            return;
                        }
                        IFile[] targetFiles = fileContext.getValidateEditFiles();
                        try {
                            fileContext.validationStateAboutToBeChanged();
                            fileContext.processPreValidation();
                            result[0] = ResourcesPlugin.getWorkspace().validateEdit(targetFiles, fContext);
                            fileContext.processPostValidation();
                            fileContext.validationStateChanged(true, result[0]);
                        }
                        catch (RuntimeException runtimeException) {
                            fileContext.validationStateChangeFailed();
                        }
                    }
                };
                ResourcesPlugin.getWorkspace().run(runnable, rule, 1, monitor);
            }
            catch (CoreException coreException) {
                ErrorDialog.openError((Shell)((Shell)context), null, null, (IStatus)fileContext.getExceptionStatus());
                IStatus iStatus = STATUS_ERROR;
                fileContext.processAfterWorkspaceOperation();
                return iStatus;
            }
        }
        finally {
            fileContext.processAfterWorkspaceOperation();
        }
        if (result[0] == null) {
            return STATUS_ERROR;
        }
        if (result[0].getSeverity() == 8) {
            return STATUS_ERROR;
        }
        if (result[0].isOK()) {
            if (fileContext.hasException()) {
                ErrorDialog.openError((Shell)((Shell)context), null, null, (IStatus)fileContext.getExceptionStatus());
                return STATUS_ERROR;
            }
            if (fileContext.isModifiedByValidatoin()) {
                return STATUS_ERROR;
            }
            return result[0];
        }
        return result[0];
    }

    public static IStatus validateEdit(IStructuredModel model, Shell context, boolean nonExistAsWritable) {
        File f;
        if (model == null) {
            return STATUS_ERROR;
        }
        String location = StructuredModelFacade.getBaseLocation(model);
        if (location == null || location.length() == 0) {
            return STATUS_ERROR;
        }
        Path fullIPath = new Path(location);
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)fullIPath);
        if (file == null && fullIPath != null && (f = new File(fullIPath.toOSString())).exists() && f.canWrite()) {
            return STATUS_OK;
        }
        return ValidateEditUtil.validateEdit(file, context, nonExistAsWritable);
    }

    public static IStatus validateEdit(IFile file, Shell context, boolean nonExistAsWritable) {
        if (file == null) {
            return STATUS_ERROR;
        }
        if (!file.exists()) {
            return nonExistAsWritable ? STATUS_OK : STATUS_ERROR;
        }
        if (!file.isReadOnly()) {
            return STATUS_OK;
        }
        return ValidateEditUtil.validateEdit(new IFile[]{file}, (IProgressMonitor)new NullProgressMonitor(), context, true, true);
    }

    public static boolean handleValidateReadOnly(final IFile[] readOnlyFilesArray) {
        final boolean[] validateEditDone = new boolean[1];
        final boolean[] refreshed = new boolean[1];
        Display display = Display.getDefault();
        if (display != null) {
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    Shell shell;
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    if (window != null && (shell = window.getShell()) != null) {
                        refreshed[0] = ValidateEditUtil.validateEdit(readOnlyFilesArray, shell);
                        validateEditDone[0] = true;
                    }
                }
            });
        }
        if (!validateEditDone[0]) {
            refreshed[0] = ValidateEditUtil.validateEdit(readOnlyFilesArray, null);
        }
        return refreshed[0];
    }

    static boolean validateEdit(IFile[] readOnlyFilesArray, Shell shell) {
        IStatus status = ValidateEditUtil.validateEdit(readOnlyFilesArray, null, shell, true, true);
        return status.isOK();
    }

    static class Context {
        private final ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        private final FileBufferListener listener = new FileBufferListener();
        private final List dataList;
        private final boolean force;
        private final List exceptions = new ArrayList(1);

        public Context(IFile[] files, boolean force, boolean useFileBuffer) {
            this.dataList = new ArrayList(files.length);
            int i = 0;
            while (i < files.length) {
                IFile file = files[i];
                IFileBasedValidateEditData data = new IFileBasedValidateEditData(file, this.manager, useFileBuffer);
                this.dataList.add(data);
                ++i;
            }
            this.force = force;
        }

        public IStatus validateTargets(boolean force) {
            for (IFileBasedValidateEditData data : this.dataList) {
                if (!data.isValid()) {
                    return STATUS_ERROR;
                }
                if (!data.isBadTarget(force)) continue;
                return STATUS_ERROR;
            }
            this.removeNonValidateEditCandidate();
            if (this.dataList.isEmpty()) {
                return STATUS_OK;
            }
            return null;
        }

        private void removeNonValidateEditCandidate() {
            Iterator iter = this.dataList.iterator();
            while (iter.hasNext()) {
                IFileBasedValidateEditData data = (IFileBasedValidateEditData)iter.next();
                if (data.isValidateEditCandidate(this.force)) continue;
                iter.remove();
            }
        }

        public void validationStateAboutToBeChanged() {
            for (IFileBasedValidateEditData data : this.dataList) {
                data.lockBuffer();
            }
            this.removeNonValidateEditCandidate();
            for (IFileBasedValidateEditData data : this.dataList) {
                data.validationStateAboutToBeChanged();
            }
        }

        public IFile[] getValidateEditFiles() {
            ArrayList<IFile> result = new ArrayList<IFile>(this.dataList.size());
            for (IFileBasedValidateEditData data : this.dataList) {
                result.add(data.getFile());
            }
            return result.toArray(new IFile[result.size()]);
        }

        public void processPreValidation() {
            this.manager.addFileBufferListener((IFileBufferListener)this.listener);
            for (IFileBasedValidateEditData data : this.dataList) {
                data.processPreValidation(this.force);
            }
        }

        public void processPostValidation() {
            for (IFileBasedValidateEditData data : this.dataList) {
                try {
                    data.processPostValidation();
                }
                catch (CoreException e) {
                    this.exceptions.add(e);
                }
            }
        }

        public void validationStateChanged(boolean state, IStatus status) {
            for (IFileBasedValidateEditData data : this.dataList) {
                data.validationStateChanged(state, status);
            }
        }

        public void validationStateChangeFailed() {
            for (IFileBasedValidateEditData data : this.dataList) {
                data.validationStateChangeFailed();
            }
        }

        public void processAfterWorkspaceOperation() {
            this.manager.removeFileBufferListener((IFileBufferListener)this.listener);
        }

        public boolean isModifiedByValidatoin() {
            Set modifiedBuffers = this.listener.getContentReplacedFiles();
            for (IFileBasedValidateEditData data : this.dataList) {
                if (!data.isModifiedByValidatoin(modifiedBuffers)) continue;
                return true;
            }
            return false;
        }

        public boolean hasException() {
            return !this.exceptions.isEmpty();
        }

        public IStatus getExceptionStatus() {
            if (this.exceptions.isEmpty()) {
                return STATUS_OK;
            }
            MultiStatus result = new MultiStatus(WebEditCommonPlugin.getDefault().getBundle().getSymbolicName(), 4, ((Throwable)this.exceptions.get(0)).getMessage(), null);
            for (Throwable e : this.exceptions) {
                result.add(this.createStatus(e));
            }
            return result;
        }

        private IStatus createStatus(Throwable e) {
            if (e == null) {
                return STATUS_OK;
            }
            return new Status(4, WebEditCommonPlugin.getDefault().getBundle().getSymbolicName(), 0, e.getMessage(), e);
        }

        protected static class FileBufferListener
        implements IFileBufferListener {
            private final HashSet contentReplacedFileSet = new HashSet();

            protected FileBufferListener() {
            }

            public void bufferContentReplaced(IFileBuffer buffer) {
                IFile file = FileBuffers.getWorkspaceFileAtLocation((IPath)buffer.getLocation());
                if (file != null) {
                    this.contentReplacedFileSet.add(file);
                }
            }

            public Set getContentReplacedFiles() {
                return Collections.unmodifiableSet(this.contentReplacedFileSet);
            }

            public void bufferContentAboutToBeReplaced(IFileBuffer buffer) {
            }

            public void bufferCreated(IFileBuffer buffer) {
            }

            public void bufferDisposed(IFileBuffer buffer) {
            }

            public void dirtyStateChanged(IFileBuffer buffer, boolean isDirty) {
            }

            public void stateChangeFailed(IFileBuffer buffer) {
            }

            public void stateChanging(IFileBuffer buffer) {
            }

            public void stateValidationChanged(IFileBuffer buffer, boolean isStateValidated) {
            }

            public void underlyingFileDeleted(IFileBuffer buffer) {
            }

            public void underlyingFileMoved(IFileBuffer buffer, IPath path) {
            }
        }
    }

    static class IFileBasedValidateEditData {
        private IFile file;
        private ITextFileBufferManager manager;
        private boolean useFileBuffer;
        private ITextFileBuffer buffer;
        private long beforeModifiedFromJavaIO;
        private long beforeModifiedFromIFile;

        public IFileBasedValidateEditData(IFile file, ITextFileBufferManager manager, boolean useFileBuffer) {
            this.file = file;
            this.manager = manager;
            this.useFileBuffer = useFileBuffer;
        }

        public IFile getFile() {
            return this.file;
        }

        public boolean isValid() {
            return this.buffer != null || this.file != null && this.file.exists();
        }

        private ITextFileBuffer getBuffer() {
            if (!this.useFileBuffer) {
                return null;
            }
            if (this.buffer != null) {
                return this.buffer;
            }
            if (this.isValid()) {
                return this.manager.getTextFileBuffer(this.file.getFullPath(), LocationKind.IFILE);
            }
            return null;
        }

        public boolean isBadTarget(boolean force) {
            if (force) {
                return false;
            }
            ITextFileBuffer buffer = this.getBuffer();
            return buffer != null && buffer.isStateValidated();
        }

        public boolean isValidateEditCandidate(boolean force) {
            ITextFileBuffer buffer = this.getBuffer();
            if (buffer != null) {
                return !buffer.isStateValidated() || force;
            }
            return this.file.isReadOnly();
        }

        public void lockBuffer() {
            if (this.buffer != null) {
                return;
            }
            this.buffer = this.getBuffer();
        }

        public void validationStateAboutToBeChanged() {
            if (this.buffer instanceof IStateValidationSupport) {
                ((IStateValidationSupport)this.buffer).validationStateAboutToBeChanged();
            }
        }

        public void processPreValidation(boolean force) {
            if (force && this.buffer != null && this.buffer.isStateValidated()) {
                this.buffer.resetStateValidation();
            }
            this.beforeModifiedFromJavaIO = this.file.getLocation().toFile().lastModified();
            this.beforeModifiedFromIFile = this.file.getModificationStamp();
        }

        public void processPostValidation() throws CoreException {
            long afterModifiedFromJavaIO;
            long afterModifiedFromIFile = this.file.getModificationStamp();
            if (this.beforeModifiedFromIFile == afterModifiedFromIFile && this.beforeModifiedFromJavaIO != (afterModifiedFromJavaIO = this.file.getLocation().toFile().lastModified())) {
                this.file.refreshLocal(0, null);
            }
        }

        public void validationStateChanged(boolean state, IStatus status) {
            if (this.buffer instanceof IStateValidationSupport) {
                ((IStateValidationSupport)this.buffer).validationStateChanged(state, status);
            }
        }

        public void validationStateChangeFailed() {
            if (this.buffer instanceof IStateValidationSupport) {
                ((IStateValidationSupport)this.buffer).validationStateChangeFailed();
            }
        }

        public boolean isModifiedByValidatoin(Set modifiedBuffers) {
            if (this.buffer != null) {
                return modifiedBuffers.contains(this.buffer);
            }
            long afterModifiedFromIFile = this.file.getModificationStamp();
            return this.beforeModifiedFromIFile != afterModifiedFromIFile;
        }
    }
}

