/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.common.utils;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IconAndMessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public abstract class MessageWithDetailsDialog
extends IconAndMessageDialog {
    private String title;
    private Button detailsButton;
    private Composite detailsAreaComposite;
    private Control detailsArea;
    private boolean isDetailsAreaVisible;

    public MessageWithDetailsDialog(Shell parentShell, String dialogTitle, String dialogMessage) {
        super(parentShell);
        this.title = dialogTitle;
        this.message = dialogMessage;
        this.setShellStyle(67696);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
    }

    protected Image getImage() {
        return this.getInfoImage();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.getHelpId());
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4) * 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.horizontalSpan = 2;
        composite.setLayoutData((Object)data);
        this.createMessageArea(composite);
        this.createSubDialogArea(composite);
        this.detailsButton = this.createDetailsButton(parent);
        this.detailsAreaComposite = this.createDetailsAreaComposite(parent);
        return parent;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 13) {
            this.toggleDetailsArea();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected abstract Control createSubDialogArea(Composite var1);

    protected Button createDetailsButton(Composite parent) {
        Button button = this.createButton(parent, 13, this.getDetailsButtonLabelForShow(), false);
        GridData data = new GridData(128);
        data.horizontalSpan = 2;
        button.setLayoutData((Object)data);
        return button;
    }

    protected String getDetailsButtonLabelForShow() {
        return IDialogConstants.SHOW_DETAILS_LABEL;
    }

    protected String getDetailsButtonLabelForHide() {
        return IDialogConstants.HIDE_DETAILS_LABEL;
    }

    protected Composite createDetailsAreaComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.horizontalSpan = 2;
        data.heightHint = 0;
        composite.setLayoutData((Object)data);
        return composite;
    }

    protected void toggleDetailsArea() {
        Point dialogSize = this.getShell().getSize();
        Point size = this.getContents().computeSize(-1, -1);
        if (this.isDetailsAreaVisible()) {
            ((GridData)this.detailsAreaComposite.getLayoutData()).heightHint = 0;
            this.detailsArea.dispose();
            this.isDetailsAreaVisible = false;
            this.detailsButton.setText(this.getDetailsButtonLabelForShow());
        } else {
            ((GridData)this.detailsAreaComposite.getLayoutData()).heightHint = -1;
            this.detailsArea = this.createDetailsArea(this.detailsAreaComposite);
            MessageWithDetailsDialog.applyDialogFont((Control)this.detailsArea);
            this.isDetailsAreaVisible = true;
            this.detailsButton.setText(this.getDetailsButtonLabelForHide());
        }
        Composite composite = (Composite)this.getDialogArea();
        composite.layout();
        Point newSize = this.getContents().computeSize(-1, -1);
        this.getShell().setSize(dialogSize.x, dialogSize.y + newSize.y - size.y);
    }

    protected boolean isDetailsAreaVisible() {
        return this.isDetailsAreaVisible;
    }

    protected abstract Control createDetailsArea(Composite var1);

    protected abstract String getHelpId();
}

