/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.common.utils;

import com.ibm.etools.webedit.common.utils.FileExtensions;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.wst.html.core.internal.HTMLCorePlugin;

public class FileTypeUtil
implements FileExtensions {
    public static final int FTYPE_UNKNOWN = 0;
    public static final int FTYPE_HTML = 1;
    public static final int FTYPE_IMG = 2;
    public static final int FTYPE_SOUND = 3;
    public static final int FTYPE_CLASS = 4;
    public static final int FTYPE_CSS = 5;
    public static final int FTYPE_JAVASCRIPT = 6;
    public static final int FTYPE_TEXT = 7;
    public static final int FTYPE_CSV = 8;
    public static final int FTYPE_CDF = 9;
    public static final int FTYPE_URL = 10;
    public static final int FTYPE_LNK = 11;
    public static final int FTYPE_TPL = 12;
    public static final int FTYPE_WML = 13;
    public static final int FTYPE_APPLET = 14;
    public static final int FTYPE_XHTML = 15;
    public static final int TYPE_HTML_SUPPORT = 0;
    public static final int TYPE_HTM = 1;
    public static final int TYPE_HTML = 2;
    public static final int TYPE_JSP = 3;
    public static final int TYPE_SHTML = 4;
    public static final int TYPE_HTML_OTHER = 5;
    public static final int FTYPE_JSP = 12;
    public static final int FTYPE_JSA = 13;
    public static final int FTYPE_JAR = 14;
    public static final int FTYPE_JHTML = 15;
    public static final int FTYPE_ASP = 16;
    public static final int FTYPE_VXML = 17;
    public static final int FTYPE_JSV = 18;
    public static final int FTYPE_RULE = 19;
    public static final int FTYPE_MOVIE = 20;
    public static final int FTYPE_LAYOUT = 21;
    public static final int FTYPE_VBSCRIPT = 22;
    public static final int FTYPE_FLASH = 24;
    public static final int FTYPE_JAVA = 25;
    public static final int FTYPE_MEDIAPLAYER = 26;
    public static final int FTYPE_REALAUDIO = 27;
    public static final int FTYPE_SHOCKWAVE = 28;
    public static final int FTYPE_GENERICPLAYER = 29;
    public static final int IMAGE_BMP = 1;
    public static final int IMAGE_GIF = 2;
    public static final int IMAGE_ICO = 3;
    public static final int IMAGE_JPEG = 4;
    public static final int IMAGE_PNG = 5;
    public static final int IMAGE_TIFF = 6;
    public static final int IMAGE_MIF = 8;
    public static final int IMAGE_DCM = 9;
    public static final int IMAGE_PCD = 10;
    public static final int IMAGE_FPX = 11;
    public static final int IMAGE_EMF = 12;
    public static final int IMAGE_WMF = 13;
    public static final int IMAGE_XBITMAP = 14;
    public static final int IMAGE_PSD = 15;
    public static final int IMAGE_ETC = 16;
    public static final int IMAGE_WBMP = 17;

    public static String followShortCut(String filename) {
        int type = FileTypeUtil.whatKindOfFile(filename);
        if (type != 11) {
            // empty if block
        }
        return filename;
    }

    public static String[] getFileExtensions(int fileType) {
        switch (fileType) {
            case 3: {
                return EXTENSIONS_FOR_SOUND;
            }
            case 2: {
                return EXTENSIONS_FOR_IMAGE_SUPPORT;
            }
            case 12: {
                return EXTENSIONS_FOR_HTML_JSP;
            }
            case 15: {
                return EXTENSIONS_FOR_HTML_JHTML;
            }
            case 1: {
                return EXTENSIONS_FOR_HTML_HTML;
            }
            case 7: {
                return EXTENSIONS_FOR_TEXT;
            }
            case 8: {
                return EXTENSIONS_FOR_CSV;
            }
            case 24: {
                return EXTENSIONS_FOR_FLASH;
            }
            case 26: {
                return EXTENSIONS_FOR_MEDIAPLAYER;
            }
            case 27: {
                return EXTENSIONS_FOR_REALAUDIO;
            }
            case 28: {
                return EXTENSIONS_FOR_SHOCKWAVE;
            }
            case 29: {
                return EXTENSIONS_FOR_GENERICPLAYER;
            }
            case 5: {
                return EXTENSIONS_FOR_CSS;
            }
        }
        return null;
    }

    public static String[] getFileExtensionsForHtml(int htmltype) {
        switch (htmltype) {
            case 0: {
                return EXTENSIONS_FOR_HTML_SUPPORT;
            }
            case 2: {
                return EXTENSIONS_FOR_HTML;
            }
            case 1: {
                return EXTENSIONS_FOR_HTM;
            }
            case 3: {
                return EXTENSIONS_FOR_JSP;
            }
            case 4: {
                return EXTENSIONS_FOR_SHTML;
            }
            case 5: {
                return EXTENSIONS_FOR_HTML_OTHER;
            }
        }
        return null;
    }

    public static String[] getFileExtensionsForImage(int imagetype) {
        switch (imagetype) {
            case 2: {
                return EXTENSIONS_FOR_IMAGE_GIF;
            }
            case 4: {
                return EXTENSIONS_FOR_IMAGE_JPG;
            }
            case 5: {
                return EXTENSIONS_FOR_IMAGE_PNG;
            }
            case 8: {
                return EXTENSIONS_FOR_IMAGE_MIF;
            }
            case 17: {
                return EXTENSIONS_FOR_IMAGE_WBMP;
            }
        }
        return null;
    }

    public static int whatKindOfFile(String filename) {
        return FileTypeUtil.whatKindOfFile((IPath)new Path(filename));
    }

    public static int whatKindOfFile(IPath path) {
        String optExt;
        if (FileTypeUtil.isSupportedImageFormat(FileTypeUtil.whatKindOfImage(path))) {
            return 2;
        }
        String ext = path.getFileExtension();
        if (ext == null) {
            return 0;
        }
        if (FileTypeUtil.isSupportedHtmlFile(ext)) {
            return 1;
        }
        if (ext.equalsIgnoreCase("htpl") || ext.equalsIgnoreCase("jtpl")) {
            return 12;
        }
        if (ext.equalsIgnoreCase("jar")) {
            return 14;
        }
        if (ext.equalsIgnoreCase("css")) {
            return 5;
        }
        if (ext.equalsIgnoreCase("txt")) {
            return 7;
        }
        if (ext.equalsIgnoreCase("mid") || ext.equalsIgnoreCase("wav") || ext.equalsIgnoreCase("aif") || ext.equalsIgnoreCase("aiff") || ext.equalsIgnoreCase("aifc") || ext.equalsIgnoreCase("mp3") || ext.equalsIgnoreCase("snd") || ext.equalsIgnoreCase("au")) {
            return 3;
        }
        if (ext.equalsIgnoreCase("class")) {
            return 4;
        }
        if (ext.equalsIgnoreCase("java")) {
            return 25;
        }
        if (ext.equalsIgnoreCase("csv")) {
            return 8;
        }
        if (ext.equalsIgnoreCase("url")) {
            return 10;
        }
        if (ext.equalsIgnoreCase("lnk")) {
            return 11;
        }
        if (ext.equalsIgnoreCase("jsa")) {
            return 13;
        }
        if (ext.equalsIgnoreCase("js")) {
            return 6;
        }
        if (ext.equalsIgnoreCase("vb")) {
            return 22;
        }
        if (ext.equalsIgnoreCase("avi") || ext.equalsIgnoreCase("mov") || ext.equalsIgnoreCase("qt") || ext.equalsIgnoreCase("wmv") || ext.equalsIgnoreCase("asf")) {
            return 20;
        }
        if (ext.equalsIgnoreCase("mpe") || ext.equalsIgnoreCase("mpg") || ext.equalsIgnoreCase("mpa") || ext.equalsIgnoreCase("mp2") || ext.equalsIgnoreCase("wma") || ext.equalsIgnoreCase("mpeg") || ext.equalsIgnoreCase("m1v")) {
            return 20;
        }
        if (ext.equalsIgnoreCase("vxml") || ext.equalsIgnoreCase("vxm")) {
            return 17;
        }
        if (ext.equalsIgnoreCase("jsv")) {
            return 18;
        }
        if (ext.equalsIgnoreCase("hhc") || ext.equalsIgnoreCase("hhk")) {
            return 1;
        }
        if (ext.equalsIgnoreCase("cdf")) {
            return 9;
        }
        if (ext.equalsIgnoreCase("swf")) {
            return 24;
        }
        if (ext.equalsIgnoreCase("wml")) {
            return 13;
        }
        Preferences prefs = HTMLCorePlugin.getDefault().getPluginPreferences();
        if (prefs != null && (optExt = prefs.getString("defaultExtension")) != null && optExt.length() > 0 && optExt.compareToIgnoreCase(ext) == 0) {
            return 1;
        }
        return 0;
    }

    public static boolean isSupportedImageFormat(int tp) {
        switch (tp) {
            case 2: 
            case 4: 
            case 5: 
            case 8: 
            case 17: {
                return true;
            }
            case 1: 
            case 3: {
                return true;
            }
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                return false;
            }
        }
        return false;
    }

    public static int whatKindOfImage(String filename) {
        return FileTypeUtil.whatKindOfImage((IPath)new Path(filename));
    }

    public static int whatKindOfImage(IPath path) {
        String ext = path.getFileExtension();
        if (ext == null) {
            return 16;
        }
        if (ext.equalsIgnoreCase("bmp")) {
            return 1;
        }
        if (ext.equalsIgnoreCase("tif") || ext.equalsIgnoreCase("tiff")) {
            return 6;
        }
        if (ext.equalsIgnoreCase("gif")) {
            return 2;
        }
        if (ext.equalsIgnoreCase("jpg") || ext.equalsIgnoreCase("jpeg") || ext.equalsIgnoreCase("jpe")) {
            return 4;
        }
        if (ext.equalsIgnoreCase("png")) {
            return 5;
        }
        if (ext.equalsIgnoreCase("xbm")) {
            return 14;
        }
        if (ext.equalsIgnoreCase("fpx")) {
            return 11;
        }
        if (ext.equalsIgnoreCase("pcd")) {
            return 10;
        }
        if (ext.equalsIgnoreCase("psd")) {
            return 15;
        }
        if (ext.equalsIgnoreCase("mif")) {
            return 8;
        }
        if (ext.equalsIgnoreCase("dcm")) {
            return 9;
        }
        if (ext.equalsIgnoreCase("wmf")) {
            return 13;
        }
        if (ext.equalsIgnoreCase("emf")) {
            return 12;
        }
        if (ext.equalsIgnoreCase("ico")) {
            return 3;
        }
        if (ext.equalsIgnoreCase("wbmp")) {
            return 17;
        }
        return 16;
    }

    private static boolean isSupportedHtmlFile(String ext) {
        int i = 0;
        while (i < FileExtensions.EXTENSIONS_FOR_HTML_SUPPORT.length) {
            if (ext.equalsIgnoreCase(FileExtensions.EXTENSIONS_FOR_HTML_SUPPORT[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

