/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.common.utils;

import com.ibm.etools.webedit.common.internal.utils.ImageDescriptorUtil;
import com.ibm.etools.webedit.common.utils.IColorDropperListener;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;

public class ColorDropper
implements SelectionListener,
Runnable {
    private static Cursor cursor;
    private final Display display;
    private Button colorRefButton;
    private Image fImage;
    private Point fExtent;
    private Color fColor;
    private Button newButton;
    private Shell newShell;
    private Collection listeners;

    public ColorDropper(Display display, Button colorRefButton) {
        this.display = display;
        this.colorRefButton = colorRefButton;
    }

    public void addColorDropperListener(IColorDropperListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    private void fireColorDropped(RGB retColor) {
        if (this.listeners == null) {
            return;
        }
        IColorDropperListener[] colorListeners = new IColorDropperListener[this.listeners.size()];
        this.listeners.toArray(colorListeners);
        int i = 0;
        while (i < colorListeners.length) {
            colorListeners[i].colorDropped(retColor);
            ++i;
        }
    }

    private void fireColorDropCanceled() {
        if (this.listeners == null) {
            return;
        }
        IColorDropperListener[] colorListeners = new IColorDropperListener[this.listeners.size()];
        this.listeners.toArray(colorListeners);
        int i = 0;
        while (i < colorListeners.length) {
            colorListeners[i].colorDropCanceled();
            ++i;
        }
    }

    public void removeColorDroppperListener(IColorDropperListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    protected void close() {
        if (this.newShell != null && !this.newShell.isDisposed()) {
            this.newButton.dispose();
            this.newShell.setCapture(false);
            this.newShell.close();
            if (this.fImage != null) {
                this.fImage.dispose();
            }
            if (this.fColor != null) {
                this.fColor.dispose();
            }
            this.fImage = null;
            this.fColor = null;
            this.newButton = null;
            this.newShell = null;
        }
    }

    protected Point computeImageSize(Control window) {
        if (this.colorRefButton != null && this.colorRefButton.getImage() != null) {
            Rectangle rect = this.colorRefButton.getImage().getBounds();
            return new Point(rect.width, rect.height);
        }
        GC gc = new GC((Drawable)window);
        Font f = JFaceResources.getFontRegistry().get("org.eclipse.jface.defaultfont");
        gc.setFont(f);
        Point p = gc.textExtent("X");
        gc.dispose();
        p.x = p.y * 3 - 6;
        return p;
    }

    protected RGB getColor(int x, int y) {
        if (this.newShell == null || this.newShell.isDisposed()) {
            return null;
        }
        GC gc = new GC((Drawable)this.newShell.getDisplay());
        Image img = new Image((Device)this.newShell.getDisplay(), 1, 1);
        gc.copyArea(img, x, y);
        ImageData data = img.getImageData();
        if (img != null) {
            img.dispose();
        }
        if (gc != null) {
            gc.dispose();
        }
        return data.palette.getRGB(data.getPixel(0, 0));
    }

    @Override
    public void run() {
        if (this.newShell != null) {
            return;
        }
        GC gc = new GC((Drawable)this.display);
        Monitor[] monitors = this.display.getMonitors();
        final Rectangle[] monitorBounds = new Rectangle[monitors.length];
        final Image[] fullImages = new Image[monitors.length];
        int i = 0;
        while (i < monitors.length) {
            monitorBounds[i] = monitors[i].getBounds();
            fullImages[i] = new Image((Device)this.display, monitorBounds[i].width, monitorBounds[i].height);
            gc.copyArea(fullImages[i], monitorBounds[i].x, monitorBounds[i].y);
            ++i;
        }
        if (gc != null) {
            gc.dispose();
        }
        this.newShell = new Shell(this.display, 131080);
        final Button newDummyButton = new Button((Composite)this.newShell, 8);
        this.newButton = new Button((Composite)this.newShell, 8);
        this.fExtent = this.computeImageSize((Control)this.newShell);
        this.fImage = new Image((Device)this.newShell.getDisplay(), this.fExtent.x, this.fExtent.y);
        PaintListener paintListener = new PaintListener(){

            public void paintControl(PaintEvent e) {
                int i = 0;
                while (i < monitorBounds.length) {
                    e.gc.drawImage(fullImages[i], monitorBounds[i].x, monitorBounds[i].y);
                    ++i;
                }
            }
        };
        this.newShell.addPaintListener(paintListener);
        MouseAdapter mouseListener = new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                RGB retColor = ColorDropper.this.getColor(e.x, e.y);
                ColorDropper.this.close();
                if (e.button == 1) {
                    ColorDropper.this.fireColorDropped(retColor);
                } else {
                    ColorDropper.this.fireColorDropCanceled();
                }
            }
        };
        this.newShell.addMouseListener((MouseListener)mouseListener);
        this.newButton.addMouseListener((MouseListener)mouseListener);
        MouseMoveListener mouseMoveListener = new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                RGB color = ColorDropper.this.getColor(e.x, e.y);
                ColorDropper.this.updateColorImage(ColorDropper.this.display, color);
            }
        };
        this.newShell.addMouseMoveListener(mouseMoveListener);
        this.newButton.addMouseMoveListener(mouseMoveListener);
        KeyAdapter keyListener = new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u001b') {
                    ColorDropper.this.close();
                    ColorDropper.this.fireColorDropCanceled();
                } else if (e.keyCode == 0x1000001) {
                    Point pt = ColorDropper.this.display.getCursorLocation();
                    if (pt.y > 0) {
                        --pt.y;
                        ColorDropper.this.display.setCursorLocation(pt);
                    }
                } else if (e.keyCode == 0x1000002) {
                    Point pt = ColorDropper.this.display.getCursorLocation();
                    if (pt.y < ((ColorDropper)ColorDropper.this).display.getBounds().height) {
                        ++pt.y;
                        ColorDropper.this.display.setCursorLocation(pt);
                    }
                } else if (e.keyCode == 0x1000003) {
                    Point pt = ColorDropper.this.display.getCursorLocation();
                    if (pt.x > 0) {
                        --pt.x;
                        ColorDropper.this.display.setCursorLocation(pt);
                    }
                } else if (e.keyCode == 0x1000004) {
                    Point pt = ColorDropper.this.display.getCursorLocation();
                    if (pt.x < ((ColorDropper)ColorDropper.this).display.getBounds().width) {
                        ++pt.x;
                        ColorDropper.this.display.setCursorLocation(pt);
                    }
                } else if (e.character == '\r' || e.character == ' ' || Character.getNumericValue(e.character) == -1) {
                    Point pt = ColorDropper.this.display.getCursorLocation();
                    RGB retColor = ColorDropper.this.getColor(pt.x, pt.y);
                    ColorDropper.this.close();
                    ColorDropper.this.fireColorDropped(retColor);
                }
            }
        };
        this.newShell.addKeyListener((KeyListener)keyListener);
        this.newButton.addKeyListener((KeyListener)keyListener);
        newDummyButton.addKeyListener((KeyListener)keyListener);
        this.newShell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellActivated(ShellEvent event) {
                if (cursor == null) {
                    try {
                        ImageData src = ImageDescriptorUtil.createImageDescriptor("full/dnd/pickerCursor_source.bmp").getImageData();
                        ImageData mask = ImageDescriptorUtil.createImageDescriptor("full/dnd/pickerCursor_mask.bmp").getImageData();
                        ColorDropper.cursor = new Cursor((Device)ColorDropper.this.newShell.getDisplay(), src, mask, 0, 16);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (SWTError sWTError) {}
                    if (cursor == null) {
                        ColorDropper.cursor = new Cursor((Device)ColorDropper.this.newShell.getDisplay(), 21);
                    }
                    ColorDropper.this.newShell.addDisposeListener(new DisposeListener(){

                        public void widgetDisposed(DisposeEvent e) {
                            if (e.widget instanceof Shell) {
                                if (cursor != null && !cursor.isDisposed()) {
                                    cursor.dispose();
                                    ColorDropper.cursor = null;
                                }
                                int i = 0;
                                while (i < fullImages.length) {
                                    fullImages[i].dispose();
                                    ++i;
                                }
                            }
                        }
                    });
                }
                ColorDropper.this.newShell.setCapture(true);
                ColorDropper.this.newShell.setCursor(cursor);
                Rectangle rect = ColorDropper.this.colorRefButton.getBounds();
                Point leftTop = ColorDropper.this.colorRefButton.toDisplay(new Point(0, 0));
                rect.x = leftTop.x;
                rect.y = leftTop.y;
                ColorDropper.this.newButton.setBounds(rect);
                rect = ColorDropper.this.display.getBounds();
                newDummyButton.setBounds(0, 0, 0, 0);
                newDummyButton.setText("");
                newDummyButton.setFocus();
                ColorDropper.this.newShell.removeShellListener((ShellListener)this);
            }
        });
        this.newShell.setBounds(this.newShell.getDisplay().getBounds());
        this.newShell.setDefaultButton(newDummyButton);
        this.newShell.open();
    }

    public void setColorRefButton(Button button) {
        this.colorRefButton = button;
    }

    protected void updateColorImage(Display display, RGB rgb) {
        GC gc = new GC((Drawable)this.fImage);
        if (rgb != null) {
            gc.setBackground(display.getSystemColor(22));
            gc.fillRectangle(0, 0, this.fExtent.x, this.fExtent.y);
            gc.setForeground(display.getSystemColor(2));
            gc.drawRectangle(0, 2, this.fExtent.x - 1, this.fExtent.y - 4);
            if (this.fColor != null) {
                this.fColor.dispose();
            }
            this.fColor = new Color((Device)display, rgb);
            gc.setBackground(this.fColor);
            gc.fillRectangle(1, 3, this.fExtent.x - 2, this.fExtent.y - 5);
        } else {
            gc.setBackground(display.getSystemColor(22));
            gc.fillRectangle(0, 2, this.fExtent.x, this.fExtent.y - 3);
        }
        gc.dispose();
        this.newButton.setImage(this.fImage);
        this.newButton.redraw();
    }

    public void widgetSelected(SelectionEvent e) {
        this.display.asyncExec((Runnable)this);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public static boolean dropperAllowed() {
        return true;
    }
}

