/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.common.preference;

import com.ibm.etools.webedit.common.preference.ScrolledPageContent;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;

public class ExpandablePreferencePage
extends PreferencePage {
    private final ArrayList expandedComposites = new ArrayList();
    private final String SETTINGS_EXPANDED = "expanded";

    protected Control createContents(Composite parent) {
        return null;
    }

    public ExpandableComposite createExpandableComposite(Composite parent, String title, int noOfColumns) {
        ExpandableComposite exComposite = new ExpandableComposite(parent, 0, 18);
        exComposite.setText(title);
        exComposite.setExpanded(false);
        exComposite.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        exComposite.setLayoutData((Object)new GridData(4, 4, true, false, noOfColumns, 1));
        exComposite.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                ExpandablePreferencePage.this.expandedStateChanged((ExpandableComposite)e.getSource());
            }
        });
        this.expandedComposites.add(exComposite);
        return exComposite;
    }

    protected final void expandedStateChanged(ExpandableComposite expandable) {
        ScrolledPageContent parentScrolledComposite = this.getParentScrolledComposite((Control)expandable);
        if (parentScrolledComposite != null) {
            parentScrolledComposite.reflow(true);
        }
    }

    protected ScrolledPageContent getParentScrolledComposite(Control control) {
        Composite parent = control.getParent();
        while (!(parent instanceof ScrolledPageContent) && parent != null) {
            parent = parent.getParent();
        }
        if (parent instanceof ScrolledPageContent) {
            return (ScrolledPageContent)parent;
        }
        return null;
    }

    protected void restoreSectionExpansionStates(IDialogSettings settings) {
        int i = 0;
        while (i < this.expandedComposites.size()) {
            ExpandableComposite excomposite = (ExpandableComposite)this.expandedComposites.get(i);
            if (settings == null) {
                excomposite.setExpanded(i == 0);
            } else {
                excomposite.setExpanded(settings.getBoolean("expanded" + String.valueOf(i)));
            }
            ++i;
        }
    }

    protected void storeSectionExpansionStates(IDialogSettings settings) {
        int i = 0;
        while (i < this.expandedComposites.size()) {
            ExpandableComposite curr = (ExpandableComposite)this.expandedComposites.get(i);
            settings.put("expanded" + String.valueOf(i), curr.isExpanded());
            ++i;
        }
    }
}

