/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.common.internal.utils;

import com.ibm.etools.webedit.common.commands.utils.EditModelQuery;
import com.ibm.etools.webedit.common.commands.utils.EditQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMText;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FreeLayoutUtilBase {
    public static boolean isLayoutTable(Node node) {
        EditModelQuery editModelQuery;
        if (node != null && node.getNodeType() == 1 && (editModelQuery = EditQueryUtil.getEditQuery(node.getOwnerDocument())) != null && editModelQuery.isTableElement((Element)node)) {
            Node child = node.getFirstChild();
            while (child != null) {
                IDOMElement elem;
                if (child.getNodeType() != 1) {
                    child = child.getNextSibling();
                    continue;
                }
                if (child instanceof IDOMElement && (elem = (IDOMElement)child).isCommentTag() && elem.getTagName().equalsIgnoreCase("flm:table")) {
                    return true;
                }
                child = child.getNextSibling();
            }
        }
        return false;
    }

    public static boolean isLayoutCell(Node node) {
        boolean isCellEle;
        if (node.getNodeType() != 1) {
            return false;
        }
        EditModelQuery query = EditQueryUtil.getEditQuery(node.getOwnerDocument());
        boolean bl = isCellEle = query != null && query.isCellElement((Element)node);
        if (!isCellEle) {
            return false;
        }
        boolean isEmptyCell = FreeLayoutUtilBase.isEmptyCell((Element)node);
        if (isEmptyCell && FreeLayoutUtilBase.getCommentElementForLayoutCell(node) != null || !isEmptyCell) {
            Node parent = node.getParentNode();
            while (parent instanceof Element && !query.isTableElement((Element)parent)) {
                parent = parent.getParentNode();
            }
            if (FreeLayoutUtilBase.isLayoutTable(parent)) {
                return true;
            }
        }
        return false;
    }

    public static Node getCommentElementForLayoutCell(Node node) {
        EditModelQuery editModelQuery;
        if (node != null && node.getNodeType() == 1 && (editModelQuery = EditQueryUtil.getEditQuery(node.getOwnerDocument())) != null && editModelQuery.isCellElement((Element)node)) {
            Element found = FreeLayoutUtilBase.traverseForCommentElement(node);
            if (found != null && editModelQuery.isCellElement(found)) {
                found = null;
            }
            return found;
        }
        return null;
    }

    public static Element traverseForCommentElement(Node node) {
        if (node != null) {
            Node non_null_sibling = node;
            Node target = non_null_sibling.getPreviousSibling();
            while (true) {
                String name;
                if (target == null) {
                    if ((non_null_sibling = non_null_sibling.getParentNode()) == null) break;
                    if (non_null_sibling.getNodeType() == 1 && ((name = ((Element)non_null_sibling).getTagName()) == null || "TR".equalsIgnoreCase(name))) {
                        return null;
                    }
                    target = non_null_sibling.getPreviousSibling();
                    continue;
                }
                if (target.getNodeType() != 1) {
                    target = target.getPreviousSibling();
                    continue;
                }
                name = ((Element)target).getTagName();
                if (name == null) {
                    return null;
                }
                if (target instanceof IDOMElement && ((IDOMElement)target).isCommentTag() && "flm:cell".equalsIgnoreCase(name)) {
                    return (Element)target;
                }
                if ("TD".equalsIgnoreCase(name) || "TH".equalsIgnoreCase(name)) {
                    return (Element)target;
                }
                if ("TR".equalsIgnoreCase(name) || "TBODY".equalsIgnoreCase(name) || "THEAD".equalsIgnoreCase(name) || "TFOOT".equalsIgnoreCase(name) || "TABLE".equalsIgnoreCase(name)) {
                    return null;
                }
                Node child = target.getLastChild();
                if (child == null) {
                    target = target.getPreviousSibling();
                    continue;
                }
                non_null_sibling = child;
                target = child;
            }
        }
        return null;
    }

    public static boolean isEmptyCell(Element element) {
        Node child = element.getFirstChild();
        if (child == null) {
            return true;
        }
        boolean emptyContent = false;
        while (child != null) {
            if (!emptyContent && (FreeLayoutUtilBase.isEmptyImage(child) || FreeLayoutUtilBase.isNBSPOnlyText(child))) {
                emptyContent = true;
                child = child.getNextSibling();
                continue;
            }
            if (!FreeLayoutUtilBase.isEmptyText(child)) {
                return false;
            }
            child = child.getNextSibling();
        }
        return true;
    }

    private static boolean isEmptyImage(Node node) {
        if (node.getNodeType() != 1) {
            return false;
        }
        if (!node.getNodeName().equalsIgnoreCase("IMG")) {
            return false;
        }
        String id = ((Element)node).getAttribute("id");
        return id != null && id.equalsIgnoreCase("flm:spacer");
    }

    private static boolean isNBSPOnlyText(Node node) {
        if (node.getNodeType() != 3) {
            return false;
        }
        String content = ((IDOMText)node).getValueSource().trim();
        return content.equalsIgnoreCase("&nbsp;");
    }

    private static boolean isEmptyText(Node node) {
        if (node.getNodeType() != 3) {
            return false;
        }
        String content = node.getNodeValue().trim();
        int i = 0;
        while (i < content.length()) {
            if (!Character.isWhitespace(content.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

