/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.common.internal.commands.utils;

import com.ibm.etools.webedit.common.internal.commands.utils.IFragmentDetector;
import java.util.ArrayList;
import java.util.List;

public class FragmentDetectorRegistry {
    private static FragmentDetectorRegistry instance;
    private static IFragmentDetector[] NULL_DETECTORS;
    private List detectors;

    private FragmentDetectorRegistry() {
    }

    public static FragmentDetectorRegistry getInstance() {
        if (instance == null) {
            instance = new FragmentDetectorRegistry();
        }
        return instance;
    }

    public void registerDetector(IFragmentDetector detector) {
        if (this.detectors == null) {
            this.detectors = new ArrayList();
        }
        if (!this.detectors.contains(detector)) {
            this.detectors.add(detector);
        }
    }

    public IFragmentDetector unregisterDetector(IFragmentDetector detector) {
        if (this.detectors == null) {
            return null;
        }
        if (this.detectors.contains(detector)) {
            this.detectors.remove(detector);
            return detector;
        }
        return null;
    }

    public IFragmentDetector[] getDetectors() {
        if (this.detectors == null || this.detectors.size() <= 0) {
            if (NULL_DETECTORS == null) {
                NULL_DETECTORS = new IFragmentDetector[0];
            }
            return NULL_DETECTORS;
        }
        IFragmentDetector[] array = new IFragmentDetector[this.detectors.size()];
        this.detectors.toArray(array);
        return array;
    }
}

