/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.common.internal.attrview;

import com.ibm.etools.webedit.common.attrview.AbstractTagLabelProvider;
import com.ibm.etools.webedit.common.attrview.TagLabelProvider;
import com.ibm.etools.webedit.common.internal.utils.Logger;
import com.ibm.etools.webedit.internal.extension.RegistryReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.custom.BusyIndicator;
import org.osgi.framework.Bundle;

public class TagLabelProviderRegistryReader
extends RegistryReader {
    protected static final String TAG_PROVIDER = "provider";
    protected static final String ATT_CLASS = "class";
    protected static final String ATT_SINGLETON = "singleton";
    protected static final String ATT_METHOD = "method";
    protected static final String ATT_PRIORITY = "priority";
    protected static final String[] PRIORITIES = new String[]{"highest", "high", "mid", "low", "lowest"};
    protected static final String TRUE = "true";
    private String pluginId;
    private String extensionPoint;
    private IConfigurationElement[] configurations;
    private HashMap providerMap;
    private ArrayList cache;
    private TagLabelProvider nullProvider = new NullTagLabelProvider();

    public TagLabelProviderRegistryReader(String pluginId, String extensionPoint) {
        this.pluginId = pluginId;
        this.extensionPoint = extensionPoint;
    }

    public static TagLabelProvider createProviderInstance(IConfigurationElement element) {
        Object obj = null;
        try {
            obj = TagLabelProviderRegistryReader.createExtension(element, ATT_CLASS);
            if (obj instanceof TagLabelProvider) {
                return (TagLabelProvider)obj;
            }
        }
        catch (Exception e) {
            Logger.log(e);
        }
        return null;
    }

    public static Object createExtension(final IConfigurationElement element, final String classAttribute) throws CoreException {
        Bundle bundle = Platform.getBundle((String)element.getDeclaringExtension().getContributor().getName());
        if (bundle != null && (bundle.getState() == 8 || bundle.getState() == 32 || bundle.getState() == 16)) {
            return TagLabelProviderRegistryReader.createExecutableExtension(element, classAttribute);
        }
        final Object[] ret = new Object[1];
        final CoreException[] exc = new CoreException[1];
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    ret[0] = TagLabelProviderRegistryReader.createExecutableExtension(element, classAttribute);
                }
                catch (CoreException e) {
                    exc[0] = e;
                }
            }
        });
        if (exc[0] != null) {
            throw exc[0];
        }
        return ret[0];
    }

    static Object createExecutableExtension(IConfigurationElement element, String classAttribute) throws CoreException {
        Object obj = null;
        String singleton = element.getAttribute(ATT_SINGLETON);
        String method = element.getAttribute(ATT_METHOD);
        if (TRUE.equalsIgnoreCase(singleton) && method != null) {
            try {
                String name = element.getAttribute(ATT_CLASS);
                Bundle bundle = Platform.getBundle((String)element.getDeclaringExtension().getContributor().getName());
                Class cls = null;
                if (bundle != null) {
                    cls = bundle.loadClass(name);
                }
                Method mtd = cls.getMethod(method, new Class[0]);
                obj = mtd.invoke(null, null);
            }
            catch (ClassNotFoundException classNotFoundException) {
                obj = null;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                obj = null;
            }
            catch (IllegalAccessException illegalAccessException) {
                obj = null;
            }
            catch (InvocationTargetException invocationTargetException) {
                obj = null;
            }
        } else {
            obj = element.createExecutableExtension(classAttribute);
        }
        return obj;
    }

    public IConfigurationElement[] getConfigurations() {
        if (this.configurations == null) {
            this.readContributions(this.pluginId, this.extensionPoint);
            int num = this.cache.size();
            if (num == 0) {
                this.configurations = new IConfigurationElement[0];
            }
            ArrayList<IConfigurationElement> list = new ArrayList<IConfigurationElement>();
            int p = 0;
            while (p < PRIORITIES.length) {
                int i = 0;
                while (i < num) {
                    IConfigurationElement element;
                    Object obj = this.cache.get(i);
                    if (obj instanceof IConfigurationElement && (PRIORITIES[p].equals((element = (IConfigurationElement)obj).getAttribute(ATT_PRIORITY)) || p == 2 && element.getAttribute(ATT_PRIORITY) == null)) {
                        list.add(element);
                    }
                    ++i;
                }
                ++p;
            }
            this.configurations = list.toArray(new IConfigurationElement[list.size()]);
            this.cache.clear();
            this.cache = null;
        }
        return this.configurations;
    }

    public TagLabelProvider getProvider(IConfigurationElement config, boolean create) {
        TagLabelProvider provider;
        if (this.providerMap == null) {
            this.providerMap = new HashMap();
        }
        if ((provider = (TagLabelProvider)this.providerMap.get(config)) == null && create) {
            provider = TagLabelProviderRegistryReader.createProviderInstance(config);
            if (provider == null) {
                provider = this.nullProvider;
            }
            this.providerMap.put(config, provider);
        }
        return provider;
    }

    private void readContributions(String pluginId, String extensionPoint) {
        this.cache = new ArrayList();
        this.readRegistry(Platform.getExtensionRegistry(), pluginId, extensionPoint);
    }

    @Override
    protected boolean readElement(IConfigurationElement element) {
        String tag = element.getName();
        if (tag.equals(TAG_PROVIDER)) {
            this.cache.add(element);
            return true;
        }
        this.readElementChildren(element);
        return true;
    }

    private class NullTagLabelProvider
    extends AbstractTagLabelProvider {
        private NullTagLabelProvider() {
        }
    }
}

