/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.common.commands.utils;

import com.ibm.etools.webedit.common.commands.utils.AbstractEditRange;
import com.ibm.etools.webedit.common.commands.utils.EditModelQuery;
import com.ibm.etools.webedit.common.commands.utils.EditQueryUtil;
import org.w3c.dom.Node;
import org.w3c.dom.ranges.Range;

public class ReplaceNode
extends AbstractEditRange {
    public ReplaceNode(Range range) {
        super(range);
    }

    public void replace(Node oldNode, Node newNode) {
        if (oldNode == null || newNode == null) {
            return;
        }
        EditModelQuery squery = EditQueryUtil.getEditQuery(oldNode);
        Node parent = oldNode.getParentNode();
        if (parent == null || squery == null) {
            return;
        }
        Range range = this.getRange();
        if (range != null) {
            Node pre = range.getStartContainer();
            int preOffset = range.getStartOffset();
            Node post = range.getEndContainer();
            int postOffset = range.getEndOffset();
            if (oldNode == pre) {
                range.setStart(newNode, preOffset);
            } else if (squery.isAncestor(oldNode, pre)) {
                range.setStart(newNode, 0);
            }
            if (oldNode == post) {
                range.setEnd(newNode, postOffset);
            } else if (squery.isAncestor(oldNode, post)) {
                range.setEnd(newNode, 0);
            }
        }
        parent.insertBefore(newNode, oldNode);
        parent.removeChild(oldNode);
    }

    public void insertBefore(Node beforeNode, Node newNode) {
        if (beforeNode == null || newNode == null) {
            return;
        }
        EditModelQuery squery = EditQueryUtil.getEditQuery(beforeNode);
        Node parent = beforeNode.getParentNode();
        if (parent == null || squery == null) {
            return;
        }
        Range range = this.getRange();
        if (range != null) {
            Node pre = range.getStartContainer();
            int preOffset = range.getStartOffset();
            Node post = range.getEndContainer();
            int postOffset = range.getEndOffset();
            int index = squery.getChildIndex(beforeNode);
            if (beforeNode == pre.getParentNode() && preOffset >= index) {
                range.setStart(pre.getParentNode(), preOffset + 1);
            }
            if (beforeNode == post.getParentNode() && postOffset >= index) {
                range.setEnd(pre.getParentNode(), postOffset + 1);
            }
        }
        parent.insertBefore(newNode, beforeNode);
    }

    public void appendChild(Node parentNode, Node newNode) {
        if (parentNode == null || newNode == null) {
            return;
        }
        EditModelQuery squery = EditQueryUtil.getEditQuery(parentNode);
        Node parent = parentNode.getParentNode();
        if (parent == null || squery == null) {
            return;
        }
        parentNode.appendChild(newNode);
    }
}

