/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.common.commands.utils;

import com.ibm.etools.webedit.common.commands.utils.EditModelQuery;
import com.ibm.etools.webedit.common.commands.utils.EditQueryUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class EditModelAction {
    public void copyAttribute(Element from, Element to, boolean only_available_attributes) {
        if (from == null || to == null) {
            return;
        }
        NamedNodeMap map = from.getAttributes();
        EditModelQuery query = EditQueryUtil.getEditQuery(from);
        if (query == null) {
            return;
        }
        int i = 0;
        while (i < map.getLength()) {
            Attr attr = (Attr)map.item(i);
            String name = attr.getName();
            String value = attr.getValue();
            if (!(name == null || only_available_attributes && (value != null ? (!query.isAttributeValueAvailable(from, name, value) ? query.isAttributeValueAvailable(to, name, value) : !query.isAttributeValueAvailable(to, name, value)) : (!query.isAttributeAvailable(from, name) ? query.isAttributeAvailable(to, name) : !query.isAttributeAvailable(to, name))))) {
                to.setAttribute(name, value);
            }
            ++i;
        }
    }

    public void copyAttribute(Element from, Element to, boolean removeAfterCopied, String[] ignoreAttributes) {
        if (from == null || to == null) {
            return;
        }
        NamedNodeMap map = from.getAttributes();
        int i = 0;
        while (i < map.getLength()) {
            Attr attr = (Attr)map.item(i);
            String name = attr.getName();
            String value = attr.getValue();
            if (name != null) {
                boolean ignore = false;
                if (ignoreAttributes != null && ignoreAttributes.length > 0) {
                    int k = 0;
                    while (k < ignoreAttributes.length) {
                        if (ignoreAttributes[k].equalsIgnoreCase(name)) {
                            ignore = true;
                            break;
                        }
                        ++k;
                    }
                }
                if (!ignore) {
                    to.setAttribute(name, value);
                    if (removeAfterCopied) {
                        from.removeAttribute(name);
                    }
                }
            }
            ++i;
        }
    }

    public void removeAttribute(Element of, Element in) {
        if (of == null || in == null) {
            return;
        }
        NamedNodeMap map = in.getAttributes();
        int i = 0;
        while (i < map.getLength()) {
            Attr attr = (Attr)map.item(i);
            of.removeAttribute(attr.getName());
            ++i;
        }
    }
}

