/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.common.commands.utils;

import com.ibm.etools.webedit.common.commands.utils.CommandConstants;
import com.ibm.etools.webedit.common.commands.utils.CommandRangeUtil;
import com.ibm.etools.webedit.common.commands.utils.EditModelQuery;
import com.ibm.etools.webedit.common.commands.utils.EditQueryUtil;
import com.ibm.etools.webedit.common.commands.utils.RemoveTag;
import com.ibm.etools.webedit.common.utils.ReadOnlySupport;
import com.ibm.etools.webedit.extension.DesignTimeTagUtil;
import org.eclipse.wst.xml.core.internal.document.NodeListImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.ranges.Range;

public class CommandTreeManipulator {
    private Range range = null;
    private static final String[] sequence = new String[]{"TITLE", "ISINDEX", "BASE"};
    private static final String[] style_sequence = new String[]{"LINK", "STYLE"};
    private static final String GENERATOR = "GENERATOR";
    private static final String CONTENT_TYPE = "CONTENT-TYPE";

    public CommandTreeManipulator(Range range) {
        this.range = range;
    }

    private boolean isParentBody(Node body) {
        EditModelQuery query = EditQueryUtil.getEditQuery(body);
        if (query == null) {
            return false;
        }
        Node parentCandidate = body;
        while (parentCandidate != null) {
            if (parentCandidate.getNodeType() != 1 || !((IDOMElement)parentCandidate).isCommentTag()) break;
            parentCandidate = parentCandidate.getParentNode();
        }
        return query.isRenderRoot(parentCandidate);
    }

    private Node determineNodeRegion(NodeRegion region, NodeRegion regionPtag, NodeRegion orgRegion, Node current, Node parent) {
        EditModelQuery query = EditQueryUtil.getEditQuery(orgRegion.getStart());
        if (query == null) {
            return null;
        }
        boolean isParentBody = this.isParentBody(parent);
        while (current != null) {
            boolean canAdaptContain = false;
            boolean canContain = query.canContain(parent, current);
            if (!canContain && !query.isExcluded(parent, current)) {
                Document doc = CommandTreeManipulator.getSafeDocument(parent);
                Element ptag = doc != null ? doc.createElement("P") : null;
                boolean bl = canAdaptContain = query.canContain(ptag, current) && query.canContain(parent, ptag);
            }
            if (!canContain && !canAdaptContain || current.getNodeType() == 3 && !region.isEmpty() && query.isEmptyText((Text)current)) {
                if (!regionPtag.isEmpty()) {
                    if (region.isEmpty()) break;
                    current = current.getPreviousSibling();
                    break;
                }
                region.appendNode(current);
            } else if (isParentBody || canAdaptContain) {
                if (!region.isEmpty()) {
                    if (regionPtag.isEmpty()) break;
                    current = current.getPreviousSibling();
                    break;
                }
                regionPtag.appendNode(current);
            }
            current = orgRegion.isEnd(current) ? null : current.getNextSibling();
        }
        return current;
    }

    private void adaptParagraph(NodeRegion regionPtag, boolean isParentBody) {
        EditModelQuery query = EditQueryUtil.getEditQuery(regionPtag.getStart());
        if (query == null) {
            return;
        }
        Document doc = CommandTreeManipulator.getSafeDocument(regionPtag.getStart());
        Element adapted_ptag = null;
        Element ptag = doc != null ? doc.createElement("P") : null;
        Node adapt = ptag != null ? regionPtag.getStart() : null;
        while (adapt != null) {
            Node next = adapt.getNextSibling();
            if (!(!query.canContain(ptag, adapt) || adapted_ptag == null && isParentBody && query.loveBody(adapt))) {
                boolean adaptParagraph = true;
                if (adapt.getNodeType() == 3 && query.isEmptyText((Text)adapt)) {
                    if (adapted_ptag == null) {
                        adaptParagraph = false;
                    }
                } else {
                    Node prev = adapt.getPreviousSibling();
                    if (prev != null) {
                        if (prev.getNodeType() == 3 && !query.isEmptyText((Text)prev)) {
                            adaptParagraph = false;
                            break;
                        }
                        if (adapted_ptag == null && isParentBody && !query.loveBody(prev) && query.canContain(ptag, prev)) {
                            adaptParagraph = false;
                            break;
                        }
                    }
                }
                if (adaptParagraph) {
                    boolean endbefore;
                    boolean startafter = CommandRangeUtil.isContainerAfter(adapt, this.range, true);
                    boolean startbefore = startafter ? false : CommandRangeUtil.isContainerBefore(adapt, this.range, true);
                    boolean endafter = CommandRangeUtil.isContainerAfter(adapt, this.range, false);
                    boolean bl = endbefore = endafter ? false : CommandRangeUtil.isContainerBefore(adapt, this.range, false);
                    if (adapted_ptag == null) {
                        adapted_ptag = (Element)ptag.cloneNode(false);
                        adapt.getParentNode().insertBefore(adapted_ptag, adapt);
                    }
                    adapt = new RemoveTag(this.range, true).removeNode(adapt);
                    adapted_ptag.appendChild(adapt);
                    if (startafter) {
                        this.range.setStartAfter(adapt);
                    } else if (startbefore) {
                        this.range.setStartBefore(adapt);
                    }
                    if (endafter) {
                        this.range.setEndAfter(adapt);
                    } else if (endbefore) {
                        this.range.setEndBefore(adapt);
                    }
                } else {
                    adapted_ptag = null;
                }
            } else {
                adapted_ptag = null;
            }
            if (regionPtag.isEnd(adapt)) break;
            adapt = next;
        }
    }

    private NodeRegion moveToDocLevelMarkup(NodeRegion region) {
        EditModelQuery query = EditQueryUtil.getEditQuery(region.getStart());
        if (query == null) {
            return region;
        }
        Node node = region.getStart();
        Document doc = CommandTreeManipulator.getSafeDocument(node);
        Node remainedStartNode = region.getStart();
        while (true) {
            RemoveTag rtag;
            Node nodeNext = node.getNextSibling();
            Element checkHtml = doc.createElement("HTML");
            Element checkHead = doc.createElement("HEAD");
            Element checkBody = doc.createElement("BODY");
            Node html = query.getHtmlCorrespondentNode(doc, false);
            Node head = query.getHeadCorrespondentNode(doc, false);
            Element body = query.getBodyElement(doc, false);
            if (query.canContain(checkHtml, node) && !query.canContain(checkBody, node)) {
                rtag = new RemoveTag(this.range, true);
                node = rtag.removeNode(node);
                if (html == null) {
                    html = query.getHtmlCorrespondentNode(doc, true);
                }
                this.moveToBeforeHtml(html, node, false);
                remainedStartNode = !region.isEnd(node) ? nodeNext : null;
            } else if (query.canContain(checkHead, node) && !query.canContain(checkBody, node)) {
                node = new RemoveTag(this.range).removeNode(node);
                if (head == null) {
                    head = query.getHeadCorrespondentNode(doc, true);
                }
                this.moveToHead(head, node, false);
                remainedStartNode = !region.isEnd(node) ? nodeNext : null;
            } else if (node.getNodeType() == 1 && query.isHeadCorrespondent(node)) {
                if (head == null) {
                    head = query.getHeadCorrespondentNode(doc, true);
                }
                this.moveToHead(head, node.getFirstChild(), node.getLastChild(), true);
                rtag = new RemoveTag(this.range, true);
                node = rtag.removeNode(node);
                remainedStartNode = !region.isEnd(node) ? nodeNext : null;
            } else if (body != null && node.getNodeType() == 1 && query.isRenderRoot(node)) {
                int i = 0;
                while (i < CommandConstants.BODY_TEXT_ATTRIBUTES.length) {
                    Attr attr = ((Element)node).getAttributeNode(CommandConstants.BODY_TEXT_ATTRIBUTES[i]);
                    if (attr != null) {
                        body.setAttribute(attr.getNodeName(), attr.getNodeValue());
                    }
                    ++i;
                }
                rtag = new RemoveTag(this.range, true);
                Node node2 = remainedStartNode = !region.isEnd(node = rtag.removeNode(node)) ? nodeNext : null;
            }
            if (region.isEnd(node)) break;
            node = nodeNext;
        }
        return new NodeRegion(remainedStartNode, remainedStartNode != null ? region.getEnd() : null);
    }

    public Node promote(Node first, Node last, Node root, boolean moveToHead) {
        return this.promote(new NodeRegion(first, last), root, moveToHead);
    }

    private Node promote(NodeRegion orgRegion, Node root, boolean moveToHead) {
        if (orgRegion == null || orgRegion.isEmpty()) {
            return null;
        }
        EditModelQuery query = EditQueryUtil.getEditQuery(orgRegion.getStart());
        if (query == null) {
            return null;
        }
        Node current = orgRegion.getStart();
        Node parent = current.getParentNode();
        while (parent != null) {
            Node grandParent = parent.getParentNode();
            while (current != null) {
                NodeRegion region = new NodeRegion();
                NodeRegion regionPtag = new NodeRegion();
                current = this.determineNodeRegion(region, regionPtag, orgRegion, current, parent);
                if (!regionPtag.isEmpty()) {
                    this.adaptParagraph(regionPtag, this.isParentBody(parent));
                }
                if (region.isEmpty()) continue;
                if (moveToHead) {
                    region = this.moveToDocLevelMarkup(region);
                }
                if (region.isEmpty()) continue;
                if (!query.isSplitableNode(parent) || grandParent == null) {
                    Node adaptor = null;
                    Node adapt = region.getStart();
                    while (adapt != null) {
                        Node next = adapt.getNextSibling();
                        boolean startafter = false;
                        boolean startbefore = false;
                        boolean endafter = false;
                        boolean endbefore = false;
                        if (!region.isEnd(adapt)) {
                            startafter = CommandRangeUtil.isContainerAfter(adapt, this.range, true);
                            endafter = CommandRangeUtil.isContainerAfter(adapt, this.range, false);
                        }
                        if (!region.isStart(adapt)) {
                            startbefore = startafter ? false : CommandRangeUtil.isContainerBefore(adapt, this.range, true);
                            endbefore = endafter ? false : CommandRangeUtil.isContainerBefore(adapt, this.range, false);
                        }
                        adaptor = this.adapt(adapt, this.range, adaptor != null);
                        if (startafter) {
                            this.range.setStartAfter(adapt);
                        } else if (startbefore) {
                            this.range.setStartBefore(adapt);
                        }
                        if (endafter) {
                            this.range.setEndAfter(adapt);
                        } else if (endbefore) {
                            this.range.setEndBefore(adapt);
                        }
                        if (region.isEnd(adapt)) break;
                        adapt = next;
                    }
                    if (grandParent == null || adaptor != null) continue;
                }
                Node prev = region.getPrev();
                Node next = region.getNext();
                if (prev != null) {
                    Node cloned = null;
                    boolean split = false;
                    Node n = grandParent;
                    while (n != null) {
                        if (query.canContain(n, region.getStart())) {
                            split = true;
                            break;
                        }
                        n = n.getParentNode();
                    }
                    if (next != null && split && !query.isLogicalElement(parent)) {
                        RemoveTag rtag = new RemoveTag(this.range, true);
                        cloned = parent.cloneNode(false);
                        while (next != null) {
                            Node nextNext = next.getNextSibling();
                            next = rtag.removeNode(next);
                            cloned.appendChild(next);
                            next = nextNext;
                        }
                        if (query.isEmptyNode(cloned)) {
                            rtag = new RemoveTag(this.range);
                            rtag.removeNode(cloned);
                        } else {
                            grandParent.insertBefore(cloned, parent.getNextSibling());
                        }
                    }
                    parent = this.moveRegionUp(region, root, moveToHead, parent, true, true);
                    if (cloned != null) {
                        parent = cloned;
                    }
                } else {
                    parent = this.moveRegionUp(region, root, moveToHead, parent, false, next == null);
                }
                if (parent == null || !this.isChildrenEmpty(parent)) continue;
                RemoveTag rtag = new RemoveTag(this.range);
                rtag.removeNode(parent);
            }
            if (parent == root) break;
            parent = grandParent;
        }
        return null;
    }

    private Node moveRegionUp(NodeRegion region, Node root, boolean moveToHead, Node parent, boolean moveAfter, boolean handleRange) {
        Node node;
        EditModelQuery query = EditQueryUtil.getEditQuery(region.getStart());
        if (query == null) {
            return parent;
        }
        RemoveTag rtag = new RemoveTag(this.range, true);
        Node target = node = region.getStart();
        while (node != null) {
            boolean resetRange = false;
            int off = 0;
            if (region.isEnd(node)) {
                Node counterNode = region.getEnd();
                while (counterNode != null) {
                    ++off;
                    counterNode = counterNode.getPreviousSibling();
                }
                resetRange = this.range.getCollapsed() && this.range.getStartContainer() == parent && off == this.range.getStartOffset() || this.range.getStartContainer() == node && node.getNodeType() == 3 && query.isEmptyText((Text)node);
            }
            Node nodeNext = node.getNextSibling();
            node = rtag.removeNode(node);
            parent.getParentNode().insertBefore(node, moveAfter ? parent.getNextSibling() : parent);
            if (target == null || node.getNodeType() != 3 || !query.isEmptyText((Text)node)) {
                target = node;
            }
            if (region.isEnd(node)) {
                if (handleRange && resetRange) {
                    off = target.getNodeType() == 3 ? ((Text)target).getData().length() : target.getChildNodes().getLength();
                    this.range.setStart(target, off);
                    this.range.setEnd(target, off);
                }
                if (this.isChildrenEmpty(parent)) {
                    rtag = new RemoveTag(this.range);
                    rtag.removeNode(parent);
                    parent = null;
                }
                this.promote(region, root, moveToHead);
                break;
            }
            node = nodeNext;
        }
        return parent;
    }

    private boolean isChildrenEmpty(Node node) {
        EditModelQuery query = EditQueryUtil.getEditQuery(node);
        if (query == null) {
            return true;
        }
        if (DesignTimeTagUtil.isBodyContentEmpty(node)) {
            return false;
        }
        Node child = node.getFirstChild();
        while (child != null) {
            if (child.getNodeType() != 3 || !query.isEmptyText((Text)child)) {
                return false;
            }
            child = child.getNextSibling();
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean canInsertNode(Node elm, Node target, int offset) {
        EditModelQuery query;
        if (target == null) {
            return false;
        }
        if (elm == null) {
            return false;
        }
        Document doc = null;
        if (target.getNodeType() == 9) {
            doc = (Document)target;
            query = EditQueryUtil.getEditQuery(doc);
            if (query == null) {
                return false;
            }
            if (!query.isFragment(doc) || "editingContextBody".equals(query.getFragmentContext(doc))) {
                NodeList bodies;
                NodeList nodeList = bodies = !query.isFragment(doc) ? query.collectRenderRoots(doc) : null;
                if (bodies != null && bodies.getLength() != 0) return false;
                target = doc.createElement(query.getBodyElementName(doc));
            } else {
                NodeList heads = doc.getElementsByTagName(query.getHeadElementName(doc));
                if (heads != null && heads.getLength() != 0) return false;
                target = doc.createElement(query.getHeadElementName(doc));
            }
        } else {
            doc = CommandTreeManipulator.getSafeDocument(target);
        }
        if (doc == null) {
            return false;
        }
        query = EditQueryUtil.getEditQuery(doc);
        if (query == null) {
            return false;
        }
        Node check = target;
        while (check != null) {
            Node parent = check.getParentNode();
            if (query.canContain(check, elm)) {
                return true;
            }
            if (query.isExcluded(check, elm)) {
                return false;
            }
            if (!(query.isSolidElement(check) || query.isEmptyNode(check) || query.isSplitableNode(check))) {
                boolean canAdapt = this.canAdapt(elm, check);
                return canAdapt;
            }
            check = parent;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private final boolean canAdapt(Node child, Node parent) {
        block12: {
            if (child == null || parent == null || parent.getNodeType() != 1) {
                return false;
            }
            doc = CommandTreeManipulator.getSafeDocument(child);
            if (doc == null) {
                return false;
            }
            query = EditQueryUtil.getEditQuery(doc);
            if (query == null) {
                return false;
            }
            strParent = ((Element)parent).getTagName();
            logicalParent = parent;
            while (logicalParent != null) {
                if (!query.isLogicalElement(logicalParent) || (logicalParent = logicalParent.getParentNode()) == null || logicalParent.getNodeType() != 1) break;
                strParent = ((Element)logicalParent).getTagName();
            }
            strAdaptor = query.getAdaptChild(strParent);
            parentAdaptor = null;
            while (strAdaptor != null) {
                adaptor = doc.createElement(strAdaptor);
                if (query.canContain(adaptor, child)) {
                    return true;
                }
                parentAdaptor = adaptor;
                strAdaptor = query.getAdaptChild(strAdaptor);
            }
            strAdaptor = null;
            if (child.getNodeType() == 1) {
                strAdaptor = query.getAdaptParent(((Element)child).getTagName());
            }
            if (strAdaptor == null && query.isRenderRoot(logicalParent) && !query.loveBody(child)) {
                p_element = doc.createElement("P");
                if (!query.canContain(parent, child) && query.canContain(parent, p_element) && query.canContain(p_element, child)) {
                    strAdaptor = "P";
                }
            }
            if (strAdaptor == null) break block12;
            if (strAdaptor != query.getAdaptParent(strParent)) ** GOTO lbl40
            return false;
lbl-1000:
            // 1 sources

            {
                adaptor = doc.createElement(strAdaptor);
                if (parentAdaptor != null && query.canContain(parentAdaptor, adaptor)) {
                    return true;
                }
                if ((parentAdaptor == null || strParent.equalsIgnoreCase("HTML")) && query.canContain(parent, adaptor)) {
                    return true;
                }
                strAdaptor = query.getAdaptParent(strAdaptor);
lbl40:
                // 2 sources

                ** while (strAdaptor != null)
            }
        }
        return false;
    }

    private final Node adapt(Node child, Range range, boolean doPrevAdapter) {
        Node body;
        String strAdaptor;
        if (child == null) {
            return null;
        }
        Node parent = child.getParentNode();
        if (parent == null || parent.getNodeType() != 1) {
            return null;
        }
        Document doc = CommandTreeManipulator.getSafeDocument(child);
        if (doc == null) {
            return null;
        }
        EditModelQuery query = EditQueryUtil.getEditQuery(doc);
        if (query == null) {
            return null;
        }
        Node lastAdapter = null;
        if (doPrevAdapter) {
            Node prevAdapter = child.getPreviousSibling();
            while (prevAdapter != null) {
                switch (prevAdapter.getNodeType()) {
                    case 3: {
                        if (query.isEmptyText((Text)prevAdapter)) {
                            prevAdapter = prevAdapter.getPreviousSibling();
                            break;
                        }
                        prevAdapter = null;
                        break;
                    }
                    case 8: {
                        prevAdapter = prevAdapter.getPreviousSibling();
                        break;
                    }
                    case 1: {
                        if ((child.getNodeType() != 3 || !query.isEmptyText((Text)child)) && query.canContain(child.getParentNode(), child)) {
                            prevAdapter = null;
                            break;
                        }
                    }
                    default: {
                        if (query.canContain(prevAdapter, child)) {
                            RemoveTag rtag = new RemoveTag(range, true);
                            rtag.removeNode(child);
                            prevAdapter.appendChild(child);
                            return prevAdapter;
                        }
                        lastAdapter = prevAdapter;
                        prevAdapter = prevAdapter.getLastChild();
                    }
                }
            }
        }
        String strParent = ((Element)parent).getTagName();
        Node logicalParent = parent;
        while (logicalParent != null) {
            if (!query.isLogicalElement(logicalParent) || (logicalParent = logicalParent.getParentNode()) == null || logicalParent.getNodeType() != 1) break;
            strParent = ((Element)logicalParent).getTagName();
        }
        if ((strAdaptor = query.getAdaptChild(strParent)) != null && strAdaptor.equalsIgnoreCase("BODY") && (body = query.getRenderRootNode(doc, !query.isFragment(doc) && !query.loveBody(child))) != null && !query.loveBody(child)) {
            Element p_element = doc.createElement("P");
            if (query.canContain(body, p_element) && query.canContain(p_element, child)) {
                body.insertBefore(p_element, body.getFirstChild());
                p_element.appendChild(child);
                return p_element;
            }
            if (!parent.equals(child.getParentNode())) {
                this.promote(child, child, null, true);
                return child.getParentNode();
            }
            parent.removeChild(child);
        }
        Node parentAdaptor = null;
        Element toadapter = null;
        while (strAdaptor != null) {
            Element adaptor = doc.createElement(strAdaptor);
            if (parentAdaptor != null) {
                parentAdaptor.insertBefore(adaptor, parentAdaptor.getFirstChild());
            } else {
                toadapter = adaptor;
            }
            if (query.canContain(adaptor, child)) {
                parent.insertBefore(toadapter, child);
                parent.removeChild(child);
                adaptor.insertBefore(child, adaptor.getFirstChild());
                return adaptor;
            }
            parentAdaptor = adaptor;
            strAdaptor = query.getAdaptChild(strAdaptor);
        }
        strAdaptor = null;
        if (child.getNodeType() == 1) {
            strAdaptor = query.getAdaptParent(((Element)child).getTagName());
        }
        if (strAdaptor == null && strParent.equalsIgnoreCase("BODY") && !query.loveBody(child)) {
            Element p_element = doc.createElement("P");
            if (!query.canContain(parent, child) && query.canContain(parent, p_element) && query.canContain(p_element, child)) {
                strAdaptor = "P";
            }
        }
        if (strAdaptor != null) {
            if (strAdaptor == query.getAdaptParent(strParent)) {
                if (toadapter != null) {
                    toadapter.getParentNode().removeChild(toadapter);
                }
                return null;
            }
            Node childAdaptor = null;
            Element bottomAdaptor = null;
            while (strAdaptor != null) {
                Element adaptor = doc.createElement(strAdaptor);
                if (childAdaptor != null) {
                    adaptor.insertBefore(childAdaptor, adaptor.getFirstChild());
                } else {
                    bottomAdaptor = adaptor;
                }
                if (lastAdapter != null && query.canContain(lastAdapter, adaptor)) {
                    lastAdapter.appendChild(adaptor);
                    parent.removeChild(child);
                    bottomAdaptor.insertBefore(child, bottomAdaptor.getFirstChild());
                    if (toadapter != null) {
                        toadapter.getParentNode().removeChild(toadapter);
                    }
                    return bottomAdaptor;
                }
                if (parentAdaptor != null && query.canContain(parentAdaptor, adaptor)) {
                    parentAdaptor.insertBefore(adaptor, parentAdaptor.getFirstChild());
                    parent.insertBefore(toadapter, child);
                    parent.removeChild(child);
                    bottomAdaptor.insertBefore(child, bottomAdaptor.getFirstChild());
                    return bottomAdaptor;
                }
                if ((parentAdaptor == null || strParent.equalsIgnoreCase("HTML")) && query.canContain(parent, adaptor)) {
                    if (toadapter != null) {
                        toadapter.getParentNode().removeChild(toadapter);
                    }
                    parent.insertBefore(adaptor, child);
                    parent.removeChild(child);
                    bottomAdaptor.insertBefore(child, bottomAdaptor.getFirstChild());
                    return bottomAdaptor;
                }
                childAdaptor = adaptor;
                strAdaptor = query.getAdaptParent(strAdaptor);
            }
            if (childAdaptor != null) {
                childAdaptor.getParentNode().removeChild(childAdaptor);
            }
        }
        if (toadapter != null) {
            toadapter.getParentNode().removeChild(toadapter);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public final boolean moveToHead(Node head, Node first, Node last, boolean force) {
        if (head == null) {
            return false;
        }
        child = first;
        rc = false;
        query = EditQueryUtil.getEditQuery(child);
        if (query != null) ** GOTO lbl13
        return false;
lbl-1000:
        // 1 sources

        {
            childNext = child.getNextSibling();
            if ((child.getNodeType() != 3 || !query.isEmptyText((Text)child)) && (success_moving = this.moveToHead(head, child, force))) {
                rc = true;
            }
            if (child == last) break;
            child = childNext;
lbl13:
            // 2 sources

            ** while (child != null)
        }
lbl14:
        // 2 sources

        return rc;
    }

    /*
     * Unable to fully structure code
     */
    public final boolean moveToBeforeHtml(Node html, Node first, Node last, boolean force) {
        if (html == null) {
            return false;
        }
        child = first;
        rc = false;
        query = EditQueryUtil.getEditQuery(child);
        if (query != null) ** GOTO lbl13
        return false;
lbl-1000:
        // 1 sources

        {
            childNext = child.getNextSibling();
            if ((child.getNodeType() != 3 || !query.isEmptyText((Text)child)) && (success_moving = this.moveToBeforeHtml(html, child, force))) {
                rc = true;
            }
            if (child == last) break;
            child = childNext;
lbl13:
            // 2 sources

            ** while (child != null)
        }
lbl14:
        // 2 sources

        return rc;
    }

    private final boolean moveToHead(Node head, Node node, boolean force) {
        boolean canInsertInHead;
        if (head == null || node == null) {
            return false;
        }
        if (!force) {
            EditModelQuery query = EditQueryUtil.getEditQuery(node);
            if (query == null) {
                return false;
            }
            if (!query.canContain(head, node)) {
                return false;
            }
        }
        if (!(canInsertInHead = this.canInsertInHead(node, head))) {
            return false;
        }
        Node parent = node.getParentNode();
        boolean inserted = false;
        Node ins = this.getHeadItemAfter(node, head);
        if (ins != null) {
            if (parent != null) {
                node = parent.removeChild(node);
            }
            ins.getParentNode().insertBefore(node, ins.getNextSibling());
            inserted = true;
        } else {
            ins = this.getHeadItemBefore(node, head);
            if (ins != null) {
                if (parent != null) {
                    node = parent.removeChild(node);
                }
                ins.getParentNode().insertBefore(node, ins);
                inserted = true;
            } else {
                Element comment;
                if (parent != null) {
                    node = parent.removeChild(node);
                }
                if (!ReadOnlySupport.isChildEditable(head) && (comment = ReadOnlySupport.getChildEditableCommentElement(head, true)) != null) {
                    comment.appendChild(node);
                    inserted = true;
                }
                if (!inserted) {
                    head.appendChild(node);
                }
            }
        }
        if (inserted && node.getNodeType() == 1) {
            this.normalizeHeadItem((Element)node, head);
        }
        return inserted;
    }

    private final boolean moveToBeforeHtml(Node html, Node node, boolean force) {
        boolean canInsertInDocument;
        if (html == null || node == null) {
            return false;
        }
        if (!force) {
            EditModelQuery query = EditQueryUtil.getEditQuery(node);
            if (query == null) {
                return false;
            }
            if (!query.canContain(html, node)) {
                return false;
            }
        }
        if (!(canInsertInDocument = this.canInsertInDocument(node, CommandTreeManipulator.getSafeDocument(html)))) {
            return false;
        }
        Node parent = node.getParentNode();
        if (parent != null) {
            node = parent.removeChild(node);
        }
        if (html.getParentNode() != null) {
            html.getParentNode().insertBefore(node, html);
        } else {
            html.insertBefore(node, html.getFirstChild());
        }
        return true;
    }

    private final boolean canInsertInHead(Node node, Node headNode) {
        if (node == null || headNode == null) {
            return false;
        }
        if (node.getNodeType() != 1) {
            return true;
        }
        if (headNode.getNodeType() == 9) {
            return true;
        }
        if (headNode.getNodeType() != 1) {
            return false;
        }
        Element head = (Element)headNode;
        Element element = (Element)node;
        String nodename = element.getNodeName();
        int len = sequence != null ? sequence.length : 0;
        int i = 0;
        while (i < len) {
            if (sequence[i].equalsIgnoreCase(nodename)) {
                NodeList c = head.getElementsByTagName(nodename);
                if (c == null || c.getLength() <= 0) break;
                return false;
            }
            ++i;
        }
        return !(nodename.equalsIgnoreCase("SCRIPT") ? !this.canInsertScriptInHead(element, head) : (nodename.equalsIgnoreCase("META") ? !this.canInsertMetaInHead(element, head) : (nodename.equalsIgnoreCase("LINK") ? !this.canInsertLinkInHead(element, head) : (nodename.equalsIgnoreCase("STYLE") ? !this.canInsertStyleInHead(element, head) : (nodename.equalsIgnoreCase("TITLE") ? !this.canInsertTitleInHead(element, head) : (nodename.equalsIgnoreCase("BASE") ? !this.canInsertBaseInHead(element, head) : (nodename.equalsIgnoreCase("jsp:directive.taglib") ? !this.canInsertDirectiveTaglibInDocument(element, CommandTreeManipulator.getSafeDocument(head)) : nodename.equalsIgnoreCase("jsp:directive.page") && !this.canInsertDirectiveTaglibInDocument(element, CommandTreeManipulator.getSafeDocument(head)))))))));
    }

    private final boolean canInsertInDocument(Node node, Document doc) {
        if (node == null || doc == null) {
            return false;
        }
        switch (node.getNodeType()) {
            case 1: {
                break;
            }
            case 3: 
            case 8: {
                return true;
            }
            default: {
                return false;
            }
        }
        Element element = (Element)node;
        String nodename = element.getNodeName();
        return !(nodename.equalsIgnoreCase("jsp:directive.taglib") ? !this.canInsertDirectiveTaglibInDocument(element, doc) : nodename.equalsIgnoreCase("jsp:directive.page") && !this.canInsertDirectiveTaglibInDocument(element, doc));
    }

    private final NodeList getElementsByTagName(Node node, String elementName) {
        if (node == null) {
            return null;
        }
        if (node.getNodeType() == 1) {
            return ((Element)node).getElementsByTagName(elementName);
        }
        if (node.getNodeType() == 9) {
            return ((Document)node).getElementsByTagName(elementName);
        }
        return null;
    }

    private final Node getHeadItemAfter(Node element, Node head) {
        if (element == null || head == null) {
            return null;
        }
        if (element.getNodeType() != 1) {
            return null;
        }
        String nodename = element.getNodeName();
        NodeList c = this.getElementsByTagName(head, nodename);
        if (c != null && c.getLength() > 0) {
            return c.item(c.getLength() - 1);
        }
        int len = style_sequence != null ? style_sequence.length : 0;
        int i = len - 1;
        while (i >= 0) {
            if (style_sequence[i].equalsIgnoreCase(nodename)) break;
            --i;
        }
        while (i >= 0) {
            c = this.getElementsByTagName(head, style_sequence[i]);
            if (c != null && c.getLength() > 0) {
                return c.item(c.getLength() - 1);
            }
            --i;
        }
        len = sequence != null ? sequence.length : 0;
        i = len - 1;
        while (i >= 0) {
            if (sequence[i].equalsIgnoreCase(nodename)) break;
            --i;
        }
        while (i >= 0) {
            c = this.getElementsByTagName(head, sequence[i]);
            if (c != null && c.getLength() > 0) {
                return c.item(c.getLength() - 1);
            }
            --i;
        }
        return null;
    }

    private final Node getHeadItemBefore(Node element, Node head) {
        NodeList c;
        int i;
        if (element == null || head == null) {
            return null;
        }
        if (element.getNodeType() != 1) {
            return null;
        }
        String nodename = element.getNodeName();
        int len = style_sequence != null ? style_sequence.length : 0;
        int index = len - 1;
        if (len > 0) {
            i = len - 1;
            while (i >= 0) {
                if (style_sequence[i].equalsIgnoreCase(nodename)) {
                    index = i;
                    break;
                }
                --i;
            }
            i = len - 1;
            while (i > index) {
                c = this.getElementsByTagName(head, style_sequence[i]);
                if (c != null && c.getLength() > 0) {
                    return c.item(c.getLength() - 1);
                }
                --i;
            }
        }
        int n = len = sequence != null ? sequence.length : 0;
        if (len > 0) {
            index = len - 1;
            i = len - 1;
            while (i >= 0) {
                if (sequence[i].equalsIgnoreCase(nodename)) {
                    index = i;
                    break;
                }
                --i;
            }
            i = len - 1;
            while (i > index) {
                c = this.getElementsByTagName(head, sequence[i]);
                if (c != null && c.getLength() > 0) {
                    return c.item(c.getLength() - 1);
                }
                --i;
            }
        }
        return null;
    }

    private final boolean canInsertMetaInHead(Element meta, Element head) {
        String name = meta.getAttribute("name");
        if (name != null && name.equalsIgnoreCase(GENERATOR)) {
            return false;
        }
        String httpequiv = meta.getAttribute("http-equiv");
        if (httpequiv != null && httpequiv.equalsIgnoreCase(CONTENT_TYPE)) {
            return false;
        }
        Element found = this.getElementWithEqualSource(meta, head);
        return found == null;
    }

    private final boolean canInsertLinkInHead(Element link, Element head) {
        Element found = this.getElementWithEqualSource(link, head);
        return found == null;
    }

    private final boolean canInsertScriptInHead(Element script, Element head) {
        Element found = this.getElementWithEqualContents(script, head);
        return found == null;
    }

    private final boolean canInsertStyleInHead(Element style, Element head) {
        Element found = this.getElementWithEqualContents(style, head);
        return found == null;
    }

    private final boolean canInsertDirectiveTaglibInDocument(Element taglib, Document doc) {
        Element found = this.getElementWithEqualSource(taglib, doc);
        return found == null;
    }

    private final boolean canInsertTitleInHead(Element link, Element head) {
        return false;
    }

    private final boolean canInsertBaseInHead(Element link, Element head) {
        return false;
    }

    private final Element getElementWithEqualSource(Element meta, Node head) {
        if (head == null || meta == null) {
            return null;
        }
        NodeList c = null;
        if (head.getNodeType() == 1) {
            c = ((Element)head).getElementsByTagName(meta.getNodeName());
        } else if (head.getNodeType() == 9) {
            c = ((Document)head).getElementsByTagName(meta.getNodeName());
        }
        if (c == null || c.getLength() == 0) {
            return null;
        }
        EditModelQuery query = EditQueryUtil.getEditQuery(head);
        if (query == null) {
            return null;
        }
        int i = 0;
        while (i < c.getLength()) {
            Element node = (Element)c.item(i);
            if (node != meta && query.isEqual(meta, node)) {
                return node;
            }
            ++i;
        }
        return null;
    }

    private final Element getElementWithEqualContents(Element script, Element head) {
        if (head == null || script == null) {
            return null;
        }
        NodeList c = head.getElementsByTagName(script.getNodeName());
        if (c == null || c.getLength() == 0) {
            return null;
        }
        EditModelQuery query = EditQueryUtil.getEditQuery(head);
        if (query == null) {
            return null;
        }
        String orgText = null;
        int i = 0;
        while (i < c.getLength()) {
            Element node = (Element)c.item(i);
            if (node != script && query.isEqual(script, node)) {
                if (orgText == null) {
                    orgText = query.getTextSource(script, false);
                }
                String text = query.getTextSource(node, false);
                if (orgText == null && text == null) {
                    return node;
                }
                if (orgText != null && text != null && text.equalsIgnoreCase(orgText)) {
                    return node;
                }
            }
            ++i;
        }
        return null;
    }

    private final Element normalizeHeadItem(Element item, Node head) {
        if (item == null || head == null) {
            return null;
        }
        String nodename = item.getNodeName();
        NodeList c = this.getElementsByTagName(head, nodename);
        EditModelQuery query = EditQueryUtil.getEditQuery(head);
        if (query == null) {
            return null;
        }
        if (c != null && c.getLength() > 0) {
            boolean remove_please = true;
            int i = 0;
            while (i < c.getLength()) {
                Node check = c.item(i);
                if (check == item) {
                    remove_please = false;
                    break;
                }
                if (remove_please && query.isEqual(item, (Element)check)) {
                    check.getParentNode().removeChild(check);
                }
                ++i;
            }
        }
        return item;
    }

    public final boolean normalizeTable(Element table) {
        if (table == null) {
            return false;
        }
        boolean rc = false;
        String[] once = new String[]{"TBODY", "THEAD", "TFOOT"};
        Node child = table.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 1) {
                int i = 0;
                while (i < once.length) {
                    if (child.getNodeName().equalsIgnoreCase(once[i])) {
                        Node merge = child.getNextSibling();
                        while (merge != null) {
                            Node next = merge.getNextSibling();
                            if (merge.getNodeType() == 1 && merge.getNodeName().equalsIgnoreCase(once[i])) {
                                Node mergeChild = merge.getFirstChild();
                                while (mergeChild != null) {
                                    Node mergeNext = mergeChild.getNextSibling();
                                    mergeChild = merge.removeChild(mergeChild);
                                    child.appendChild(mergeChild);
                                    mergeChild = mergeNext;
                                }
                                merge.getParentNode().removeChild(merge);
                                rc = true;
                            }
                            merge = next;
                        }
                        break;
                    }
                    ++i;
                }
            }
            child = child.getNextSibling();
        }
        return rc;
    }

    public final boolean normalizeList(Element list) {
        if (list == null) {
            return false;
        }
        boolean rc = false;
        Node child = list.getFirstChild();
        while (child != null) {
            Node next = child.getNextSibling();
            if (child.getNodeType() == 1) {
                Element newList;
                if (child.getNodeName().equalsIgnoreCase("DD") || child.getNodeName().equalsIgnoreCase("DT")) {
                    newList = this.normalizeDLItem((Element)child);
                    if (newList != null) {
                        next = newList;
                        rc = true;
                    }
                } else if (child.getNodeName().equalsIgnoreCase("LI") && (newList = this.normalizeListItem((Element)child)) != null) {
                    next = newList;
                    rc = true;
                }
            }
            child = next;
        }
        return rc;
    }

    /*
     * Unable to fully structure code
     */
    private final Element normalizeDLItem(Element listItem) {
        if (listItem == null) {
            return null;
        }
        list = listItem.getParentNode();
        if (list == null) {
            return null;
        }
        doc = CommandTreeManipulator.getSafeDocument(list);
        if (doc == null) {
            return null;
        }
        clone = null;
        if (listItem.getNodeName().equalsIgnoreCase("DT")) {
            clone = doc.createElement("DD");
        } else if (listItem.getNodeName().equalsIgnoreCase("DD")) {
            clone = doc.createElement("DT");
        }
        if (clone == null) {
            return null;
        }
        move = null;
        query = EditQueryUtil.getEditQuery(doc);
        if (query == null) {
            return null;
        }
        br = listItem.getFirstChild();
        while (br != null) {
            if (!query.canContain(listItem, br) && query.canContain(clone, br)) {
                move = br;
                br = null;
                break;
            }
            if (br.getNodeType() == 1 && br.getNodeName().equalsIgnoreCase("BR")) {
                move = br.getNextSibling();
                break;
            }
            br = br.getNextSibling();
        }
        if (move != null) ** GOTO lbl39
        return null;
lbl-1000:
        // 1 sources

        {
            next = move.getNextSibling();
            move = listItem.removeChild(move);
            clone.appendChild(move);
            move = next;
lbl39:
            // 2 sources

            ** while (move != null)
        }
lbl40:
        // 1 sources

        list.insertBefore(clone, listItem.getNextSibling());
        if (br != null) {
            listItem.removeChild(br);
        }
        return clone;
    }

    private final Element normalizeListItem(Element listItem) {
        if (listItem == null) {
            return null;
        }
        Node list = listItem.getParentNode();
        if (list == null) {
            return null;
        }
        Document doc = CommandTreeManipulator.getSafeDocument(list);
        if (doc == null) {
            return null;
        }
        Node br = listItem.getFirstChild();
        while (br != null) {
            if (br.getNodeType() == 1 && br.getNodeName().equalsIgnoreCase("BR")) break;
            br = br.getNextSibling();
        }
        if (br == null) {
            return null;
        }
        Element clone = null;
        clone = (Element)listItem.cloneNode(false);
        if (clone == null) {
            return null;
        }
        Node move = br.getNextSibling();
        while (move != null) {
            Node moveNext = move.getNextSibling();
            move = listItem.removeChild(move);
            clone.appendChild(move);
            move = moveNext;
        }
        list.insertBefore(clone, br.getNextSibling());
        listItem.removeChild(br);
        return clone;
    }

    /*
     * Unable to fully structure code
     */
    public boolean normalizeChildren(Element element, Node first, Node last) {
        if (element == null) {
            return false;
        }
        doc = CommandTreeManipulator.getSafeDocument(element);
        if (doc == null) {
            return false;
        }
        query = EditQueryUtil.getEditQuery(doc);
        if (query == null) {
            return false;
        }
        plain = query.isPlainElement(element);
        if (!query.isBlockElement(element) && !plain) {
            return false;
        }
        if (first == null) {
            first = element.getFirstChild();
            if (first == null) {
                return true;
            }
        } else if (!query.isAncestor(element, first)) {
            return false;
        }
        end = null;
        if (last != null) {
            if (!query.isAncestor(element, last)) {
                return false;
            }
            end = last.getNextSibling();
        }
        child = first;
        while (child != null && child != end && query.isAncestor(element, child)) {
            next = query.getNextNode(child, false);
            switch (child.getNodeType()) {
                case 3: {
                    crlflen = "\r\n".length();
                    text = (Text)child;
                    sData = text.getData();
                    if (sData.length() < crlflen) break;
                    offset = sData.indexOf("\r\n");
                    if (!plain) {
                        if (offset < 0 || (parent = text.getParentNode()) == null || (later = text.splitText(offset)) == null) break;
                        br = doc.createElement("BR");
                        parent.insertBefore(br, later);
                        later.deleteData(0, crlflen);
                        next = later;
                        break;
                    }
                    if (offset < 0) break;
                    space = true;
                    if (offset != 0) ** GOTO lbl55
                    for (p = text.getPreviousSibling(); p != null; p = p.getPreviousSibling()) {
                        if (p.getNodeType() != 3) ** GOTO lbl64
                        d = ((Text)p).getData();
                        if (d.length() == 0) {
                            continue;
                        }
                        if (d.length() >= " ".length() && d.lastIndexOf(" ") == d.length() - " ".length() || d.length() >= crlflen && d.lastIndexOf("\r\n") == d.length() - crlflen) {
                            space = false;
                        }
                        ** GOTO lbl64
                    }
                    ** GOTO lbl64
lbl55:
                    // 1 sources

                    if (offset != sData.length() - crlflen) ** GOTO lbl64
                    for (n = next; n != null; n = n.getNextSibling()) {
                        if (n.getNodeType() != 3) break;
                        d = ((Text)n).getData();
                        if (d.length() == 0) {
                            continue;
                        }
                        if (d.length() >= " ".length() && d.indexOf(" ") == 0 || d.length() >= crlflen && d.indexOf("\r\n") == 0) {
                            space = false;
                        }
                        break;
                    }
lbl64:
                    // 7 sources

                    if ((parent = text.getParentNode()) == null || (later = text.splitText(offset)) == null) break;
                    if (space) {
                        t = doc.createTextNode(" ");
                        parent.insertBefore(t, later);
                    }
                    later.deleteData(0, crlflen);
                    next = later;
                    break;
                }
                case 1: {
                    if (!plain || !query.isBr(child)) break;
                    parent = child.getParentNode();
                    text = doc.createTextNode("\r\n");
                    parent.insertBefore(text, child);
                    parent.removeChild(child);
                    break;
                }
            }
            child = next;
        }
        if (plain && (vec = query.getExcludedTagNames(element)) != null) {
            k = 0;
            while (k < vec.size()) {
                c = element.getElementsByTagName((String)vec.get(k));
                if (c != null) {
                    j = 0;
                    while (j < c.getLength()) {
                        del = (Element)c.item(j);
                        withChild = query.isEmptyNode(del) != false || query.isSolidElement(del) != false;
                        rtag = new RemoveTag(this.range, withChild);
                        rtag.remove(del);
                        ++j;
                    }
                }
                ++k;
            }
        }
        return true;
    }

    public void moveChildren(Node prevNode, Node newNode, boolean bBefore) {
        if (prevNode == null || newNode == null) {
            return;
        }
        int preOffset = -1;
        int postOffset = -1;
        if (this.range != null) {
            NodeList c;
            Node pre = this.range.getStartContainer();
            Node post = this.range.getEndContainer();
            if (pre == prevNode) {
                preOffset = this.range.getStartOffset();
                if (!bBefore && (c = newNode.getChildNodes()) != null) {
                    preOffset += c.getLength();
                }
            }
            if (post == prevNode) {
                postOffset = this.range.getEndOffset();
                if (!bBefore && (c = newNode.getChildNodes()) != null) {
                    preOffset += c.getLength();
                }
            }
        }
        Node child = bBefore ? prevNode.getLastChild() : prevNode.getFirstChild();
        while (child != null) {
            Node next = bBefore ? child.getPreviousSibling() : child.getNextSibling();
            child = prevNode.removeChild(child);
            if (bBefore) {
                newNode.insertBefore(child, newNode.getFirstChild());
            } else {
                newNode.appendChild(child);
            }
            child = next;
        }
        if (preOffset >= 0) {
            this.range.setStart(newNode, preOffset);
        }
        if (postOffset >= 0) {
            this.range.setEnd(newNode, postOffset);
        }
    }

    private boolean needToCreateBody(EditModelQuery query, Document doc) {
        if (query.isFragment(doc)) {
            return false;
        }
        if (query.getBodyElement(doc, false) != null) {
            return false;
        }
        Node head = query.getHeadCorrespondentNode(doc, false);
        if (head != null && head.getNodeType() == 1 && query.isHeadCorrespondent(head, true)) {
            return true;
        }
        Node html = query.getHtmlCorrespondentNode(doc, false);
        return html != null && html.getNodeType() == 1;
    }

    public final void insertNode(Node elm, Text text, Node target, int offset, boolean forward) {
        EditModelQuery query = EditQueryUtil.getEditQuery(elm != null ? elm : (target != null ? target : text));
        if (query == null) {
            return;
        }
        Document doc = CommandTreeManipulator.getSafeDocument(target);
        if (target != null && (target.getNodeType() == 9 || query.getHtmlCorrespondentNode(doc, false) == target) && this.needToCreateBody(query, doc)) {
            target = EditQueryUtil.getEditQuery(doc).getBodyElement(doc, true);
        }
        if (doc == null) {
            return;
        }
        Node parent = target.getParentNode();
        if (parent == null && target.getNodeType() != 9) {
            return;
        }
        if (target.getNodeType() == 3) {
            Text textTarget = (Text)target;
            if (offset == 0) {
                parent.insertBefore(elm, textTarget);
            } else if (offset == ((Text)target).getLength()) {
                parent.insertBefore(elm, textTarget.getNextSibling());
            } else {
                Text lastText = textTarget.splitText(offset);
                parent.insertBefore(elm, lastText);
            }
        } else if (query.isEmptyNode(target) || query.isSolidElement(target)) {
            parent.insertBefore(elm, target.getNextSibling());
        } else {
            Node before = null;
            if (target.hasChildNodes()) {
                before = target.getChildNodes().item(offset);
            }
            target.insertBefore(elm, before);
        }
        this.promote(elm, elm, null, true);
        if (this.range != null) {
            if (text != null) {
                this.range.setStart(text, forward ? text.getLength() : 0);
                this.range.collapse(true);
            } else {
                if (query.isBr(elm)) {
                    parent = elm.getParentNode();
                    int index = query.getChildIndex(elm);
                    this.range.setStart(parent, index + 1);
                    this.range.collapse(true);
                    return;
                }
                if (elm.getNodeType() == 3) {
                    this.range.setStart(text, 0);
                    this.range.collapse(true);
                } else if (elm.getNodeType() == 1) {
                    int childLen;
                    NodeList c = elm.getChildNodes();
                    int n = childLen = c != null ? c.getLength() : 0;
                    if (childLen == 0 || query.isEmptyNode(elm) || query.isSolidElement(elm)) {
                        this.range.setStart(elm, 0);
                        this.range.collapse(true);
                    } else {
                        this.range.setStart(elm, forward ? childLen : 0);
                        this.range.collapse(true);
                    }
                } else {
                    this.range.setStart(elm, 0);
                    this.range.collapse(true);
                }
            }
        }
    }

    public final void insertNodes(Node start, Node end, Node target, int offset) {
        Node parent;
        Node nextNode;
        Document doc = CommandTreeManipulator.getSafeDocument(target);
        if (doc == null) {
            return;
        }
        EditModelQuery query = EditQueryUtil.getEditQuery(doc);
        if (query == null) {
            return;
        }
        Node cursor = null;
        int cursor_offset = 0;
        boolean promote = true;
        Node parentNode = target.getParentNode();
        if (target.getNodeType() == 3) {
            Text textTarget = (Text)target;
            nextNode = offset == 0 ? textTarget : (offset == textTarget.getLength() ? textTarget.getNextSibling() : textTarget.splitText(offset));
        } else if (query.isEmptyNode(target) || query.isSolidElement(target)) {
            nextNode = target.getNextSibling();
        } else {
            parentNode = target;
            nextNode = target.getChildNodes().item(offset);
        }
        Node elm = start;
        while (elm != null) {
            Node new_cursor = null;
            Node nextElm = elm.getNextSibling();
            if (nextNode == null) {
                parentNode.appendChild(elm);
            } else {
                NodeList insertList = this.getInsertList(elm, nextNode != null ? nextNode : parentNode);
                if (insertList.getLength() > 0) {
                    Node last = null;
                    int i = 0;
                    while (i < insertList.getLength()) {
                        last = insertList.item(i);
                        parentNode.insertBefore(last, nextNode);
                        ++i;
                    }
                    new_cursor = last;
                } else {
                    parentNode.insertBefore(elm, nextNode);
                }
            }
            if (elm == end) {
                if (elm.getNodeType() == 3) {
                    cursor = elm;
                    cursor_offset = ((Text)elm).getData().length();
                    break;
                }
                if (start == end && (query.isSolidElement(end) || query.isEmptyNode(end))) {
                    cursor = end;
                    cursor_offset = 0;
                    break;
                }
                cursor = parentNode;
                Node n = new_cursor != null ? new_cursor : elm;
                do {
                    ++cursor_offset;
                } while ((n = n.getPreviousSibling()) != null);
                break;
            }
            elm = nextElm;
        }
        if (cursor != null) {
            this.range.setStart(cursor, cursor_offset);
            this.range.collapse(true);
            return;
        }
        if (end.getNodeType() == 3) {
            this.range.setStart(end, ((Text)end).getData().length());
            this.range.collapse(true);
        }
        if ((query.isEmptyNode(end) || !query.canContainText(end)) && (parent = end.getParentNode()) != null) {
            NodeList c = parent.getChildNodes();
            int i = 0;
            while (i < c.getLength()) {
                if (c.item(i).equals(end)) {
                    this.range.setStart(parent, i + 1);
                    this.range.setEnd(parent, i + 1);
                    return;
                }
                ++i;
            }
        }
        this.range.setStart(end, 0);
        this.range.setEnd(end, 0);
        if (promote) {
            this.promote(start, end, null, true);
        }
    }

    private NodeList getInsertList(Node insert, Node target) {
        MyNodeList insertList = new MyNodeList();
        MyNodeList attrList = new MyNodeList();
        EditModelQuery query = EditQueryUtil.getEditQuery(insert);
        Node parent = target.getParentNode();
        while (parent != null && parent.getNodeType() == 1 && (parent.getNodeName().equalsIgnoreCase("A") || query.isTextAttribute((Element)parent))) {
            attrList.appendNode(parent);
            parent = parent.getParentNode();
        }
        if (attrList.getLength() == 0) {
            insertList.appendNode(insert);
        } else {
            this.addToInsertList(insert, null, insertList, (NodeList)((Object)attrList));
        }
        return insertList;
    }

    private void addToInsertList(Node insert, Node parent, MyNodeList nodeList, NodeList attrList) {
        boolean addChildren = false;
        Node nextParent = insert;
        EditModelQuery query = EditQueryUtil.getEditQuery(insert);
        if (insert.getNodeType() == 1 && (insert.getNodeName().equalsIgnoreCase("A") || query.isTextAttribute((Element)insert))) {
            boolean match = false;
            int i = 0;
            while (i < attrList.getLength()) {
                Node attr = attrList.item(i);
                if (this.matchTextAttribute(insert, attr)) {
                    nextParent = parent;
                    match = true;
                    break;
                }
                ++i;
            }
            addChildren = true;
            if (!match) {
                Node newNode = insert.cloneNode(false);
                if (parent != null) {
                    parent.appendChild(newNode);
                } else {
                    nodeList.appendNode(newNode);
                }
                nextParent = newNode;
            }
        } else if (parent != null) {
            parent.appendChild(insert);
        } else {
            nodeList.appendNode(insert);
        }
        if (addChildren) {
            MyNodeList insertList = new MyNodeList();
            NodeList childNodes = insert.getChildNodes();
            int i = 0;
            while (i < childNodes.getLength()) {
                insertList.appendNode(childNodes.item(i));
                ++i;
            }
            i = 0;
            while (i < insertList.getLength()) {
                this.addToInsertList(insertList.item(i), nextParent, nodeList, attrList);
                ++i;
            }
        }
    }

    private boolean matchTextAttribute(Node node1, Node node2) {
        if (node1.getNodeName().equalsIgnoreCase(node1.getNodeName())) {
            NamedNodeMap map1 = node1.getAttributes();
            NamedNodeMap map2 = node2.getAttributes();
            if (map1.getLength() == map2.getLength()) {
                int i = 0;
                while (i < map1.getLength()) {
                    Node attr1 = map1.item(i);
                    String name = attr1.getNodeName();
                    String value = attr1.getNodeValue();
                    Node attr2 = map2.getNamedItem(name);
                    if (attr2 == null) {
                        return false;
                    }
                    String value2 = attr2.getNodeValue();
                    if (value != value2 && !value.equalsIgnoreCase(value2)) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        }
        return false;
    }

    private static Document getSafeDocument(Node node) {
        if (node == null) {
            return null;
        }
        Document doc = node.getOwnerDocument();
        return node.getNodeType() == 9 ? (Document)node : doc;
    }

    class MyNodeList
    extends NodeListImpl {
        MyNodeList() {
        }

        protected Node appendNode(Node node) {
            return super.appendNode(node);
        }
    }

    class NodeRegion {
        private Node start;
        private Node end;

        public NodeRegion() {
        }

        public NodeRegion(Node start, Node end) {
            this.start = start;
            this.end = end;
        }

        public Node getStart() {
            return this.start;
        }

        public Node getEnd() {
            return this.end;
        }

        public void appendNode(Node node) {
            if (this.start == null) {
                this.start = node;
            }
            this.end = node;
        }

        public boolean isEmpty() {
            return this.start == null;
        }

        public void setEmpty() {
            this.start = null;
            this.end = null;
        }

        public boolean isStart(Node node) {
            return this.start == node;
        }

        public boolean isEnd(Node node) {
            return this.end == node;
        }

        public Node getPrev() {
            EditModelQuery query = EditQueryUtil.getEditQuery(this.getStart());
            if (query == null) {
                return null;
            }
            Node prev = this.getStart().getPreviousSibling();
            while (prev != null) {
                if (prev.getNodeType() != 3 || !query.isEmptyText((Text)prev)) break;
                prev = prev.getPreviousSibling();
            }
            return prev;
        }

        public Node getNext() {
            EditModelQuery query = EditQueryUtil.getEditQuery(this.getStart());
            if (query == null) {
                return null;
            }
            Node next = this.getEnd().getNextSibling();
            while (next != null) {
                if (next.getNodeType() != 3 || !query.isEmptyText((Text)next)) break;
                next = next.getNextSibling();
            }
            return next;
        }

        public String toString() {
            return "START : " + (this.start != null ? this.start.toString() : "null") + "\nEND   : " + (this.end != null ? this.end.toString() : "null");
        }
    }
}

