/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.common.commands.utils;

import com.ibm.etools.webedit.common.commands.utils.AbstractEditRange;
import com.ibm.etools.webedit.common.commands.utils.EditModelAction;
import org.eclipse.wst.xml.core.internal.document.ElementImpl;
import org.eclipse.wst.xml.core.internal.document.NodeListImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ranges.Range;

public class ChangeTag
extends AbstractEditRange {
    public ChangeTag(Range range) {
        super(range);
    }

    public ChangeTag(NodeList nodeList) {
        super(nodeList);
    }

    public Element change(Element element, String newTagName) {
        if (element == null || newTagName == null) {
            return null;
        }
        Element p = this.getNewElement(element, newTagName);
        if (p == null) {
            return null;
        }
        NodeList nodelist = this.getNodeList();
        Range range = this.getRange();
        Node child = element.getFirstChild();
        while (child != null) {
            Node next = child.getNextSibling();
            child = element.removeChild(child);
            p.appendChild(child);
            child = next;
        }
        Node parent = element.getParentNode();
        if (parent != null) {
            parent.insertBefore(p, element);
        }
        if (range != null) {
            if (element == range.getStartContainer()) {
                range.setStart(p, range.getStartOffset());
            }
            if (element == range.getEndContainer()) {
                range.setEnd(p, range.getEndOffset());
            }
        }
        if (nodelist != null) {
            boolean update = false;
            MyNodeList list = new MyNodeList();
            int i = 0;
            while (i < nodelist.getLength()) {
                Node node = nodelist.item(i);
                if (node == element) {
                    node = p;
                    update = true;
                }
                list.appendNode(node);
                ++i;
            }
            if (update) {
                this.setNodeList((NodeList)((Object)list));
            }
        }
        if (parent != null) {
            parent.removeChild(element);
        }
        return p;
    }

    private Element getNewElement(Element element, String newTagName) {
        Document doc;
        Document document = doc = element != null ? element.getOwnerDocument() : null;
        if (doc == null) {
            return null;
        }
        Element p = doc.createElement(newTagName);
        new EditModelAction().copyAttribute(element, p, true);
        if (p instanceof ElementImpl && this.isJspFormatRequired(newTagName)) {
            ((ElementImpl)p).setJSPTag(true);
        }
        return p;
    }

    private boolean isJspFormatRequired(String newTagName) {
        if (newTagName.equalsIgnoreCase("jsp:directive.include")) {
            return true;
        }
        if (newTagName.equalsIgnoreCase("jsp:directive.page")) {
            return true;
        }
        if (newTagName.equalsIgnoreCase("jsp:directive.taglib")) {
            return true;
        }
        if (newTagName.equalsIgnoreCase("jsp:expression")) {
            return true;
        }
        if (newTagName.equalsIgnoreCase("jsp:declaration")) {
            return true;
        }
        return newTagName.equalsIgnoreCase("jsp:scriptlet");
    }

    private class MyNodeList
    extends NodeListImpl {
        private MyNodeList() {
        }

        protected Node appendNode(Node node) {
            return super.appendNode(node);
        }
    }
}

