/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.common.commands.utils;

import com.ibm.etools.webedit.common.commands.utils.AttributeList;
import com.ibm.etools.webedit.common.commands.utils.EditModelQuery;
import com.ibm.etools.webedit.common.commands.utils.EditQueryUtil;
import com.ibm.etools.webedit.common.editdomain.HTMLSubModelContext;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Element;

public class AttributeListManipulator {
    private AttributeList attributes;
    private HTMLSubModelContext context;

    public AttributeListManipulator(AttributeList list, HTMLSubModelContext context) {
        this.attributes = list;
        this.context = context;
    }

    void pushAttribute(String name, String value) {
        if (this.attributes == null) {
            this.attributes = new AttributeList();
        }
        this.attributes.pushAttribute(name, value);
    }

    void pushUrlAttribute(String name, String value) {
        if (this.attributes == null) {
            this.attributes = new AttributeList();
        }
        this.attributes.pushUrlAttribute(name, value);
    }

    public void removeAttribute(Element element) {
        if (element == null) {
            return;
        }
        if (this.attributes == null) {
            return;
        }
        int i = 0;
        while (i < this.attributes.getLength()) {
            String attribute = this.attributes.getName(i);
            if (attribute != null) {
                element.removeAttribute(attribute);
            }
            ++i;
        }
    }

    public void setAttribute(Element element) {
        this.setAttribute(element, true);
    }

    public void setAttribute(Element element, boolean fixUp) {
        if (element == null) {
            return;
        }
        if (this.attributes == null) {
            return;
        }
        if (fixUp) {
            IDOMModel model = element instanceof IDOMNode ? ((IDOMNode)element).getModel() : null;
            this.attributes.doFixup(element.getNodeName(), (IStructuredModel)model, this.context, null);
        }
        int len = this.attributes.getLength();
        int i = 0;
        while (i < len) {
            String attribute = this.attributes.getName(i);
            if (attribute == null) break;
            String value = this.attributes.getValue(i);
            element.setAttribute(attribute, value);
            ++i;
        }
    }

    public int getAvailableAttributes(Element element) {
        if (element == null) {
            return 0;
        }
        EditModelQuery query = EditQueryUtil.getEditQuery(element);
        if (query == null) {
            return 0;
        }
        int ret = 0;
        int len = this.attributes != null ? this.attributes.getLength() : 0;
        int i = 0;
        while (i < len) {
            String attribute = this.attributes.getName(i);
            if (attribute == null) break;
            boolean def = query.isAttributeAvailable(element, attribute);
            if (def) {
                ++ret;
            }
            ++i;
        }
        return ret;
    }
}

