/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.common.commands.utils;

import com.ibm.etools.webedit.common.commands.utils.AttributeValue;
import com.ibm.etools.webedit.common.commands.utils.URLFixupUtil;
import com.ibm.etools.webedit.common.commands.utils.URLFixupper;
import com.ibm.etools.webedit.common.editdomain.HTMLSubModelContext;
import com.ibm.etools.webedit.common.editdomain.HTMLURLContext;
import com.ibm.etools.webedit.common.internal.utils.Logger;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;

public class AttributeList {
    private Hashtable items = null;
    private List itemsOrder = null;

    public AttributeList() {
        this.items = new Hashtable();
        this.itemsOrder = new ArrayList();
    }

    public AttributeList(AttributeList list) {
        this.items = new Hashtable(list.items);
        this.itemsOrder = new ArrayList(list.itemsOrder);
    }

    public Iterator attribute_iterator() {
        if (this.itemsOrder == null) {
            return null;
        }
        return this.itemsOrder.iterator();
    }

    public void clear() {
        if (this.items == null) {
            return;
        }
        this.items.clear();
        this.itemsOrder.clear();
    }

    public boolean copyList(AttributeList list) {
        if (list == null) {
            return false;
        }
        list.attribute_iterator();
        int i = 0;
        while (i < list.getLength()) {
            AttributeValue value = list.getAttributeValue(i);
            AttributeValue newValue = value == null ? null : new AttributeValue(value.getAttribute(), value.getValue(), value.isUrl());
            this.pushAttribute(list.getName(i), newValue);
            ++i;
        }
        return true;
    }

    public void doFixup(String tagName, IStructuredModel model, Shell shell) {
        this.doFixup(tagName, model, null, shell);
    }

    public void doFixup(String tagName, IStructuredModel model, HTMLSubModelContext context, Shell shell) {
        if (model == null || tagName == null) {
            return;
        }
        int len = this.getLength();
        ArrayList<AttributeValue> vec = null;
        int i = 0;
        while (i < len) {
            String value;
            String attribute;
            boolean isUrl;
            AttributeValue attr_value = this.getAttributeValue(i);
            if (attr_value != null && (isUrl = attr_value.isUrl()) && (attribute = attr_value.getAttribute()) != null && (value = attr_value.getValue()) != null) {
                if (vec == null) {
                    vec = new ArrayList<AttributeValue>();
                }
                vec.add(attr_value);
            }
            ++i;
        }
        if (vec != null) {
            try {
                URLFixupper fixupper = URLFixupUtil.getURLFixupper(model, (HTMLURLContext)context);
                fixupper.performLinkFixup(tagName, vec, shell);
                int i2 = 0;
                while (i2 < vec.size()) {
                    AttributeValue attr_value = (AttributeValue)vec.get(i2);
                    if (attr_value.isUpdated()) {
                        this.pushAttribute(attr_value.getAttribute(), attr_value.getValue());
                    }
                    ++i2;
                }
            }
            catch (Exception e) {
                Logger.log(e);
            }
        }
    }

    private AttributeValue getAttributeValue(int index) {
        if (this.itemsOrder == null) {
            return null;
        }
        if (index >= 0 && index < this.itemsOrder.size()) {
            String name = (String)this.itemsOrder.get(index);
            return (AttributeValue)this.items.get(name);
        }
        return null;
    }

    public int getLength() {
        if (this.items == null) {
            return 0;
        }
        return this.items.size();
    }

    public String getName(int index) {
        if (this.itemsOrder == null) {
            return null;
        }
        if (index >= 0 && index < this.itemsOrder.size()) {
            return (String)this.itemsOrder.get(index);
        }
        return null;
    }

    public String getValue(int index) {
        AttributeValue value = this.getAttributeValue(index);
        if (value == null) {
            return null;
        }
        return value.getValue();
    }

    public String getValue(String name) {
        if (this.items == null) {
            return null;
        }
        if (!this.items.containsKey(name)) {
            return null;
        }
        AttributeValue value = (AttributeValue)this.items.get(name);
        if (value == null) {
            return null;
        }
        return value.getValue();
    }

    public boolean isUrl(int index) {
        AttributeValue value = this.getAttributeValue(index);
        if (value == null) {
            return false;
        }
        return value.isUrl();
    }

    private void pushAttribute(String attr, AttributeValue value) {
        if (this.items == null) {
            this.items = new Hashtable();
            this.itemsOrder = new ArrayList();
        }
        if (this.items == null) {
            return;
        }
        if (this.items.containsKey(attr)) {
            this.items.remove(attr);
        } else {
            this.itemsOrder.add(attr);
        }
        this.items.put(attr, value);
    }

    public void pushAttribute(String attr, String value) {
        this.pushAttribute(attr, new AttributeValue(attr, value, false));
    }

    public void pushUrlAttribute(String attr, String value) {
        this.pushAttribute(attr, new AttributeValue(attr, value, true));
    }

    public boolean remove(String attr) {
        if (attr == null || this.items == null) {
            return false;
        }
        Object obj = this.items.remove(attr);
        this.itemsOrder.remove(attr);
        return obj != null;
    }
}

