/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.common.commands.proxy;

import com.ibm.etools.webedit.common.editdomain.HTMLSubModelContext;
import com.ibm.etools.webedit.common.internal.utils.StructuredModelFacade;
import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.TreeWalker;

public class HTMLSubModelContextCommandProxy
implements HTMLSubModelContext {
    IDOMModel fModel;

    public HTMLSubModelContextCommandProxy(IDOMModel model) {
        this.fModel = model;
    }

    @Override
    public HTMLSubModelContext.SubModelTraverser getSubModelTraverser(Node node, int filter) {
        return new LocalSubModelTraverser(node);
    }

    @Override
    public IStructuredModel getTaglibBaseModel() {
        return this.fModel;
    }

    @Override
    public Node[] getTaglibNodes(Node node) {
        if (node == null) {
            return new Node[0];
        }
        ArrayList<Node> array = new ArrayList<Node>();
        HTMLSubModelContext.SubModelTraverser walker = this.getSubModelTraverser(node, 1);
        if (walker != null) {
            Node current = walker.toRootNode();
            while (current != null) {
                String name;
                if (current instanceof Element && (name = ((Element)current).getTagName()) != null && (name.equals("jsp:directive.taglib") || name.equals("jsp:root"))) {
                    array.add(current);
                }
                current = walker.toNextNode();
            }
        }
        if (array.isEmpty()) {
            return new Node[0];
        }
        Node[] nodes = new Node[array.size()];
        array.toArray(nodes);
        return nodes;
    }

    @Override
    public String getTagLibBaseModelId() {
        return this.getTaglibBaseModel().getId();
    }

    @Override
    public IPath getLinkBase() {
        return new Path(StructuredModelFacade.getBaseLocation((IStructuredModel)this.fModel));
    }

    @Override
    public IPath getPageBase() {
        return new Path(StructuredModelFacade.getBaseLocation((IStructuredModel)this.fModel));
    }

    @Override
    public IPath getFileBase() {
        return new Path(StructuredModelFacade.getBaseLocation((IStructuredModel)this.fModel));
    }

    class LocalSubModelTraverser
    implements HTMLSubModelContext.SubModelTraverser {
        private TreeWalker walker;

        public LocalSubModelTraverser(Node node) {
            int filter = 2013;
            Document doc = node.getOwnerDocument();
            if (node.getNodeType() == 9) {
                doc = (Document)node;
            }
            this.walker = ((DocumentTraversal)((Object)doc)).createTreeWalker(doc, filter, null, false);
            this.walker.setCurrentNode(node);
        }

        @Override
        public Node toParentNode() {
            return this.walker.parentNode();
        }

        @Override
        public Node toPrevSiblingNode() {
            return this.walker.previousSibling();
        }

        @Override
        public Node toNextSiblingNode() {
            return this.walker.nextSibling();
        }

        @Override
        public Node toFirstChildNode() {
            return this.walker.firstChild();
        }

        @Override
        public Node toLastChildNode() {
            return this.walker.lastChild();
        }

        @Override
        public Node toRootNode() {
            while (this.toParentNode() != null) {
            }
            return this.walker.getCurrentNode();
        }

        @Override
        public Node toPreviousNode() {
            return this.walker.previousNode();
        }

        @Override
        public Node toNextNode() {
            return this.walker.nextNode();
        }
    }
}

