/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.common.commands.proxy;

import com.ibm.etools.webedit.common.commands.HTMLCommand;
import com.ibm.etools.webedit.common.commands.exceptions.HTMLCommandException;
import com.ibm.etools.webedit.common.commands.proxy.DesignPartCommandProxy;
import com.ibm.etools.webedit.common.commands.proxy.HTMLSelectionMediatorCommandProxy;
import com.ibm.etools.webedit.common.commands.proxy.HTMLSubModelContextCommandProxy;
import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import com.ibm.etools.webedit.common.editdomain.HTMLEditorEventListener;
import com.ibm.etools.webedit.common.editdomain.HTMLPaletteHandler;
import com.ibm.etools.webedit.common.editdomain.HTMLPaletteSource;
import com.ibm.etools.webedit.common.editdomain.HTMLPaletteTarget;
import com.ibm.etools.webedit.common.editdomain.HTMLSubModelContext;
import com.ibm.etools.webedit.common.internal.utils.Logger;
import com.ibm.etools.webedit.common.page.DesignPart;
import com.ibm.etools.webedit.common.page.PreviewPart;
import com.ibm.etools.webedit.common.utils.DefaultDocumentStyleHTMLImpl;
import com.ibm.etools.webedit.common.utils.DocumentStyleHTML;
import com.ibm.etools.webedit.common.utils.SelectionUtil;
import com.ibm.etools.webedit.common.utils.StyleContainerProvider;
import com.ibm.etools.webedit.selection.HTMLSelectionMediator;
import java.io.IOException;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.ranges.Range;

public class HTMLEditDomainCommandProxy
implements HTMLEditDomain,
StyleContainerProvider {
    private DesignPart fDesignPart;
    private int fVisualizeMode = 0;
    private HTMLSelectionMediator fMediator;
    private IDOMModel fModel;
    private IModelManager fModelManager;
    private Shell fShell;
    private HTMLCommand fPrevCommand = null;
    private String fTargetDevice = null;
    private Range prevRange = null;

    public HTMLEditDomainCommandProxy(IDOMModel model) {
        this.setModel(model);
        this.initDesignPartProxy();
    }

    @Override
    public void changeModel(Object id) {
        if (id != null) {
            IDOMModel oldModel = this.getModel();
            this.setModel(this.getExistingModelForEdit(id));
            if (oldModel != null) {
                oldModel.releaseFromEdit();
            }
        }
    }

    @Override
    public void changeTopModel(String filename) {
        Path filePath = new Path(filename);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile file = root.getFileForLocation((IPath)filePath);
        IModelManager manager = this.getModelManager();
        if (file == null || manager == null) {
            return;
        }
        try {
            IStructuredModel model = manager.getModelForEdit(file);
            if (model instanceof IDOMModel) {
                IDOMModel oldModel = this.getModel();
                this.setModel((IDOMModel)model);
                if (oldModel != null) {
                    oldModel.releaseFromEdit();
                }
            }
        }
        catch (IOException e) {
            Logger.log(e);
        }
        catch (CoreException e) {
            Logger.log(e);
        }
    }

    IModelManager getModelManager() {
        return this.fModelManager == null ? (this.fModelManager = StructuredModelManager.getModelManager()) : this.fModelManager;
    }

    @Override
    public boolean canDoRemoveOperation(Command command) {
        return true;
    }

    public void dispose() {
        if (this.getModel() != null) {
            this.getModel().releaseFromEdit();
            this.setModel(null);
        }
    }

    protected void initDesignPartProxy() {
        if (this.fDesignPart == null) {
            this.fDesignPart = new DesignPartCommandProxy(this.getModel());
        }
    }

    protected IDOMModel getExistingModelForEdit(Object id) {
        IModelManager manager = this.getModelManager();
        IStructuredModel model = null;
        if (manager != null) {
            model = manager.getExistingModelForEdit(id);
        }
        return model != null && model instanceof IDOMModel ? (IDOMModel)model : null;
    }

    @Override
    public IDOMModel getModel() {
        return this.getActiveModel();
    }

    @Override
    public void execCommand(Command command, boolean throwException) {
        Object exception = null;
        if (command != null && command.canExecute()) {
            if (command instanceof HTMLCommand) {
                HTMLCommand htmlCommand = (HTMLCommand)command;
                if (htmlCommand.toBeRecorded()) {
                    if (this.fPrevCommand != null) {
                        this.endRecording();
                    }
                } else if (this.fPrevCommand == null) {
                    IDOMModel model = htmlCommand.getModel();
                    Range range = this.getSelectionMediator().getRange();
                    if (range != null) {
                        int startOffset = SelectionUtil.calcFlatModelOffset((IDOMNode)range.getStartContainer(), range.getStartOffset());
                        int endOffset = SelectionUtil.calcFlatModelOffset((IDOMNode)range.getEndContainer(), range.getEndOffset());
                        model.beginRecording((Object)htmlCommand, htmlCommand.getLabel(), startOffset, endOffset - startOffset);
                    } else {
                        model.beginRecording((Object)htmlCommand, htmlCommand.getLabel());
                    }
                    this.fPrevCommand = htmlCommand;
                }
            }
            try {
                command.execute();
            }
            catch (HTMLCommandException ex) {
                Logger.log(ex);
            }
            if (this.fPrevCommand != null) {
                this.prevRange = this.getSelectionMediator().getRange();
                if (this.prevRange != null) {
                    this.prevRange = this.prevRange.cloneRange();
                }
            }
        }
        if (throwException && exception != null) {
            throw exception;
        }
    }

    public void doEndRecording() {
        if (this.fPrevCommand != null) {
            this.endRecording();
        }
    }

    private void endRecording() {
        IDOMModel model = this.fPrevCommand.getModel();
        if (this.prevRange != null) {
            int startOffset = SelectionUtil.calcFlatModelOffset((IDOMNode)this.prevRange.getStartContainer(), this.prevRange.getStartOffset());
            int endOffset = SelectionUtil.calcFlatModelOffset((IDOMNode)this.prevRange.getEndContainer(), this.prevRange.getEndOffset());
            model.endRecording((Object)this.fPrevCommand, startOffset, endOffset - startOffset);
        } else {
            model.endRecording((Object)this.fPrevCommand);
        }
        this.fPrevCommand = null;
        this.prevRange = null;
    }

    @Override
    public void execCommand(Command command) {
        this.execCommand(command, false);
    }

    @Override
    public StyleContainerProvider getStyleContainerProvider() {
        return this;
    }

    @Override
    public DocumentStyleHTML getStyleContainer(IDOMModel model) {
        return model == null ? null : new DefaultDocumentStyleHTMLImpl(model);
    }

    @Override
    public int getActivePageType() {
        return 0;
    }

    @Override
    public void setVisualizeMode(int mode) {
        this.fVisualizeMode = mode;
    }

    @Override
    public DesignPart getDesignPart() {
        return this.fDesignPart;
    }

    @Override
    public int getVisualizeMode() {
        return this.fVisualizeMode;
    }

    @Override
    public IEditorSite getEditorSite() {
        return null;
    }

    @Override
    public List getNodeRects() {
        return null;
    }

    @Override
    public HTMLPaletteHandler getPaletteHandler() {
        return null;
    }

    @Override
    public IWorkbenchPartSite getPartSite() {
        return null;
    }

    @Override
    public PreviewPart getPreviewPart() {
        return null;
    }

    @Override
    public String getTargetDevice() {
        return this.fTargetDevice;
    }

    @Override
    public StyledText getTextWidget() {
        return null;
    }

    @Override
    public HTMLPaletteTarget hookPalette(HTMLPaletteSource source) {
        return null;
    }

    @Override
    public boolean isWML() {
        return false;
    }

    @Override
    public void setActivePageType(int type) {
    }

    @Override
    public void setStatusLineManager(IStatusLineManager sm) {
    }

    @Override
    public void setTargetDevice(String id) {
        this.fTargetDevice = id;
    }

    @Override
    public void addHTMLEditorEventListener(HTMLEditorEventListener listener) {
    }

    @Override
    public void removeHTMLEditorEventListener(HTMLEditorEventListener listener) {
    }

    @Override
    public IDOMModel getActiveModel() {
        return this.fModel;
    }

    public void setModel(IDOMModel model) {
        this.fModel = model;
        if (this.getDesignPart() instanceof DesignPartCommandProxy) {
            ((DesignPartCommandProxy)this.getDesignPart()).setActiveViewModel(model);
        }
    }

    @Override
    public HTMLSelectionMediator getSelectionMediator() {
        return this.fMediator == null ? (this.fMediator = new HTMLSelectionMediatorCommandProxy()) : this.fMediator;
    }

    @Override
    public Shell getDialogParent() {
        return this.fShell;
    }

    public void setShell(Shell shell) {
        this.fShell = shell;
    }

    @Override
    public HTMLSubModelContext getActiveSubModelContext() {
        return this.getActiveModel() != null ? new HTMLSubModelContextCommandProxy(this.getActiveModel()) : null;
    }

    @Override
    public HTMLSubModelContext[] getSubModelContextsFor(IDOMModel model) {
        HTMLSubModelContext[] hTMLSubModelContextArray;
        if (model != null) {
            HTMLSubModelContext[] hTMLSubModelContextArray2 = new HTMLSubModelContext[1];
            hTMLSubModelContextArray = hTMLSubModelContextArray2;
            hTMLSubModelContextArray2[0] = new HTMLSubModelContextCommandProxy(model);
        } else {
            hTMLSubModelContextArray = null;
        }
        return hTMLSubModelContextArray;
    }
}

