/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.common.commands.factories;

import com.ibm.etools.webedit.common.commands.factories.AttrFixupNodeFactory;
import com.ibm.etools.webedit.common.commands.factories.NodeFactory;
import com.ibm.etools.webedit.common.commands.utils.AttributeList;
import com.ibm.etools.webedit.common.commands.utils.AttributeListManipulator;
import com.ibm.etools.webedit.common.commands.utils.EditModelQuery;
import com.ibm.etools.webedit.common.commands.utils.EditQueryUtil;
import com.ibm.etools.webedit.common.editdomain.HTMLSubModelContext;
import java.util.Vector;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMText;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.ranges.Range;

public abstract class AbstractNodeFactory
implements AttrFixupNodeFactory {
    private AttributeList attributes = null;
    private String tagName = "";
    private String src_data = null;
    private boolean raw_data = false;
    private Vector childFactories = null;
    private boolean fixedUp = false;
    private boolean isRangeTarget = false;
    private HTMLSubModelContext context;

    protected AbstractNodeFactory(String tag) {
        this.tagName = tag;
        this.attributes = new AttributeList();
        this.childFactories = new Vector();
        this.src_data = null;
    }

    protected final void setModifiedFlag(boolean flag) {
    }

    protected final void setRangeTarget(boolean set) {
        this.isRangeTarget = set;
    }

    public final void appendChildFactory(NodeFactory factory) {
        if (factory != null) {
            this.childFactories.add(factory);
            this.setModifiedFlag(true);
        }
    }

    protected final void clearChildFactories() {
        this.childFactories.removeAllElements();
        this.setModifiedFlag(true);
    }

    public final void setTextSourceAsChild(String src) {
        this.setTextSourceAsChild(src, false);
    }

    public final void setTextSourceAsChild(String src, boolean isRaw) {
        this.src_data = src;
        this.raw_data = isRaw;
        this.setModifiedFlag(true);
    }

    public void pushAttribute(String attr, String value) {
        this.attributes.pushAttribute(attr, value);
        this.setModifiedFlag(true);
    }

    protected final void removeAttribute(String attr) {
        this.attributes.remove(attr);
        this.setModifiedFlag(true);
    }

    public final void pushUrlAttribute(String attr, String value) {
        this.attributes.pushUrlAttribute(attr, value);
        this.fixedUp = false;
        this.setModifiedFlag(true);
    }

    protected void setTagName(String tag) {
        this.tagName = tag;
        this.setModifiedFlag(true);
    }

    protected final String getTextSourceOfChild() {
        if (this.src_data == null) {
            return null;
        }
        return new String(this.src_data);
    }

    public AttributeList getAttribute() {
        if (this.attributes == null) {
            return null;
        }
        return new AttributeList(this.attributes);
    }

    protected final String getAttribute(String attr) {
        String value = this.attributes.getValue(attr);
        if (value == null) {
            return null;
        }
        return new String(value);
    }

    protected final String getTagName() {
        if (this.tagName == null) {
            return null;
        }
        return new String(this.tagName);
    }

    protected final boolean isTagEqual(String name) {
        if (name == null) {
            return false;
        }
        return this.tagName.equalsIgnoreCase(name);
    }

    protected void setAttributes(Element element) {
        if (element == null) {
            return;
        }
        if (this.attributes.getLength() > 0) {
            AttributeListManipulator Attr2 = new AttributeListManipulator(this.attributes, this.context);
            Attr2.setAttribute(element, !this.fixedUp);
        }
    }

    protected boolean isAttributeAvailable(Document doc, String attrName) {
        return this.isAttributeAvailable(doc, this.tagName, attrName);
    }

    protected boolean isAttributeAvailable(Document doc, String tgn, String attrName) {
        if (doc == null) {
            return false;
        }
        EditModelQuery query = EditQueryUtil.getEditQuery(doc);
        if (query == null) {
            return false;
        }
        return query.isAttributeAvailable(tgn, attrName, doc);
    }

    protected Element createElement(Document doc) {
        if (this.tagName.length() == 0) {
            return null;
        }
        return doc.createElement(this.tagName);
    }

    @Override
    public boolean canCreateNode(Document doc) {
        if (doc == null) {
            return false;
        }
        EditModelQuery query = EditQueryUtil.getEditQuery(doc);
        if (query == null) {
            return false;
        }
        CMElementDeclaration decl = query.getElementDeclaration(this.tagName, doc);
        return decl != null;
    }

    @Override
    public Node createNode(Document doc, Range range) {
        Element elm = this.createElement(doc);
        if (elm == null) {
            return null;
        }
        this.setAttributes(elm);
        this.fixedUp = true;
        Text text = null;
        if (this.src_data != null && (text = doc.createTextNode("")) != null) {
            if (!this.raw_data && text instanceof IDOMText) {
                ((IDOMText)text).setValueSource(this.src_data);
            } else {
                text.setData(this.src_data);
            }
        }
        Node item = null;
        if (this.childFactories != null) {
            int i = 0;
            while (i < this.childFactories.size()) {
                NodeFactory factory = (NodeFactory)this.childFactories.get(i);
                item = factory.createNode(doc, range);
                if (item != null) {
                    elm.appendChild(item);
                }
                ++i;
            }
        }
        if (text != null) {
            elm.appendChild(text);
        }
        if (text != null) {
            range.setStart(text, text.getData().length());
        } else if (item != null && !this.isRangeTarget) {
            NodeList c = item.getChildNodes();
            int offset = c == null ? 0 : c.getLength();
            range.setStart(item, offset);
        } else {
            NodeList c = elm.getChildNodes();
            int offset = c == null ? 0 : c.getLength();
            range.setStart(elm, offset);
        }
        range.collapse(true);
        return elm;
    }

    @Override
    public void setLinkContext(HTMLSubModelContext context) {
        this.context = context;
    }

    protected HTMLSubModelContext getLinkContext() {
        return this.context;
    }
}

