/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.common.commands;

import com.ibm.etools.webedit.common.commands.HTMLCommand;
import com.ibm.etools.webedit.common.editdomain.HTMLCommandTarget;
import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import com.ibm.etools.webedit.common.utils.FreeLayoutUtil;
import com.ibm.etools.webedit.common.utils.SelectionUtil;
import com.ibm.etools.webedit.selection.HTMLSelectionMediator;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ranges.Range;

public abstract class RangeCommand
extends HTMLCommand {
    private HTMLSelectionMediator mediator = null;
    private Range range = null;
    private Node focusedNode = null;
    private NodeList nodeList = null;
    private Object nodeListData = null;
    private boolean rangeUpdated = false;
    private boolean nodeListUpdated = false;
    public static final HTMLCommand.Condition FLM_PROHIBIT = ALWAYS_FALSE;
    public static final HTMLCommand.Condition FLM_ADD_CELL = ALWAYS_TRUE;
    public static final HTMLCommand.Condition FLM_NA = DELEGATE_DECISION;

    public RangeCommand(String name) {
        super(name);
    }

    protected void afterEdit() {
    }

    protected void beforeEdit() {
    }

    @Override
    protected boolean canDoExecute() {
        return true;
    }

    @Override
    protected HTMLCommand.Condition preCondition() {
        return this.freeLayoutCondition();
    }

    public HTMLCommand.Condition getFreeLayoutSupport() {
        return FLM_NA;
    }

    public void setFreeLayoutSupport(HTMLCommand.Condition condition) {
    }

    @Override
    protected final void preExecute() {
        HTMLSelectionMediator mediator = this.getSelectionMediator();
        if (mediator != null) {
            mediator.pause();
        }
        this.beforeEdit();
        this.range = this.getRange();
        super.preExecute();
    }

    @Override
    protected final void postExecute() {
        super.postExecute();
        this.afterEdit();
        HTMLSelectionMediator selMed = this.getSelectionMediator();
        if (selMed == null) {
            return;
        }
        if (this.rangeUpdated) {
            if (this.isValidRange(this.range)) {
                if (this.focusedNode != null) {
                    selMed.setRange(this.range, this.focusedNode);
                } else {
                    selMed.setRange(this.range);
                }
            } else {
                selMed.reset();
            }
        } else if (this.nodeListUpdated) {
            selMed.setNodeList(this.nodeList, this.nodeListData);
        }
    }

    @Override
    protected final void cleanup(boolean enforceUpdate) {
        super.cleanup(enforceUpdate);
        this.range = null;
        this.focusedNode = null;
        this.rangeUpdated = false;
        this.nodeList = null;
        this.nodeListData = null;
        this.nodeListUpdated = false;
        HTMLSelectionMediator mediator = this.getSelectionMediator();
        if (mediator != null) {
            mediator.resume();
        }
    }

    @Override
    protected final void updateState(HTMLCommand cmd) {
        if (cmd == null) {
            this.range = null;
            this.focusedNode = null;
            this.rangeUpdated = false;
            this.nodeList = null;
            this.nodeListData = null;
            this.nodeListUpdated = false;
        }
        if (cmd instanceof RangeCommand) {
            RangeCommand rangeCmd = (RangeCommand)cmd;
            this.rangeUpdated = rangeCmd.rangeUpdated;
            if (this.rangeUpdated) {
                this.range = rangeCmd.range;
                this.focusedNode = rangeCmd.focusedNode;
            }
            this.nodeListUpdated = rangeCmd.nodeListUpdated;
            if (this.nodeListUpdated) {
                this.nodeList = rangeCmd.nodeList;
                this.nodeListData = rangeCmd.nodeListData;
            }
        }
    }

    protected final NodeList getNodeList() {
        if (this.nodeList != null) {
            return this.nodeList;
        }
        HTMLSelectionMediator selMed = this.getSelectionMediator();
        if (selMed == null) {
            return null;
        }
        return selMed.getNodeList();
    }

    protected final Object getNodeListData() {
        if (this.nodeListData != null) {
            return this.nodeListData;
        }
        HTMLSelectionMediator selMed = this.getSelectionMediator();
        if (selMed == null) {
            return null;
        }
        return selMed.getNodeListData();
    }

    protected final Range getRange() {
        Range r;
        if (this.nodeList != null) {
            return null;
        }
        if (this.range != null) {
            return this.range;
        }
        HTMLSelectionMediator selMed = this.getSelectionMediator();
        if (selMed == null) {
            return null;
        }
        if (this.nodeListUpdated && selMed.getNodeList() != null) {
            selMed.setNodeList(null);
            this.nodeListUpdated = false;
        }
        if ((r = selMed.getRange()) == null) {
            return null;
        }
        return r.cloneRange();
    }

    protected final Node getFocusedNode() {
        if (this.focusedNode != null) {
            return this.focusedNode;
        }
        HTMLSelectionMediator selMed = this.getSelectionMediator();
        if (selMed == null) {
            return null;
        }
        Node focus = selMed.getFocusedNode();
        if (focus != null && focus.getNodeType() == 3) {
            focus = focus.getParentNode();
        }
        return focus;
    }

    protected final void setNodeList(NodeList nodeList) {
        this.setNodeList(nodeList, null);
    }

    protected final void setNodeList(NodeList nodeList, Object nodeListData) {
        this.nodeList = nodeList;
        this.nodeListData = nodeListData;
        this.nodeListUpdated = true;
        if (this.rangeUpdated) {
            this.range = null;
            this.focusedNode = null;
            this.rangeUpdated = false;
        }
    }

    protected final void setRange(Range range) {
        this.setRange(range, null);
    }

    protected final void setRange(Range range, Node focus) {
        this.range = range;
        this.focusedNode = focus;
        this.rangeUpdated = true;
        if (this.nodeListUpdated) {
            this.nodeList = null;
            this.nodeListData = null;
            this.nodeListUpdated = false;
        }
    }

    protected HTMLSelectionMediator getRangeMediator() {
        return this.mediator;
    }

    public final void setSelectionMediator(HTMLSelectionMediator selectionMediator) {
        this.mediator = selectionMediator;
    }

    protected final HTMLSelectionMediator getSelectionMediator() {
        if (this.mediator != null) {
            return this.mediator;
        }
        HTMLCommandTarget target = this.getCommandTarget();
        if (target != null) {
            return target.getSelectionMediator();
        }
        return null;
    }

    protected final boolean isDesignPageActivated() {
        int viewMode = this.getViewMode();
        if (viewMode != -1) {
            switch (viewMode) {
                case 0: {
                    return true;
                }
                case 1: 
                case 2: {
                    return false;
                }
            }
            return false;
        }
        HTMLEditDomain domain = this.getDomain();
        return domain != null && domain.getActivePageType() == 0;
    }

    protected final boolean isSourcePageActivated() {
        int viewMode = this.getViewMode();
        if (viewMode != -1) {
            switch (viewMode) {
                case 1: {
                    return true;
                }
                case 0: 
                case 2: {
                    return false;
                }
            }
            return false;
        }
        HTMLEditDomain domain = this.getDomain();
        return domain != null && domain.getActivePageType() == 1;
    }

    protected final boolean isPreviewPageActivated() {
        int viewMode = this.getViewMode();
        if (viewMode != -1) {
            switch (viewMode) {
                case 2: {
                    return true;
                }
                case 0: 
                case 1: {
                    return false;
                }
            }
            return false;
        }
        HTMLEditDomain domain = this.getDomain();
        return domain != null && domain.getActivePageType() == 2;
    }

    @Override
    public IDOMModel getModel() {
        Range range;
        NodeList nl = this.getNodeList();
        if (nl != null) {
            try {
                return ((IDOMNode)nl.item(0)).getModel();
            }
            catch (Exception exception) {}
        }
        if ((range = this.getRange()) != null) {
            try {
                return ((IDOMNode)range.getStartContainer()).getModel();
            }
            catch (Exception exception) {}
        }
        return super.getModel();
    }

    @Override
    protected final int getSelectionStartOffset() {
        Range range = this.getRange();
        if (range != null) {
            return SelectionUtil.calcFlatModelOffset((IDOMNode)range.getStartContainer(), range.getStartOffset());
        }
        NodeList nodeList = this.getNodeList();
        if (nodeList != null && nodeList.getLength() > 0) {
            return SelectionUtil.calcFlatModelOffset((IDOMNode)nodeList.item(nodeList.getLength() - 1), 0);
        }
        return 0;
    }

    @Override
    protected final int getSelectionEndOffset() {
        Range range = this.getRange();
        if (range != null) {
            return SelectionUtil.calcFlatModelOffset((IDOMNode)range.getEndContainer(), range.getEndOffset());
        }
        NodeList nodeList = this.getNodeList();
        if (nodeList != null && nodeList.getLength() > 0) {
            return SelectionUtil.calcFlatModelOffset((IDOMNode)nodeList.item(nodeList.getLength() - 1), 0);
        }
        return 0;
    }

    protected final HTMLCommand.Condition freeLayoutCondition() {
        HTMLEditDomain domain = this.getDomain();
        if (domain != null && domain.getActivePageType() == 0 && domain.getDesignPart().isFreeLayoutMode() && FreeLayoutUtil.isFreeInsertState(this.getNodeList(), this.getFocusedNode(), this.getRange())) {
            return this.getFreeLayoutSupport();
        }
        return DELEGATE_DECISION;
    }

    private boolean isValidNode(Node node) {
        if (node == null) {
            return false;
        }
        Document document = node.getOwnerDocument();
        if (document == null) {
            return node.getNodeType() == 9;
        }
        Node parent = node.getParentNode();
        while (parent != null) {
            if (parent == document) {
                return true;
            }
            parent = parent.getParentNode();
        }
        return false;
    }

    private boolean isValidRange(Range range) {
        if (range == null) {
            return false;
        }
        return this.isValidNode(range.getStartContainer()) && this.isValidNode(range.getEndContainer());
    }
}

