/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.common.commands;

import com.ibm.etools.webedit.common.commands.HTMLCommand;
import com.ibm.etools.webedit.common.commands.utils.EditModelQuery;
import com.ibm.etools.webedit.common.commands.utils.EditQueryUtil;
import com.ibm.etools.webedit.common.editdomain.HTMLCommandTarget;
import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import com.ibm.etools.webedit.common.internal.commands.utils.UpdatedNodeFormatter;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Document;

public abstract class NonActiveDocumentEditCommand
extends HTMLCommand {
    private UpdatedNodeFormatter fmd = null;
    private EditModelQuery query = null;

    public NonActiveDocumentEditCommand(String name) {
        super(name);
    }

    @Override
    public IDOMModel getModel() {
        HTMLCommandTarget target = this.getCommandTarget();
        if (target instanceof HTMLEditDomain) {
            IDOMModel model;
            if (((HTMLEditDomain)target).getActivePageType() == 0 && (model = ((HTMLEditDomain)target).getDesignPart().getActiveViewModel()) != null) {
                return model;
            }
            return ((HTMLEditDomain)target).getModel();
        }
        if (target != null) {
            return target.getActiveModel();
        }
        return null;
    }

    @Override
    protected final void postExecute() {
        if (this.fmd != null) {
            this.fmd.cleanupHtml(null);
            this.fmd.deactivate();
            this.fmd.format(null);
            this.fmd.clear();
            this.fmd = null;
        }
    }

    @Override
    protected final void preExecute() {
        if (this.fmd == null) {
            Document domdoc = this.getDocument();
            this.fmd = new UpdatedNodeFormatter(domdoc);
        }
        this.fmd.clear();
        this.fmd.activate();
    }

    protected final Document getDocument() {
        IDOMModel model = this.getModel();
        return model != null ? model.getDocument() : null;
    }

    protected final EditModelQuery getEditQuery() {
        if (this.query == null) {
            this.query = EditQueryUtil.getEditQuery(this.getDocument());
        }
        return this.query;
    }

    protected final boolean isDesignPageActivated() {
        int viewMode = this.getViewMode();
        if (viewMode != -1) {
            switch (viewMode) {
                case 0: {
                    return true;
                }
                case 1: 
                case 2: {
                    return false;
                }
            }
            return false;
        }
        HTMLEditDomain domain = this.getDomain();
        return domain != null && domain.getActivePageType() == 0;
    }

    protected final boolean isSourcePageActivated() {
        int viewMode = this.getViewMode();
        if (viewMode != -1) {
            switch (viewMode) {
                case 1: {
                    return true;
                }
                case 0: 
                case 2: {
                    return false;
                }
            }
            return false;
        }
        HTMLEditDomain domain = this.getDomain();
        return domain != null && domain.getActivePageType() == 1;
    }

    protected final boolean isPreviewPageActivated() {
        int viewMode = this.getViewMode();
        if (viewMode != -1) {
            switch (viewMode) {
                case 2: {
                    return true;
                }
                case 0: 
                case 1: {
                    return false;
                }
            }
            return false;
        }
        HTMLEditDomain domain = this.getDomain();
        return domain != null && domain.getActivePageType() == 2;
    }
}

