/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.common.commands;

import com.ibm.etools.webedit.common.ResourceHandler;
import com.ibm.etools.webedit.common.commands.EditRangeCommand;
import com.ibm.etools.webedit.common.commands.factories.AttrFixupNodeFactory;
import com.ibm.etools.webedit.common.commands.factories.NodeFactory;
import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import com.ibm.etools.webedit.common.internal.commands.utils.SourceCommand;
import org.w3c.dom.Document;
import org.w3c.dom.ranges.Range;

public abstract class InsertNodeCommand
extends EditRangeCommand {
    private NodeFactory factory = null;
    private HTMLEditDomain editDomain = null;
    private Document document = null;
    private SourceCommand srcCmd = null;

    public InsertNodeCommand(NodeFactory factory) {
        super(ResourceHandler._UI_Insert_tags_1);
        this.setNodeFactory(factory);
    }

    @Override
    protected boolean canDoExecute() {
        SourceCommand cmd;
        if (this.isDesignPageActivated()) {
            if (this.getRange() == null || this.factory == null || !this.factory.canCreateNode(this.getDocument())) {
                return false;
            }
            return super.canDoExecute();
        }
        if (this.isSourcePageActivated() && (cmd = this.getSourceCommand()) != null) {
            return cmd.canExecute();
        }
        return false;
    }

    public boolean isCommandValidForSource() {
        return false;
    }

    @Override
    protected final void doExecute() {
        SourceCommand cmd;
        if (this.isDesignPageActivated() || this.isCommandValidForSource()) {
            Range newRange;
            Range range = this.getRange();
            if (range == null || this.factory == null) {
                return;
            }
            Document document = this.getDocument();
            if (document == null) {
                return;
            }
            if (this.factory instanceof AttrFixupNodeFactory) {
                ((AttrFixupNodeFactory)this.factory).setLinkContext(this.getCommandTarget().getActiveSubModelContext());
            }
            if ((newRange = this.doInsert(document, range, this.factory)) != null) {
                this.setRange(newRange);
            }
        } else if (this.isSourcePageActivated() && (cmd = this.getSourceCommand()) != null) {
            cmd.doExecute();
        }
    }

    protected void setNodeFactory(NodeFactory factory) {
        this.factory = factory;
    }

    protected Range getInsertRange() {
        return null;
    }

    private SourceCommand getSourceCommand() {
        Document doc = this.getDocument();
        HTMLEditDomain domain = this.getDomain();
        if (domain != null && domain != this.editDomain || doc != null && doc != this.document) {
            this.editDomain = domain;
            this.document = doc;
            this.srcCmd = new SourceCommand(this.editDomain, this.factory, this.document);
        }
        return this.srcCmd;
    }

    protected abstract Range doInsert(Document var1, Range var2, NodeFactory var3);
}

