/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.common.commands;

import com.ibm.etools.webedit.common.commands.exceptions.HTMLCommandDOMException;
import com.ibm.etools.webedit.common.commands.exceptions.HTMLCommandException;
import com.ibm.etools.webedit.common.editdomain.HTMLCommandTarget;
import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import com.ibm.etools.webedit.common.internal.editdomain.HTMLCommandTargetExtension;
import com.ibm.etools.webedit.common.internal.utils.Logger;
import com.ibm.etools.webedit.common.utils.ValidateEditUtil;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.command.Command;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.undo.IStructuredTextUndoManager;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.DOMException;

public abstract class HTMLCommand
extends org.eclipse.gef.commands.Command {
    private boolean modelEventBuffered = false;
    private HTMLCommandTarget commandTarget;
    private int viewMode = -1;
    public static final Condition ALWAYS_FALSE = new Condition(0);
    public static final Condition ALWAYS_TRUE = new Condition(1);
    public static final Condition DELEGATE_DECISION = new Condition(2);

    public HTMLCommand(String name) {
        super(name);
    }

    public final boolean canRedo() {
        return true;
    }

    public final boolean canUndo() {
        return true;
    }

    protected void cleanup(boolean enforceUpdate) {
    }

    protected void updateState(HTMLCommand cmd) {
    }

    protected abstract void doExecute();

    public final void execute() {
        block18: {
            if (!this.validateState()) {
                this.cleanup(true);
                return;
            }
            IDOMModel model = this.getModel();
            this.record(true, (IStructuredModel)model);
            boolean success = true;
            IStructuredTextUndoManager undoMgr = model.getUndoManager();
            Command undoCmd = undoMgr != null ? undoMgr.getUndoCommand() : null;
            try {
                try {
                    this.preExecute();
                    this.doExecute();
                    this.postExecute();
                }
                catch (HTMLCommandException cex) {
                    success = false;
                    throw cex;
                }
                catch (DOMException dex) {
                    success = false;
                    throw new HTMLCommandDOMException(dex);
                }
                catch (RuntimeException rex) {
                    success = false;
                    throw rex;
                }
                catch (Exception ex) {
                    Logger.log(ex);
                    success = false;
                    if (success) {
                        this.record(false, (IStructuredModel)model);
                        this.cleanup(false);
                    } else {
                        Command cmd;
                        this.record(false, (IStructuredModel)model);
                        Command command = cmd = undoMgr != null ? undoMgr.getUndoCommand() : null;
                        if (cmd != null && cmd != undoCmd) {
                            undoMgr.undo();
                        }
                        this.cleanup(false);
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                if (success) {
                    this.record(false, (IStructuredModel)model);
                    this.cleanup(false);
                } else {
                    Command cmd;
                    this.record(false, (IStructuredModel)model);
                    Command command = cmd = undoMgr != null ? undoMgr.getUndoCommand() : null;
                    if (cmd != null && cmd != undoCmd) {
                        undoMgr.undo();
                    }
                    this.cleanup(false);
                }
                throw throwable;
            }
            if (success) {
                this.record(false, (IStructuredModel)model);
                this.cleanup(false);
            } else {
                Command cmd;
                this.record(false, (IStructuredModel)model);
                Command command = cmd = undoMgr != null ? undoMgr.getUndoCommand() : null;
                if (cmd != null && cmd != undoCmd) {
                    undoMgr.undo();
                }
                this.cleanup(false);
            }
        }
    }

    public final boolean canExecute() {
        Condition pre = this.preCondition();
        if (ALWAYS_TRUE.equals(pre)) {
            return true;
        }
        if (ALWAYS_FALSE.equals(pre)) {
            return false;
        }
        return this.canDoExecute();
    }

    protected boolean canDoExecute() {
        return super.canExecute();
    }

    protected Condition preCondition() {
        return DELEGATE_DECISION;
    }

    protected boolean validateState() {
        IDOMModel model = this.getModel();
        if (model == null) {
            return false;
        }
        HTMLCommandTarget target = this.getCommandTarget();
        if (target == null) {
            return false;
        }
        if (target instanceof HTMLCommandTargetExtension) {
            return ((HTMLCommandTargetExtension)((Object)target)).validateModelState((IStructuredModel)model);
        }
        IStatus status = ValidateEditUtil.validateEdit((IStructuredModel)model, target.getDialogParent(), true);
        return status.isOK();
    }

    protected int getSelectionStartOffset() {
        return 0;
    }

    protected int getSelectionEndOffset() {
        return 0;
    }

    protected final HTMLEditDomain getDomain() {
        if (this.commandTarget != null) {
            return this.commandTarget instanceof HTMLEditDomain ? (HTMLEditDomain)this.commandTarget : null;
        }
        try {
            return (HTMLEditDomain)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getAdapter(HTMLEditDomain.class);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public IDOMModel getModel() {
        HTMLCommandTarget target = this.getCommandTarget();
        if (target != null) {
            return target.getActiveModel();
        }
        return null;
    }

    protected void postExecute() {
    }

    protected void preExecute() {
    }

    protected boolean bufferModelEvent() {
        return false;
    }

    private void record(boolean start, IStructuredModel model) {
        int selEnd;
        if (model == null) {
            return;
        }
        int selStart = this.getSelectionStartOffset();
        if (selStart > (selEnd = this.getSelectionEndOffset())) {
            int temp = selEnd;
            selEnd = selStart;
            selStart = temp;
        }
        int selLength = selEnd - selStart;
        if (start) {
            if (this.toBeRecorded()) {
                model.beginRecording((Object)this, this.getLabel(), selStart, selLength);
            }
            if (this.bufferModelEvent()) {
                model.aboutToChangeModel();
                this.modelEventBuffered = true;
            }
        } else {
            if (this.modelEventBuffered) {
                model.changedModel();
                this.modelEventBuffered = false;
            }
            if (this.toBeRecorded()) {
                model.endRecording((Object)this, selStart, selLength);
            }
        }
    }

    public boolean toBeRecorded() {
        return true;
    }

    public final void redo() {
    }

    public final void undo() {
    }

    public final HTMLCommandTarget getCommandTarget() {
        if (this.commandTarget != null) {
            return this.commandTarget;
        }
        return this.getDomain();
    }

    public final void setCommandTarget(HTMLCommandTarget target) {
        this.commandTarget = target;
    }

    public int getViewMode() {
        return this.viewMode;
    }

    public void setViewMode(int viewMode) {
        this.viewMode = viewMode;
    }

    public static class Condition {
        private Condition(int state) {
        }
    }
}

