/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.common.attrview.validator;

import com.ibm.etools.webedit.common.ResourceHandler;
import com.ibm.etools.webedit.common.attrview.validator.HTMLValidator;
import com.ibm.etools.webedit.common.attrview.validator.ValidationUtil;
import java.text.MessageFormat;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public abstract class ValueValidator
extends HTMLValidator {
    private static final String ERR_VALUE = ResourceHandler._UI_VALVal_0;
    private static final String ERR_VALUE_EMPTY = ResourceHandler._UI_VALVal_1;

    public ValueValidator(String attrName, String[] tagNames, Document document, NodeList nodeList, String value) {
        super(attrName, tagNames, document, nodeList, value);
    }

    public ValueValidator() {
    }

    public String getErrorMessage() {
        if (!this.validateJSPValue(this.value) && !this.isValueOK()) {
            if (this.value != null) {
                return MessageFormat.format(ERR_VALUE, this.value);
            }
            return ERR_VALUE_EMPTY;
        }
        return null;
    }

    public int getErrorLevel() {
        if (!this.validateJSPValue(this.value) && !this.isValueOK()) {
            return ValidationUtil.getUnknownAttributeValueSetting();
        }
        return 0;
    }

    public boolean isValueAllowed() {
        if (!this.validateJSPValue(this.value) && !this.isValueOK()) {
            int errorLevel = ValidationUtil.getUnknownAttributeValueSetting();
            return errorLevel != 2 && errorLevel != 3;
        }
        return true;
    }

    protected abstract boolean isValueOK();

    protected boolean validateJSPValue(String value) {
        return ValidationUtil.validateJSPValue(this.getDocument(), value);
    }
}

