/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.common.attrview.validator;

import org.eclipse.jst.jsp.core.internal.provisional.contenttype.ContentTypeIdForJSP;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDataType;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.document.InvalidCharacterException;
import org.eclipse.wst.xml.core.internal.document.SourceValidator;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ValidationUtil {
    private static CMElementDeclaration getCMElementDeclaration(Document document, String tagName) {
        CMDocument cmdoc;
        ModelQuery modelQuery = ModelQueryUtil.getModelQuery((Document)document);
        if (modelQuery == null) {
            return null;
        }
        Node node = null;
        NodeList nodeList = document.getElementsByTagName(tagName);
        if (nodeList != null && nodeList.getLength() > 0) {
            node = nodeList.item(0);
        }
        if (node == null) {
            try {
                node = document.createElement(tagName);
            }
            catch (DOMException dOMException) {
                node = document;
            }
        }
        if ((cmdoc = modelQuery.getCorrespondingCMDocument(node)) == null) {
            cmdoc = modelQuery.getCorrespondingCMDocument((Node)document);
        }
        if (cmdoc == null) {
            return null;
        }
        CMNamedNodeMap map = cmdoc.getElements();
        if (map == null) {
            return null;
        }
        return (CMElementDeclaration)map.getNamedItem(tagName);
    }

    private static CMAttributeDeclaration getCMAttributeDeclaration(Document document, String tagName, String attrName) {
        CMElementDeclaration edecl = ValidationUtil.getCMElementDeclaration(document, tagName);
        if (edecl == null) {
            return null;
        }
        CMNamedNodeMap amap = edecl.getAttributes();
        if (amap == null) {
            return null;
        }
        return (CMAttributeDeclaration)amap.getNamedItem(attrName);
    }

    public static int getUnknownAttributeSetting() {
        return 3;
    }

    public static int getUnknownAttributeValueSetting() {
        return 3;
    }

    public static int getUnknownTagSetting() {
        return 3;
    }

    public static boolean isKnownAttribute(Document document, String tagName, String attrName) {
        return ValidationUtil.getCMAttributeDeclaration(document, tagName, attrName) != null;
    }

    public static boolean isKnownAttributeValue(Document document, String tagName, String attrName, String value) {
        if (value == null || value.length() == 0) {
            return true;
        }
        CMAttributeDeclaration adecl = ValidationUtil.getCMAttributeDeclaration(document, tagName, attrName);
        if (adecl == null) {
            return true;
        }
        CMDataType atype = adecl.getAttrType();
        if (atype == null) {
            return true;
        }
        String[] values = atype.getEnumeratedValues();
        if (values == null || values.length < 1) {
            return true;
        }
        int i = 0;
        while (i < values.length) {
            if (value.equalsIgnoreCase(values[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isKnownTag(Document document, String tagName) {
        return ValidationUtil.getCMElementDeclaration(document, tagName) != null;
    }

    public static boolean isNumber(String value) {
        if (value == null) {
            return true;
        }
        try {
            int integer = Integer.parseInt(value);
            if (integer >= 0) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return false;
    }

    public static boolean validateJSPValue(Document document, String value) {
        if (document instanceof IDOMDocument) {
            int elEnd;
            int el;
            IDOMModel model = ((IDOMDocument)document).getModel();
            if (model == null) {
                return false;
            }
            String id = model.getContentTypeIdentifier();
            if (id != null && (id.equals(ContentTypeIdForJSP.ContentTypeID_JSP) || id.equals(ContentTypeIdForJSP.ContentTypeID_JSPFRAGMENT)) && value != null && value.indexOf(60) != -1) {
                try {
                    new SourceValidator((Node)document).validateSource(value);
                }
                catch (InvalidCharacterException invalidCharacterException) {
                    return false;
                }
                return true;
            }
            if (value != null && (el = value.indexOf("${")) > -1 && (elEnd = value.indexOf(125, el)) > -1) {
                return true;
            }
        }
        return false;
    }
}

