/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.common.attrview.validator;

import com.ibm.etools.webedit.common.attrview.validator.HTMLValidator;
import com.ibm.etools.webedit.common.attrview.validator.ReadOnlyValidator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class HTMLValidatorCollector
extends HTMLValidator {
    List validators;

    public HTMLValidatorCollector(String attrName, String[] tagNames, Document document, NodeList nodeList, String value) {
        super(attrName, tagNames, document, nodeList, value);
        this.initValidators();
    }

    public HTMLValidatorCollector() {
        this.initValidators();
    }

    public void add(int index, HTMLValidator validator) {
        if (validator != null && this.validators != null && !this.validators.contains(validator) && index >= 0 && index < this.validators.size()) {
            validator.setValue(this.attrName, this.tagNames, this.document, this.nodeList, this.value);
            this.validators.add(index, validator);
        }
    }

    public void add(HTMLValidator validator) {
        if (validator != null && this.validators != null && !this.validators.contains(validator)) {
            validator.setValue(this.attrName, this.tagNames, this.document, this.nodeList, this.value);
            this.validators.add(validator);
        }
    }

    public void clear() {
        if (this.validators != null) {
            this.validators.clear();
        }
    }

    public String getErrorMessage() {
        if (this.validators == null) {
            return null;
        }
        int size = this.validators.size();
        int i = 0;
        while (i < size) {
            String message;
            HTMLValidator validator = (HTMLValidator)this.validators.get(i);
            if (validator != null && (message = validator.getErrorMessage()) != null) {
                return message;
            }
            ++i;
        }
        return null;
    }

    public int getErrorLevel() {
        if (this.validators == null) {
            return 0;
        }
        int size = this.validators.size();
        int i = 0;
        while (i < size) {
            int level;
            HTMLValidator validator = (HTMLValidator)this.validators.get(i);
            if (validator != null && (level = validator.getErrorLevel()) != 0) {
                return level;
            }
            ++i;
        }
        return 0;
    }

    private void initValidators() {
        this.validators = new ArrayList(3);
        this.add(new ReadOnlyValidator());
        this.setValueAll();
    }

    public boolean isValueAllowed() {
        if (this.validators == null) {
            return true;
        }
        int size = this.validators.size();
        int i = 0;
        while (i < size) {
            boolean allowed;
            HTMLValidator validator = (HTMLValidator)this.validators.get(i);
            if (validator != null && !(allowed = validator.isValueAllowed())) {
                return allowed;
            }
            ++i;
        }
        return true;
    }

    public void remove(Class klass) {
        if (klass != null && this.validators != null) {
            Iterator iter = this.validators.iterator();
            while (iter.hasNext()) {
                HTMLValidator validator = (HTMLValidator)iter.next();
                if (validator == null || !validator.getClass().equals(klass)) continue;
                iter.remove();
            }
        }
    }

    @Override
    public void setValue(String value) {
        super.setValue(value);
        if (this.validators == null) {
            return;
        }
        int size = this.validators.size();
        int i = 0;
        while (i < size) {
            HTMLValidator validator = (HTMLValidator)this.validators.get(i);
            if (validator != null) {
                validator.setValue(value);
            }
            ++i;
        }
    }

    @Override
    public void setValue(String attrName, String[] tagNames, Document document, NodeList nodeList, String value) {
        super.setValue(attrName, tagNames, document, nodeList, value);
        if (this.validators == null) {
            return;
        }
        int size = this.validators.size();
        int i = 0;
        while (i < size) {
            HTMLValidator validator = (HTMLValidator)this.validators.get(i);
            if (validator != null) {
                validator.setValue(attrName, tagNames, document, nodeList, value);
            }
            ++i;
        }
    }

    private void setValueAll() {
        this.setValue(this.attrName, this.tagNames, this.document, this.nodeList, this.value);
    }
}

