/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.common.attrview.validator;

import com.ibm.etools.webedit.common.ResourceHandler;
import com.ibm.etools.webedit.common.attrview.validator.ValueValidator;
import com.ibm.etools.webedit.common.utils.CollectionUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AccessKeysValidator
extends ValueValidator {
    private static final String INVALID_ACCESSKEY_MSG = ResourceHandler._UI_AKV_0;
    private static final String USED_ACCESSKEY_MSG = ResourceHandler._UI_AKV_1;
    private Node node;

    public AccessKeysValidator(String attrName, String[] tagNames, Document document, NodeList nodeList, String value) {
        super(attrName, tagNames, document, nodeList, value);
    }

    public AccessKeysValidator() {
    }

    @Override
    public String getErrorMessage() {
        if (!this.validateJSPValue(this.value)) {
            if (!AccessKeysValidator.isValidAccessKey(this.value)) {
                return INVALID_ACCESSKEY_MSG;
            }
            if (!AccessKeysValidator.isUsedAccessKey(this.value, this.node)) {
                return USED_ACCESSKEY_MSG;
            }
        }
        return null;
    }

    public static boolean isUsedAccessKey(String value, Node node) {
        if (value == null) {
            return true;
        }
        String[] accessKeys = CollectionUtil.collectAccessKeys(node);
        if (accessKeys != null) {
            int i = 0;
            while (i < accessKeys.length) {
                if (value.compareTo(accessKeys[i]) == 0) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public static boolean isValidAccessKey(String value) {
        if (value == null) {
            return true;
        }
        return value.length() == 1;
    }

    @Override
    protected boolean isValueOK() {
        if (!AccessKeysValidator.isValidAccessKey(this.value)) {
            return false;
        }
        return AccessKeysValidator.isUsedAccessKey(this.value, this.node);
    }

    public void setAccessKeysNode(Node node) {
        this.node = node;
    }
}

