/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.common.attrview.pages;

import com.ibm.etools.attrview.AVCommandLauncher;
import com.ibm.etools.attrview.AVEditorContextProvider;
import com.ibm.etools.attrview.AVSelection;
import com.ibm.etools.attrview.AbstractAttributesView;
import com.ibm.etools.attrview.AttributesView;
import com.ibm.etools.attrview.sdk.AVContainer;
import com.ibm.etools.attrview.sdk.AVData;
import com.ibm.etools.attrview.sdk.AVPage;
import com.ibm.etools.attrview.sdk.AVPart;
import com.ibm.etools.webedit.common.attrview.HTMLNodeSelection;
import com.ibm.etools.webedit.common.attrview.HTMLPageDescriptor;
import com.ibm.etools.webedit.common.attrview.NodeSelection;
import com.ibm.etools.webedit.common.attrview.data.AttributeData;
import com.ibm.etools.webedit.common.attrview.pairs.HTMLPair;
import com.ibm.etools.webedit.common.attrview.picker.DefaultNodeListPicker;
import com.ibm.etools.webedit.common.attrview.picker.NodeListPicker;
import com.ibm.etools.webedit.common.commands.RangeCommand;
import com.ibm.etools.webedit.common.internal.attrview.HTMLStylePair;
import com.ibm.etools.webedit.common.internal.attrview.StyleMenuProvider;
import com.ibm.etools.webedit.common.internal.attrview.StylePageManager;
import java.util.ArrayList;
import org.eclipse.swt.widgets.Control;

public abstract class HTMLPage
extends AVPage {
    protected String[] tagNames;
    private ArrayList dataList = new ArrayList();
    private ArrayList partList = new ArrayList();
    private ArrayList pairList = new ArrayList();
    private AVEditorContextProvider editorContext;
    private HTMLPageDescriptor pageDescriptor;
    private AttributeData styleData;
    private StyleMenuProvider styleMenuProvider;

    public HTMLPage(String name) {
        super(null, name);
    }

    protected void addDataComponent(AVData data) {
        if (data != null) {
            this.dataList.add(data);
        }
    }

    protected void addPairComponent(HTMLPair pair) {
        HTMLPair stylePair;
        if (pair == null) {
            return;
        }
        this.pairList.add(pair);
        if (pair instanceof HTMLStylePair && (stylePair = ((HTMLStylePair)pair).getStylePair()) != null) {
            this.addDataComponent(stylePair.getData());
            this.addPartComponent(stylePair.getPart());
        }
        this.addDataComponent(pair.getData());
        this.addPartComponent(pair.getPart());
    }

    protected void addPartComponent(AVPart part) {
        if (part != null) {
            this.partList.add(part);
        }
    }

    protected void alignWidth(AVContainer[] containers) {
        if (containers != null && containers.length > 0) {
            Control[] labels = new Control[containers.length];
            Control[] composites = new Control[containers.length];
            int i = 0;
            while (i < containers.length) {
                if (containers[i] != null) {
                    labels[i] = containers[i].getLabel();
                    composites[i] = containers[i].getBaseContainer();
                }
                ++i;
            }
            this.alignWidth(labels);
            this.alignWidth(composites);
        }
    }

    protected void alignWidth(HTMLPair[] pairs) {
        if (pairs != null && pairs.length > 0) {
            Control[] labels = new Control[pairs.length];
            Control[] containers = new Control[pairs.length];
            int i = 0;
            while (i < pairs.length) {
                if (pairs[i] != null) {
                    containers[i] = pairs[i].getContainer();
                    labels[i] = pairs[i].getLabel();
                }
                ++i;
            }
            this.alignWidth(labels);
            this.alignWidth(containers);
        }
    }

    public boolean canUseStyleButton() {
        return false;
    }

    public void dispose() {
        this.dataList.clear();
        this.partList.clear();
        int pSize = this.pairList.size();
        int pIndex = 0;
        while (pIndex < pSize) {
            HTMLPair pair = (HTMLPair)this.pairList.get(pIndex);
            if (pair instanceof HTMLStylePair) {
                HTMLPair stylePair = ((HTMLStylePair)pair).getStylePair();
                HTMLPage.dispose(stylePair);
            }
            ++pIndex;
        }
        this.pairList.clear();
        this.editorContext = null;
        HTMLPage.dispose((AVData)this.styleData);
        this.styleData = null;
        this.styleMenuProvider = null;
        super.dispose();
    }

    protected static void dispose(HTMLPair pair) {
        if (pair != null) {
            HTMLPage.dispose((AVData)pair.getData());
            pair.setData(null);
            HTMLPage.dispose((AVPart)pair.getPart());
            pair.setPart(null);
        }
    }

    public ArrayList getDataList() {
        return this.dataList;
    }

    public final AVEditorContextProvider getEditorContext() {
        return this.editorContext;
    }

    public NodeListPicker getNodeListPicker(AVData data) {
        if (data != null && data instanceof AttributeData) {
            return this.getNodeListPicker(((AttributeData)data).getTagNames());
        }
        return null;
    }

    public NodeListPicker getNodeListPicker(String[] tagNames) {
        return new DefaultNodeListPicker(tagNames);
    }

    public HTMLPageDescriptor getPageDescriptor() {
        return this.pageDescriptor;
    }

    protected ArrayList getPairList() {
        return this.pairList;
    }

    public ArrayList getPartList() {
        return this.partList;
    }

    public AVSelection getSelection() {
        AVSelection selection;
        if (this.editorContext != null && (selection = this.editorContext.getSelection()) instanceof NodeSelection) {
            return selection;
        }
        return null;
    }

    public AttributeData getStyleData() {
        AVEditorContextProvider provider;
        if (this.canUseStyleButton() && this.styleData == null && (provider = this.getEditorContext()) instanceof StylePageManager) {
            this.styleData = ((StylePageManager)provider).getStyleDataFactory().createStyleData(this);
            this.styleData.setTagNames(this.tagNames);
            this.addDataComponent(this.styleData);
        }
        return this.styleData;
    }

    public StyleMenuProvider getStyleMenuProvider() {
        AVEditorContextProvider provider;
        if (this.canUseStyleButton() && this.styleMenuProvider == null && (provider = this.getEditorContext()) instanceof StylePageManager) {
            this.styleMenuProvider = ((StylePageManager)provider).getStyleMenuProviderFactory().createStyleMenuProvider((Object)this.getStyleData());
        }
        return this.styleMenuProvider;
    }

    public final void launchCommand(RangeCommand command) {
        AVSelection selection;
        AVCommandLauncher launcher = this.editorContext.getCommandLauncher();
        if (launcher != null && (selection = this.getSelection()) instanceof HTMLNodeSelection) {
            command.setSelectionMediator(((HTMLNodeSelection)selection).getSelectionMediator());
            launcher.launch((Object)command);
            AttributesView attrview = this.getAttributesView();
            if (attrview instanceof AbstractAttributesView) {
                ((AbstractAttributesView)attrview).refreshContents(false);
            }
        }
    }

    protected void postCreate() {
        this.getStyleData();
        super.postCreate();
    }

    public void reset() {
        this.editorContext = null;
    }

    public void setEditorContext(AVEditorContextProvider editorContext) {
        this.editorContext = editorContext;
    }

    public void setPageDescriptor(HTMLPageDescriptor pageDescriptor) {
        this.pageDescriptor = pageDescriptor;
    }

    public void updateControl() {
        int i = 0;
        while (i < this.partList.size()) {
            AVPart part = (AVPart)this.partList.get(i);
            part.updateContents();
            ++i;
        }
    }

    public void updateData(AVEditorContextProvider editorContext) {
        this.reset();
        this.setEditorContext(editorContext);
        int i = 0;
        while (i < this.dataList.size()) {
            AVData data = (AVData)this.dataList.get(i);
            data.updateContents();
            ++i;
        }
    }
}

