/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.common.attrview.data;

import com.ibm.etools.attrview.AVSelection;
import com.ibm.etools.attrview.sdk.AVPage;
import com.ibm.etools.attrview.sdk.AVValueItem;
import com.ibm.etools.attrview.utils.StringUtil;
import com.ibm.etools.webedit.common.attrview.NodeSelection;
import com.ibm.etools.webedit.common.attrview.data.TableData;
import com.ibm.etools.webedit.common.attrview.pages.HTMLPage;
import com.ibm.etools.webedit.common.attrview.picker.NodeListPicker;
import com.ibm.etools.webedit.common.utils.AttributeDataUtil;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class TableNodeListData
extends TableData {
    public TableNodeListData(AVPage page, String[] tagNames, String attrName) {
        super(page, tagNames, attrName, null);
    }

    public static String getChildTextValue(Node node) {
        String text = AttributeDataUtil.getChildTextValue(node, false);
        if (text != null) {
            return StringUtil.formatText((String)text);
        }
        return "";
    }

    public static String[] getAttributesNode(Node node) {
        Attr[] attrs = AttributeDataUtil.getAttributesNode(node);
        if (attrs != null) {
            String[] names = new String[attrs.length];
            int i = 0;
            while (i < attrs.length) {
                names[i] = attrs[i] != null ? attrs[i].getName() : null;
                ++i;
            }
            return names;
        }
        return null;
    }

    public static String[] getAttributesValue(Node node) {
        return AttributeDataUtil.getAttributesValue(node);
    }

    public static String getAttributeValue(Node node, String attrName) {
        String value = AttributeDataUtil.getAttributeValue(node, attrName);
        if (value != null) {
            return value;
        }
        return "";
    }

    protected abstract Object[] getItems(Node var1);

    protected Object[] getItems(NodeList nodeList) {
        if (nodeList == null) {
            return null;
        }
        Vector<Object> items = new Vector<Object>();
        int len = nodeList.getLength();
        int i = 0;
        while (i < len) {
            Node node = nodeList.item(i);
            Object[] nodeItems = this.getItems(node);
            if (nodeItems != null) {
                int j = 0;
                while (j < nodeItems.length) {
                    if (nodeItems[j] != null) {
                        items.add(nodeItems[j]);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return TableNodeListData.getItems(items);
    }

    public static Object[] getItems(List items) {
        if (items == null || items.size() <= 0) {
            return null;
        }
        int size = items.size();
        Object[] retItems = new Object[size];
        int i = 0;
        while (i < size) {
            retItems[i] = items.get(i);
            ++i;
        }
        return retItems;
    }

    public static Object[] getSortedItems(List items) {
        if (items == null || items.size() <= 0) {
            return null;
        }
        Collections.sort(items, new Comparator(){

            public int compare(Object object1, Object object2) {
                if (object1 == object2) {
                    return 0;
                }
                if (object1 == null) {
                    return 0;
                }
                if (object2 == null) {
                    return 0;
                }
                if (object1 instanceof AVValueItem[] && object2 instanceof AVValueItem[]) {
                    AVValueItem[] object1AV = (AVValueItem[])object1;
                    AVValueItem[] object2AV = (AVValueItem[])object2;
                    String valueObject1 = object1AV[0].getValue();
                    String valueObject2 = object2AV[0].getValue();
                    return valueObject1.compareTo(valueObject2);
                }
                return 0;
            }
        });
        int size = items.size();
        Object[] retItems = new Object[size];
        int i = 0;
        while (i < size) {
            retItems[i] = items.get(i);
            ++i;
        }
        return retItems;
    }

    public static boolean hasAttribute(Node node, String attrName) {
        return AttributeDataUtil.getAttributeNode(node, attrName) != null;
    }

    @Override
    protected void update(AVSelection selection) {
        NodeListPicker nodeListPicker;
        if (selection != null && selection instanceof NodeSelection && this.page != null && this.page instanceof HTMLPage && (nodeListPicker = ((HTMLPage)this.page).getNodeListPicker(this)) != null) {
            NodeList nodeList = nodeListPicker.pickup((NodeSelection)selection);
            this.setTargetNodeList(nodeList);
            Object[] items = this.getItems(nodeList);
            this.setItems(items);
            this.setValue(items != null ? "" : null);
            this.setValueSpecified(items != null);
            this.setValueUnique(true);
        }
    }
}

