/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.common.attrview.data;

import com.ibm.etools.attrview.sdk.AVData;
import com.ibm.etools.attrview.sdk.AVSelectComponent;
import com.ibm.etools.attrview.sdk.AVValueItem;
import com.ibm.etools.webedit.common.attrview.NodeNameItem;
import com.ibm.etools.webedit.common.attrview.NodeSelection;
import com.ibm.etools.webedit.common.attrview.picker.NodeListPicker;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class SelectNodeValue {
    private NodeSelection selection;
    private AVData data;
    private NodeList nodeList;
    private NodeNameItem selectionItem;
    private String value;
    private boolean specified;
    private boolean unique;

    public SelectNodeValue(NodeSelection selection, AVData data, NodeListPicker nodeListPicker) {
        this.selection = selection;
        this.data = data;
        if (nodeListPicker != null) {
            this.nodeList = nodeListPicker.pickup(selection);
            if (this.nodeList != null) {
                int length = this.nodeList.getLength();
                boolean found = false;
                int i = 0;
                while (i < length) {
                    Node node = this.nodeList.item(i);
                    if (!found) {
                        this.selectionItem = SelectNodeValue.findItem(data, node);
                        if (this.selectionItem != null) {
                            this.value = this.selectionItem.getValue();
                            this.specified = true;
                            this.unique = true;
                            found = true;
                        }
                    } else {
                        boolean bl = this.unique = this.selectionItem == SelectNodeValue.findItem(data, node);
                        if (!this.unique) break;
                    }
                    ++i;
                }
            }
        }
    }

    public static NodeNameItem findItem(AVData data, Node node) {
        AVValueItem[] items;
        if (data != null && data instanceof AVSelectComponent && (items = ((AVSelectComponent)data).getItems()) != null) {
            int i = 0;
            while (i < items.length) {
                NodeNameItem item;
                if (items[i] != null && items[i] instanceof NodeNameItem && (item = (NodeNameItem)items[i]).isAvailable() && item.matches(node)) {
                    return item;
                }
                ++i;
            }
        }
        return null;
    }

    public int getSelectionIndex() {
        AVValueItem[] items;
        if (this.selection != null && this.data != null && this.data instanceof AVSelectComponent && (items = ((AVSelectComponent)this.data).getItems()) != null) {
            int i = 0;
            while (i < items.length) {
                if (items[i].isAvailable() && items[i] == this.selectionItem) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public NodeNameItem getSelectionItem() {
        return this.selectionItem;
    }

    public NodeList getTargetNodeList() {
        return this.nodeList;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isSpecified() {
        return this.specified;
    }

    public boolean isUnique() {
        return this.unique;
    }
}

