/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.common.attrview.data;

import com.ibm.etools.attrview.AVSelection;
import com.ibm.etools.attrview.sdk.AVPage;
import com.ibm.etools.attrview.sdk.AVSelectComponent;
import com.ibm.etools.attrview.sdk.AVValueItem;
import com.ibm.etools.attrview.sdk.AVValueItemUtil;
import com.ibm.etools.attrview.sdk.ValueItem;
import com.ibm.etools.webedit.common.attrview.data.AttributeData;

public class SelectData
extends AttributeData
implements AVSelectComponent {
    private AVValueItem[] activeItems;
    private AVValueItem[] initialItems;
    private int defaultIndex = -1;
    private boolean itemIncrease;

    public SelectData(AVPage page, String[] tagNames, String attrName, AVValueItem[] items) {
        this(page, tagNames, attrName, items, true);
    }

    public SelectData(AVPage page, String[] tagNames, String attrName, AVValueItem[] items, boolean itemIncrease) {
        this(page, tagNames, attrName, items, itemIncrease, true);
    }

    public SelectData(AVPage page, String[] tagNames, String attrName, AVValueItem[] items, boolean itemIncrease, boolean ignoreCase) {
        super(page, tagNames, attrName, ignoreCase);
        this.activeItems = items;
        this.initialItems = items;
        this.itemIncrease = itemIncrease;
    }

    private int findSelection(String value) {
        AVValueItem[] items = this.getItems();
        if (items != null) {
            int i = 0;
            while (i < items.length) {
                if (items[i].isAvailable() && items[i].matches(value)) {
                    return i;
                }
                ++i;
            }
        }
        return this.defaultIndex;
    }

    public int getItemCount() {
        AVValueItem[] values = this.getItems();
        if (values != null) {
            return values.length;
        }
        return 0;
    }

    public AVValueItem[] getItems() {
        if (this.activeItems != null) {
            return this.activeItems;
        }
        return null;
    }

    public int getSelectionIndex() {
        return this.findSelection(this.getValue());
    }

    public void setDefaultIndex(int defaultIndex) {
        this.defaultIndex = defaultIndex;
    }

    public void setItems(AVValueItem[] items) {
        this.activeItems = items;
        this.initialItems = items;
    }

    @Override
    protected void update(AVSelection selection) {
        String value;
        super.update(selection);
        this.activeItems = this.initialItems;
        if (this.itemIncrease && (value = this.getValue()) != null && this.activeItems != null) {
            int itemCount = this.activeItems.length;
            int index = AVValueItemUtil.getItemIndexByValue((AVValueItem[])this.activeItems, (String)value);
            if (index == -1) {
                AVValueItem[] newItems = new AVValueItem[itemCount + 1];
                int i = 0;
                while (i < itemCount) {
                    newItems[i] = this.activeItems[i];
                    ++i;
                }
                newItems[itemCount] = new ValueItem(value, value, this.isIgnoreCase());
                this.activeItems = newItems;
            }
        }
    }
}

