/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.common.attrview.data;

import com.ibm.etools.attrview.sdk.AVValueTester;
import com.ibm.etools.webedit.common.attrview.NodeSelection;
import com.ibm.etools.webedit.common.attrview.picker.NodeListPicker;
import com.ibm.etools.webedit.common.utils.NodeDataAccessor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class AttributeValue {
    private NodeList nodeList;
    private String value;
    private boolean specified;
    private boolean unique;

    public AttributeValue(NodeSelection selection, String attrName, NodeListPicker nodeListPicker, AVValueTester tester) {
        if (nodeListPicker != null) {
            this.nodeList = nodeListPicker.pickup(selection);
            if (this.nodeList != null) {
                int len = this.nodeList.getLength();
                int i = 0;
                while (i < len) {
                    Node node = this.nodeList.item(i);
                    Attr attr = AttributeValue.getAttr(node, attrName);
                    if (i == 0) {
                        if (attr != null) {
                            this.value = NodeDataAccessor.getAttribute(attr);
                            this.specified = true;
                            this.unique = true;
                        }
                    } else {
                        if (attr != null) {
                            this.unique = tester.test(this.value, NodeDataAccessor.getAttribute(attr));
                        } else {
                            boolean bl = this.unique = !this.specified;
                        }
                        if (!this.unique) break;
                    }
                    ++i;
                }
            }
        }
    }

    public static Attr getAttr(Node node, String attrName) {
        NamedNodeMap map;
        if (node != null && attrName != null && (map = node.getAttributes()) != null) {
            int len = map.getLength();
            int i = 0;
            while (i < len) {
                Node item = map.item(i);
                if (item instanceof Attr) {
                    Attr attr = (Attr)item;
                    if (node instanceof IDOMElement && ((IDOMElement)node).isGlobalTag() ? attrName.equalsIgnoreCase(attr.getName()) : attrName.equals(attr.getName())) {
                        return attr;
                    }
                }
                ++i;
            }
        }
        return null;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isSpecified() {
        return this.specified;
    }

    public NodeList getTargetNodeList() {
        return this.nodeList;
    }

    public boolean isUnique() {
        return this.unique;
    }
}

