/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.common.attrview;

import com.ibm.etools.attrview.AVContents;
import com.ibm.etools.attrview.AVEditorContextProvider;
import com.ibm.etools.attrview.AbstractAttributesViewContributor;
import com.ibm.etools.attrview.AbstractEditorContextProvider;
import com.ibm.etools.attrview.AttributesView;
import com.ibm.etools.attrview.AttributesViewContributor;
import com.ibm.etools.attrview.utils.RegistryUtil;
import com.ibm.etools.attrview.utils.StringUtil;
import com.ibm.etools.webedit.common.attrview.AllAttributesViewContributor;
import com.ibm.etools.webedit.common.attrview.PDAttributesView;
import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import com.ibm.etools.webedit.common.internal.attrview.ActionBarsContributor;
import com.ibm.etools.webedit.common.internal.attrview.AllAttributesViewAction;
import com.ibm.etools.webedit.common.internal.attrview.ContributorManager;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.action.IAction;

public class PDAttributesViewContributor
extends AbstractAttributesViewContributor {
    private static final String LOCAL_VIEW_ID = "com.ibm.webedit.common.attrview.PDAttributesView.localView";
    private static final String TAG_SELECTION = "selection";
    private static final String ALL_TOOL_ID = "com.ibm.etools.webedit.common.internal.attrview.AllAttributesViewTool.allTool";

    public AVContents getContentsFor(AttributesView view, AVEditorContextProvider editorContext) {
        PDAttributesView localView = this.getLocalView(view);
        IConfigurationElement[] configurations = ContributorManager.getConfigurations();
        HTMLEditDomain editDomain = (HTMLEditDomain)((AbstractEditorContextProvider)editorContext).getWorkbenchPart().getAdapter(HTMLEditDomain.class);
        AVContents contents = null;
        AttributesViewContributor contributor = null;
        if (editDomain != null && editDomain.getActivePageType() != 2) {
            int i = 0;
            while (i < configurations.length) {
                if (this.compareSelectionHints(editorContext, configurations[i]) && (contributor = ContributorManager.getContributor(configurations[i], true)) != null) {
                    ActionBarsContributor allActionBars = this.getAllActionBarsContributor((AttributesView)localView, true);
                    if (allActionBars != null && allActionBars.isChecked()) {
                        if (contributor instanceof AllAttributesViewContributor) {
                            contents = ((AllAttributesViewContributor)contributor).getAllContentsFor((AttributesView)localView, editorContext);
                        }
                    } else {
                        contents = contributor.getContentsFor((AttributesView)localView, editorContext);
                    }
                    if (contents != null) break;
                }
                ++i;
            }
        }
        localView.setContents(contents);
        localView.setContributor(contributor);
        return localView;
    }

    public void viewDestroyed(AttributesView view) {
        this.removeAllActionBarsContributor(view);
        PDAttributesView localView = this.getLocalView(view);
        IConfigurationElement[] configurations = ContributorManager.getConfigurations();
        int i = 0;
        while (i < configurations.length) {
            AttributesViewContributor contributor = ContributorManager.getContributor(configurations[i], false);
            if (contributor != null) {
                contributor.viewDestroyed((AttributesView)localView);
            }
            ++i;
        }
        this.removeLocalView(view);
    }

    public void aboutToBeHidden(AttributesView view) {
        PDAttributesView localView = this.getLocalView(view);
        IConfigurationElement[] configurations = ContributorManager.getConfigurations();
        int i = 0;
        while (i < configurations.length) {
            AttributesViewContributor contributor = ContributorManager.getContributor(configurations[i], false);
            if (contributor != null) {
                contributor.aboutToBeHidden((AttributesView)localView);
            }
            ++i;
        }
    }

    public void aboutToBeShown(AttributesView view) {
        PDAttributesView localView = this.getLocalView(view);
        IConfigurationElement[] configurations = ContributorManager.getConfigurations();
        int i = 0;
        while (i < configurations.length) {
            AttributesViewContributor contributor = ContributorManager.getContributor(configurations[i], false);
            if (contributor != null) {
                contributor.aboutToBeShown((AttributesView)localView);
            }
            ++i;
        }
        this.getAllActionBarsContributor(view, true);
    }

    private ActionBarsContributor getAllActionBarsContributor(AttributesView view, boolean create) {
        Object obj = view.getData((Object)ALL_TOOL_ID);
        ActionBarsContributor allActionBars = null;
        if (obj instanceof ActionBarsContributor) {
            allActionBars = (ActionBarsContributor)obj;
        }
        if (create && allActionBars == null) {
            allActionBars = new ActionBarsContributor(view, (IAction)new AllAttributesViewAction(view));
            view.setData((Object)ALL_TOOL_ID, (Object)allActionBars);
            allActionBars.setEnabled(true);
        }
        return allActionBars;
    }

    private PDAttributesView getLocalView(AttributesView view) {
        Object localView = view.getData((Object)LOCAL_VIEW_ID);
        if (!(localView instanceof PDAttributesView)) {
            localView = new PDAttributesView(view);
            view.setData((Object)LOCAL_VIEW_ID, localView);
        }
        return (PDAttributesView)((Object)localView);
    }

    private boolean compareSelectionHints(AVEditorContextProvider editorContext, IConfigurationElement config) {
        String[] configHints = RegistryUtil.getChildValues((IConfigurationElement)config, (String)TAG_SELECTION);
        if (configHints == null) {
            return true;
        }
        String[] editorHints = editorContext.getSelectionHints();
        if (editorHints == null) {
            return false;
        }
        int i = 0;
        while (i < editorHints.length) {
            if (StringUtil.containsIgnoreCase((String)editorHints[i], (String[])configHints)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void removeAllActionBarsContributor(AttributesView view) {
        ActionBarsContributor allActionBars = this.getAllActionBarsContributor(view, false);
        if (allActionBars != null) {
            allActionBars.dispose();
        }
        view.removeData((Object)ALL_TOOL_ID);
    }

    private void removeLocalView(AttributesView view) {
        PDAttributesView localView = this.getLocalView(view);
        if (localView != null) {
            localView.dispose();
        }
        view.removeData((Object)LOCAL_VIEW_ID);
    }
}

