/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.actionset;

import com.ibm.etools.webedit.common.actions.ActionProvider;
import com.ibm.etools.webedit.common.actions.ActionProviderListener;
import com.ibm.etools.webedit.common.actions.UpdateAction;
import com.ibm.etools.webedit.common.utils.ActionUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public abstract class AbstractAction
implements IWorkbenchWindowActionDelegate,
IPartListener,
ActionProviderListener {
    private ActionProvider actionProvider;
    private IAction action;
    private IAction delegatedAction;
    private String orgTooltip;
    private IPartService partService;
    private IWorkbenchPart targetPart;

    public void dispose() {
        this.partService.removePartListener((IPartListener)this);
        if (this.actionProvider != null) {
            this.actionProvider.removeListener(this);
        }
    }

    public void init(IWorkbenchWindow window) {
        this.partService = window.getPartService();
        this.partService.addPartListener((IPartListener)this);
    }

    public void run(IAction a) {
        if (this.action != null && this.action.isEnabled()) {
            this.action.run();
        }
        if (this.action != null && this.isToggle()) {
            this.delegatedAction.setToolTipText(this.action.getToolTipText());
        }
    }

    public void selectionChanged(IAction a, ISelection selection) {
        if (this.delegatedAction != a) {
            this.delegatedAction = a;
            if (this.delegatedAction != null) {
                this.orgTooltip = this.delegatedAction.getToolTipText();
            }
            this.updateAction((IWorkbenchPart)ActionUtil.getActiveEditorPart());
        }
    }

    protected abstract String getActionId();

    public void partActivated(IWorkbenchPart part) {
        if (part != this.targetPart) {
            this.targetPart = part;
            this.updateAction(part);
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (part == this.targetPart) {
            this.updateAction(null);
            this.targetPart = null;
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
        if (part == this.targetPart) {
            this.updateAction(null);
            this.targetPart = null;
        }
    }

    public void partOpened(IWorkbenchPart part) {
    }

    protected boolean isToggle() {
        return false;
    }

    protected void updateAction(IWorkbenchPart part) {
        IEditorActionBarContributor contributor;
        IEditorPart editor;
        IEditorSite site;
        if (this.actionProvider != null) {
            this.actionProvider.removeListener(this);
            this.actionProvider = null;
        }
        this.action = null;
        if (this.delegatedAction == null) {
            return;
        }
        if (part instanceof IEditorPart && (site = (editor = (IEditorPart)part).getEditorSite()) != null && (contributor = site.getActionBarContributor()) instanceof ActionProvider) {
            this.actionProvider = (ActionProvider)contributor;
            this.actionProvider.addListener(this);
            this.action = this.actionProvider.getAction(this.getActionId());
            if (this.action != null) {
                if (this.action instanceof UpdateAction) {
                    ((UpdateAction)this.action).update();
                }
                this.delegatedAction.setEnabled(this.action.isEnabled());
                if (this.isToggle()) {
                    this.delegatedAction.setChecked(this.action.isChecked());
                }
                if (this.orgTooltip == null) {
                    this.orgTooltip = this.delegatedAction.getToolTipText();
                }
                this.delegatedAction.setToolTipText(this.action.getToolTipText());
                return;
            }
        }
        this.delegatedAction.setEnabled(false);
        if (this.isToggle()) {
            this.delegatedAction.setChecked(false);
        }
        if (this.orgTooltip != null) {
            this.delegatedAction.setToolTipText(this.orgTooltip);
        }
    }

    protected IAction getAction() {
        return this.action;
    }

    protected void updateImage() {
        if (this.action == null || this.delegatedAction == null) {
            return;
        }
        ImageDescriptor i = this.action.getImageDescriptor();
        if (i != null) {
            this.delegatedAction.setImageDescriptor(i);
            this.delegatedAction.setDisabledImageDescriptor(this.action.getDisabledImageDescriptor());
            this.delegatedAction.setHoverImageDescriptor(this.action.getHoverImageDescriptor());
        }
    }

    @Override
    public void stateChanged() {
        if (this.delegatedAction == null) {
            return;
        }
        if (this.action == null) {
            this.delegatedAction.setEnabled(false);
            return;
        }
        if (this.action instanceof UpdateAction) {
            ((UpdateAction)this.action).update();
        }
        this.delegatedAction.setEnabled(this.action.isEnabled());
        if (this.isToggle()) {
            this.delegatedAction.setChecked(this.action.isChecked());
        }
        this.delegatedAction.setToolTipText(this.action.getToolTipText());
    }
}

