/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.tiles.util;

import com.ibm.etools.tiles.util.TilesArtifactEdit;
import com.ibm.etools.tiles.util.TilesDefinitionUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class TilesComponentUtil {
    public static final int STRUTS_VERSION_UNKNOWN = -1;
    public static final int STRUTS_VERSION_1_0 = 0;
    public static final int STRUTS_VERSION_1_1 = 1;
    public static final int STRUTS_VERSION_1_2 = 2;
    static final String ACTION_CLASSNAME = "org.apache.struts.action.Action";
    static final String GLOBALS_CLASSNAME = "org.apache.struts.Globals";
    static final String SERVLET_CLASS_NAME = "org.apache.struts.tiles.TilesServlet";

    public static boolean isTilesComponent(IVirtualComponent component) {
        IContainer folder = component.getRootFolder().getUnderlyingFolder();
        IFile file = folder.getFile((IPath)new Path("/WEB-INF/lib/struts.jar"));
        if (!file.exists()) {
            return false;
        }
        TilesDefinitionUtil util = new TilesDefinitionUtil(component);
        try {
            TilesArtifactEdit[] artifacts = util.getArtifactEdit();
            if (artifacts == null || artifacts.length <= 0) {
                return false;
            }
        }
        finally {
            util.dispose();
        }
        return 1 == TilesComponentUtil.getStrutsVersion(component);
    }

    protected static IType getType(IProject project, String name) {
        if (project != null) {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IType type = TilesComponentUtil.getType(javaProject, name);
            if (type == null && name.indexOf(46) == -1) {
                type = TilesComponentUtil.getType(javaProject, "java.lang." + name);
            }
            return type;
        }
        return null;
    }

    protected static IType getType(IJavaProject javaProject, String name) {
        try {
            return javaProject.findType(name);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    public static int getStrutsVersion(IVirtualComponent component) {
        IType actionType = TilesComponentUtil.getType(component.getProject(), ACTION_CLASSNAME);
        if (actionType != null) {
            IType globalsType = TilesComponentUtil.getType(component.getProject(), GLOBALS_CLASSNAME);
            if (globalsType == null) {
                return 0;
            }
            IType tilesServletType = TilesComponentUtil.getType(component.getProject(), SERVLET_CLASS_NAME);
            return tilesServletType != null ? 1 : 2;
        }
        return -1;
    }
}

