/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.tiles.internal.util;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.ServletType;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webapplication.WebType;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class TilesServletUtil {
    public static final String SERVLET_CLASS_NAME = "org.apache.struts.tiles.TilesServlet";
    public static final String ACTION_COMPONENT_SERVLET_CLASS_NAME = "org.apache.struts.tiles.ActionComponentServlet";
    public static final String STRUTS_ACTION_SERVLET_CLASS_NAME = "org.apache.struts.action.ActionServlet";
    public static final String DEFINITION_CONFIG_INITPARAM_NAME = "definitions-config";
    public static final int LOAD_ON_STARTUP_DEFAULT = 2;
    public static final String CONTEXT_PARAM_NAME = "tiles-definitions";

    public static int getAppropriateLoadOnStartupValue(IVirtualComponent webComponent) {
        WebArtifactEdit webArtifactEdit;
        if (webComponent == null) {
            return -1;
        }
        int result = 2;
        WebArtifactEdit webArtifactEdit2 = webArtifactEdit = webComponent.exists() ? WebArtifactEdit.getWebArtifactEditForRead((IVirtualComponent)webComponent) : null;
        if (webArtifactEdit != null) {
            try {
                result = TilesServletUtil.getAppropriateLoadOnStartupValue(webArtifactEdit);
            }
            finally {
                webArtifactEdit.dispose();
            }
        }
        return result;
    }

    protected static int getAppropriateLoadOnStartupValue(WebArtifactEdit artifactEdit) {
        int value = 2;
        WebApp webApp = artifactEdit.getWebApp();
        if (webApp != null) {
            for (Servlet servlet : webApp.getServlets()) {
                Integer servletValue = servlet.getLoadOnStartup();
                if (servletValue == null || value > servletValue) continue;
                value = servletValue + 1;
            }
        }
        return value;
    }

    public static Servlet getTilesServlet(IVirtualComponent webComponent) {
        WebArtifactEdit webArtifactEdit;
        if (webComponent == null) {
            return null;
        }
        Servlet result = null;
        WebArtifactEdit webArtifactEdit2 = webArtifactEdit = webComponent.exists() ? WebArtifactEdit.getWebArtifactEditForRead((IVirtualComponent)webComponent) : null;
        if (webArtifactEdit != null) {
            try {
                result = TilesServletUtil.getServletForClassName(webArtifactEdit, SERVLET_CLASS_NAME, null);
            }
            finally {
                webArtifactEdit.dispose();
            }
        }
        return result;
    }

    public static Servlet getActionComponentTilesServlet(IVirtualComponent webComponent) {
        WebArtifactEdit webArtifactEdit;
        if (webComponent == null) {
            return null;
        }
        Servlet result = null;
        WebArtifactEdit webArtifactEdit2 = webArtifactEdit = webComponent.exists() ? WebArtifactEdit.getWebArtifactEditForRead((IVirtualComponent)webComponent) : null;
        if (webArtifactEdit != null) {
            try {
                result = TilesServletUtil.getServletForClassName(webArtifactEdit, ACTION_COMPONENT_SERVLET_CLASS_NAME, null);
            }
            finally {
                webArtifactEdit.dispose();
            }
        }
        return result;
    }

    public static Servlet getServletForClassName(WebArtifactEdit webArtifactEdit, String className, List excludes) {
        WebApp webApp = webArtifactEdit.getWebApp();
        if (webApp != null) {
            for (Servlet servlet : webApp.getServlets()) {
                if (excludes != null && excludes.contains(servlet) || !TilesServletUtil.hasClass(servlet, className)) continue;
                return servlet;
            }
        }
        return null;
    }

    public static boolean hasClass(Servlet servlet, String className) {
        WebType webType = servlet.getWebType();
        if (webType.isServletType()) {
            JavaClass actionServletClass;
            ServletType servletType = (ServletType)webType;
            String servletClassName = servletType.getClassName();
            if (className.equals(servletClassName)) {
                return true;
            }
            JavaClass servletClass = (JavaClass)JavaRefFactory.eINSTANCE.reflectType(servletClassName, (EObject)servlet);
            if (servletClass != null && (actionServletClass = (JavaClass)JavaRefFactory.eINSTANCE.reflectType(className, (EObject)servlet)) != null && servletClass.inheritsFrom(actionServletClass)) {
                return true;
            }
        }
        return false;
    }
}

