/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.tiles.internal.util;

import com.ibm.etools.tiles.Logger;
import com.ibm.etools.tiles.TilesPlugin;
import com.ibm.etools.tiles.nls.ResourceHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TilesDefsFileCreator {
    private static final String SAMPLE_DEFINITION_NAME = "";
    private static final String SAMPLE_DEFINITION_PATH = "";

    public void writeTo(IFile file, IProgressMonitor monitor) throws CoreException {
        InputStream inputStream = null;
        try {
            inputStream = this.buildInputStream(file.getProject());
        }
        catch (IOException exception) {
            throw new CoreException((IStatus)new Status(4, TilesPlugin.getDefault().getBundle().getSymbolicName(), 0, NLS.bind((String)ResourceHandler.error_save_message_ioError, (Object)file.getName()), (Throwable)exception));
        }
        if (file.exists()) {
            file.setContents(inputStream, true, true, monitor);
        } else {
            file.create(inputStream, true, monitor);
        }
    }

    public InputStream buildInputStream(IProject project) throws IOException {
        Document document = this.createDocument();
        return this.buildInputStream(document);
    }

    private Document createDocument() {
        DocumentBuilder builder;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException exception) {
            Logger.log((Object)this, exception);
            return null;
        }
        Document document = builder.newDocument();
        Element dtdElement = document.createElement("tiles-definitions");
        document.appendChild(dtdElement);
        this.appendText(document, dtdElement, "\n\t");
        this.appendComment(document, dtdElement, ResourceHandler.TDF_tiles_defs_comment);
        this.appendText(document, dtdElement, "\n\t");
        Element definition = document.createElement("definition");
        definition.setAttribute("name", "");
        definition.setAttribute("path", "");
        this.appendText(document, definition, "\n\t\t");
        this.appendText(document, definition, "\n\t");
        dtdElement.appendChild(definition);
        return document;
    }

    private InputStream buildInputStream(Document document) throws IOException {
        DOMSource source = new DOMSource(document, "http://jakarta.apache.org/struts/dtds/tiles-config.dtd");
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(outputStream);
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("encoding", TilesPlugin.getPreferredXMLEncoding());
            transformer.setOutputProperty("doctype-public", "-//Apache Software Foundation//DTD Tiles Configuration//EN");
            transformer.setOutputProperty("doctype-system", "http://jakarta.apache.org/struts/dtds/tiles-config.dtd");
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(source, result);
            outputStream.close();
        }
        catch (TransformerException exception) {
            Logger.log(this, "Unexpected TransformerException creating tiles-defs.xml file", (Throwable)exception);
        }
        return new ByteArrayInputStream(outputStream.toByteArray());
    }

    protected Element appendSection(Document document, Node parent, String name, String sectionName) {
        this.appendText(document, parent, "\n\n\t");
        this.appendComment(document, parent, " " + sectionName + " ");
        this.appendText(document, parent, "\n\t");
        return this.appendElement(document, parent, name);
    }

    protected Element appendElement(Document document, Node parent, String name) {
        Element element = document.createElement(name);
        this.appendText(document, element, "\n\t");
        parent.appendChild(element);
        return element;
    }

    protected void appendText(Document document, Node parent, String string) {
        parent.appendChild(document.createTextNode(string));
    }

    protected void appendComment(Document document, Node parent, String text) {
        parent.appendChild(document.createComment(text));
    }
}

