/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.tiles.internal.util;

import com.ibm.etools.tiles.TilesPlugin;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.osgi.framework.Bundle;

public class TilesActionTaglibURIRegistryReader {
    private static final String ELE_TAGLIBURI = "tagliburi";
    private static final String TAG_TAGLIB = "taglib";
    private static final String TAG_FACET = "facet";
    private static final String FACETID = "facetId";
    private static final String VERSION = "version";
    private static final String URI = "uri";
    private static final String PREFIX = "prefix";
    private static WeakReference elementsReference;

    public static Element[] getElements() {
        Element[] elements;
        if (elementsReference != null && (elements = (Element[])elementsReference.get()) != null) {
            return elements;
        }
        elements = TilesActionTaglibURIRegistryReader.createElements();
        elementsReference = new WeakReference<Element[]>(elements);
        return elements;
    }

    private static Element[] createElements() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(TilesPlugin.getPluginId(), ELE_TAGLIBURI);
        if (point != null) {
            IExtension[] extensions = point.getExtensions();
            Arrays.sort(extensions, new PluginIdComparator());
            ArrayList elementList = new ArrayList(extensions.length);
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] elements = extension.getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    IConfigurationElement element = elements[j];
                    if (element.getName().equals(TAG_TAGLIB)) {
                        TilesActionTaglibURIRegistryReader.readTaglib(element, elementList);
                    }
                    ++j;
                }
                ++i;
            }
            if (!elementList.isEmpty()) {
                return elementList.toArray(new Element[elementList.size()]);
            }
        }
        return new Element[0];
    }

    private static void readFacet(IConfigurationElement element, Set facetVersions) {
        IProjectFacet facet;
        String version;
        String id = element.getAttribute(FACETID);
        if (id != null && (version = element.getAttribute(VERSION)) != null && (facet = ProjectFacetsManager.getProjectFacet((String)id)) != null) {
            try {
                Set versions = facet.getVersions(version);
                facetVersions.addAll(versions);
            }
            catch (CoreException coreException) {}
        }
    }

    private static void readTaglib(IConfigurationElement element, List elementList) {
        String uri;
        String prefix = element.getAttribute(PREFIX);
        if (prefix != null && (uri = element.getAttribute(URI)) != null) {
            HashSet facetVersions = new HashSet();
            IConfigurationElement[] elements = element.getChildren();
            int j = 0;
            while (j < elements.length) {
                IConfigurationElement child = elements[j];
                if (child.getName().equals(TAG_FACET)) {
                    TilesActionTaglibURIRegistryReader.readFacet(child, facetVersions);
                }
                ++j;
            }
            if (!facetVersions.isEmpty()) {
                elementList.add(new Element(facetVersions, prefix, uri));
            }
        }
    }

    public static class Element {
        public final Set facetVersions;
        public final String prefix;
        public final String uri;

        public Element(Set facetVersions, String prefix, String uri) {
            this.facetVersions = facetVersions;
            this.prefix = prefix;
            this.uri = uri;
        }
    }

    private static class PluginIdComparator
    implements Comparator {
        private PluginIdComparator() {
        }

        public int compare(Object extension1, Object extension2) {
            Bundle bundle1 = Platform.getBundle((String)((IExtension)extension1).getContributor().getName());
            Bundle bundle2 = Platform.getBundle((String)((IExtension)extension2).getContributor().getName());
            if (bundle1 == null) {
                return bundle2 == null ? 0 : -1;
            }
            if (bundle2 == null) {
                return 1;
            }
            return bundle1.getSymbolicName().compareTo(bundle2.getSymbolicName());
        }
    }
}

