/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.tiles.intenal.links.linkdetectorprovider;

import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IResolvedReference;
import com.ibm.etools.references.management.ReferenceElementFactory;
import com.ibm.etools.references.services.providers.ILinkDetectorProvider;
import com.ibm.etools.references.services.providers.SharedModel;
import com.ibm.etools.references.web.AbstractWebProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.TreeWalker;

public class TilesDefLinkDetectorProvider
implements ILinkDetectorProvider {
    private static final String NODE_DEFINITION = "definition";
    private static final String NODE_PUT = "put";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_PATH = "path";
    private static final String ATTRIBUTE_TEMPLATE = "template";
    private static final String ATTRIBUTE_PAGE = "page";
    private static final String ATTRIBUTE_CONTENT = "content";
    private static final String ATTRIBUTE_TYPE = "type";
    private static final String ATTRIBUTE_DIRECT = "direct";
    private static final String ATTRIBUTE_VALUE = "value";

    public List<ILink> detectLinks(ReferenceElementFactory factory, SharedModel sharedModel, Set<IResolvedReference> incomingReferences) {
        ArrayList<ILink> links = new ArrayList<ILink>();
        if (sharedModel.getSharedModel() instanceof IDOMModel) {
            IDOMModel model = (IDOMModel)sharedModel.getSharedModel();
            IDOMDocument document = model.getDocument();
            TreeWalker iter = ((DocumentTraversal)document).createTreeWalker((Node)document, 1, null, false);
            Node n = iter.nextNode();
            while (n != null) {
                ILink linkToAdd;
                String name;
                Node templateName;
                String nodeName = n.getNodeName();
                if (nodeName.equalsIgnoreCase(NODE_DEFINITION)) {
                    templateName = n.getAttributes().getNamedItem(ATTRIBUTE_NAME);
                    name = templateName.getNodeName();
                    if (name != null) {
                        name = name.trim();
                    }
                    linkToAdd = null;
                    Node definitionPath = n.getAttributes().getNamedItem(ATTRIBUTE_PATH);
                    Node definitionPage = n.getAttributes().getNamedItem(ATTRIBUTE_PAGE);
                    Node definitionTemplate = n.getAttributes().getNamedItem(ATTRIBUTE_TEMPLATE);
                    Node nodeToAdd = null;
                    if (definitionPath != null) {
                        nodeToAdd = definitionPath;
                    } else if (definitionPage != null) {
                        nodeToAdd = definitionPage;
                    } else if (definitionTemplate != null) {
                        nodeToAdd = definitionTemplate;
                    }
                    if (nodeToAdd != null) {
                        linkToAdd = AbstractWebProvider.createLink((ReferenceElementFactory)factory, (IDOMElement)((IDOMElement)n), (IDOMAttr)((IDOMAttr)nodeToAdd), (String)"web.nocontextroot", (String)name);
                    }
                    if (linkToAdd != null) {
                        links.add(linkToAdd);
                    }
                } else if (nodeName.equalsIgnoreCase(NODE_PUT)) {
                    String typeContent;
                    templateName = n.getAttributes().getNamedItem(ATTRIBUTE_NAME);
                    name = templateName.getNodeName();
                    if (name != null) {
                        name = name.trim();
                    }
                    linkToAdd = null;
                    Node putValue = n.getAttributes().getNamedItem(ATTRIBUTE_VALUE);
                    Node putContent = n.getAttributes().getNamedItem(ATTRIBUTE_CONTENT);
                    Node putType = n.getAttributes().getNamedItem(ATTRIBUTE_TYPE);
                    Node putDirect = n.getAttributes().getNamedItem(ATTRIBUTE_DIRECT);
                    Node nodeToAdd = null;
                    if (putValue != null) {
                        nodeToAdd = putValue;
                    } else if (putContent != null) {
                        nodeToAdd = putContent;
                    }
                    boolean typeString = false;
                    if (putType != null && (typeContent = putType.getNodeValue()).equalsIgnoreCase("string")) {
                        typeString = true;
                    }
                    boolean directVal = false;
                    if (putDirect != null) {
                        directVal = Boolean.parseBoolean(putDirect.getNodeValue());
                    }
                    if (nodeToAdd != null && !typeString && !directVal) {
                        linkToAdd = AbstractWebProvider.createLink((ReferenceElementFactory)factory, (IDOMElement)((IDOMElement)n), (IDOMAttr)((IDOMAttr)nodeToAdd), (String)"web.nocontextroot", (String)name);
                    }
                    if (linkToAdd != null) {
                        links.add(linkToAdd);
                    }
                }
                n = iter.nextNode();
            }
        }
        return links;
    }
}

