/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.tiles.facet;

import com.ibm.etools.tiles.Logger;
import com.ibm.etools.tiles.TilesPlugin;
import com.ibm.etools.tiles.internal.util.TilesDefsFileCreator;
import com.ibm.etools.tiles.internal.util.TilesServletUtil;
import com.ibm.etools.tiles.nls.ResourceHandler;
import com.ibm.etools.tiles.resources.TilesResourcesPlugin;
import com.ibm.etools.tiles.util.ITilesDefinitionFileProvider;
import com.ibm.etools.tiles.util.TilesComponentUtil;
import com.ibm.etools.tiles.util.TilesDefinitionProviderRegistry;
import com.ibm.etools.tiles.util.TilesDefinitionUtil;
import com.ibm.etools.webedit.links.util.ModuleUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jst.j2ee.common.CommonFactory;
import org.eclipse.jst.j2ee.common.ParamValue;
import org.eclipse.jst.j2ee.jsp.JSPConfig;
import org.eclipse.jst.j2ee.jsp.JspFactory;
import org.eclipse.jst.j2ee.jsp.JspPackage;
import org.eclipse.jst.j2ee.jsp.TagLibRefType;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webapplication.InitParam;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.ServletType;
import org.eclipse.jst.j2ee.webapplication.TagLibRef;
import org.eclipse.jst.j2ee.webapplication.WebType;
import org.eclipse.jst.j2ee.webapplication.WebapplicationFactory;
import org.eclipse.jst.j2ee.webapplication.WebapplicationPackage;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.ArtifactEditModel;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.osgi.framework.Bundle;

public class TilesFacetInstaller {
    private static final String TILES_DEFS_FILE = "tiles-defs.xml";
    private static final String STRUTS_FACETS_ID = "web.struts";
    private static final String STRUTS_VERSION_1_3 = "1.3";
    private static final String[] TLD_FILES = new String[]{"struts-tiles.tld"};
    private static final String[] TILES_JAR_FILES = new String[]{"commons-beanutils.jar", "commons-collections.jar", "commons-digester.jar", "commons-logging.jar", "struts.jar"};
    private static final String TILES_FILES_FOLDER = "Tiles/Tiles_Struts_1.1";
    private static final String SERVLET_CLASS_NAME = "org.apache.struts.tiles.TilesServlet";
    private static final String SERVLET_NAME = "TilesServet";
    private static final String DEFINITION_CONFIG_INITPARAM_NAME = "definitions-config";
    private IProgressMonitor progressMonitor;
    private IProject project;
    private IVirtualComponent component;

    public void execute(IProject project, IDataModel dataModel, IProgressMonitor monitor) throws CoreException {
        Object webJEEAppObj;
        this.project = project;
        int version = TilesComponentUtil.getStrutsVersion(this.getComponent());
        if (version == 0) {
            throw new CoreException((IStatus)new Status(4, TilesPlugin.getPluginId(), 0, ResourceHandler._UI_Tiles_Facet_Installer_0, null));
        }
        if (!this.getComponent().getRootFolder().getFolder("WEB-INF").getFile("web.xml").exists() && (webJEEAppObj = ModelProviderManager.getModelProvider((IProject)project).getModelObject()) != null && webJEEAppObj instanceof WebApp) {
            ModelProviderManager.getModelProvider((IProject)project).modify(new Runnable(){

                @Override
                public void run() {
                }
            }, IModelProvider.FORCESAVE);
        }
        int jspVersion = 11;
        WebArtifactEdit edit = WebArtifactEdit.getWebArtifactEditForRead((IVirtualComponent)this.component);
        if (edit != null) {
            jspVersion = edit.getJSPVersion();
            edit.dispose();
        }
        this.setProgressMonitor(monitor);
        if (dataModel.getBooleanProperty("ITilesFacetDataModelProperties.PSEUDO_INSTALL")) {
            return;
        }
        try {
            boolean isStrutsVersionDefined = ModuleUtil.projectHasFacet((IProject)project, (String)STRUTS_FACETS_ID, (String)STRUTS_VERSION_1_3);
            if (!isStrutsVersionDefined) {
                this.copyJarFiles();
            }
            if (jspVersion == 11) {
                this.copyTLDFiles();
            }
            if (version != 2) {
                this.updateWebXML();
            }
            this.createTilesDefsFile();
        }
        finally {
            this.setProgressMonitor(null);
        }
    }

    protected void setProgressMonitor(IProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
    }

    protected IProgressMonitor getProgressMonitor() {
        if (this.progressMonitor == null) {
            this.progressMonitor = new NullProgressMonitor();
        }
        return this.progressMonitor;
    }

    protected IProject getProject() {
        return this.project;
    }

    protected IVirtualComponent getComponent() {
        if (this.component == null) {
            this.component = ComponentCore.createComponent((IProject)this.getProject());
        }
        return this.component;
    }

    protected void copyJarFiles() {
        String[] jarFiles = this.getJarFiles();
        int i = 0;
        while (i < jarFiles.length) {
            IFile targetFile = this.getComponent().getRootFolder().getFolder("WEB-INF/lib").getFile(jarFiles[i]).getUnderlyingFile();
            if (!targetFile.exists()) {
                this.copyFile(targetFile);
            }
            ++i;
        }
    }

    private boolean copyFile(IFile targetFile) {
        if (targetFile != null && targetFile.exists()) {
            return false;
        }
        IPath sourcePath = this.getSourcePath(targetFile.getName());
        if (sourcePath == null) {
            return false;
        }
        String traceMsg = ResourceHandler._UI_Tiles_Facet_Installer_1;
        traceMsg = NLS.bind((String)traceMsg, (Object[])new Object[]{sourcePath, targetFile.getFullPath()});
        Logger.trace(TilesPlugin.getPluginId(), this, traceMsg);
        InputStream sourceStream = null;
        try {
            sourceStream = new BufferedInputStream(FileLocator.openStream((Bundle)TilesResourcesPlugin.getDefault().getBundle(), (IPath)sourcePath, (boolean)false));
            if (sourceStream == null) {
                return false;
            }
            try {
                try {
                    targetFile.create(sourceStream, true, this.getProgressMonitor());
                }
                catch (CoreException exception) {
                    Logger.log((Object)this, exception);
                }
            }
            catch (Exception exception) {
                Logger.log((Object)this, exception);
                return false;
            }
        }
        finally {
            if (sourceStream != null) {
                try {
                    sourceStream.close();
                }
                catch (IOException exception) {
                    Logger.log((Object)this, exception);
                }
            }
        }
        return true;
    }

    protected String[] getTLDFiles() {
        return TLD_FILES;
    }

    protected String[] getJarFiles() {
        return TILES_JAR_FILES;
    }

    protected IPath getSourcePath(String fileName) {
        String location = TILES_FILES_FOLDER;
        return new Path(location).append(fileName);
    }

    protected void copyTLDFiles() {
        this.copyFiles(this.getTLDFiles(), this.getWEBINFPath());
    }

    protected void copyFiles(String[] fileNames, IPath targetPath) {
        int i = 0;
        while (i < fileNames.length) {
            IPath fullPath = targetPath.append(fileNames[i]);
            IFile targetFile = this.getFile(fullPath);
            this.copyFile(targetFile);
            ++i;
        }
    }

    protected IPath getWEBINFPath() {
        return this.getComponent().getRootFolder().getFolder("WEB-INF").getUnderlyingFolder().getFullPath();
    }

    protected IFile getFile(IPath path) {
        return ResourcesPlugin.getWorkspace().getRoot().getFile(path);
    }

    protected final void updateWebXML() {
        WebArtifactEdit webArtifactEdit;
        WebArtifactEdit webArtifactEdit2 = webArtifactEdit = this.getComponent().exists() ? WebArtifactEdit.getWebArtifactEditForWrite((IVirtualComponent)this.getComponent()) : null;
        if (webArtifactEdit != null) {
            try {
                try {
                    Command command = this.createUpdateWebEditModelCommand(webArtifactEdit);
                    if (command != null) {
                        ((ArtifactEditModel)webArtifactEdit.getAdapter(ArtifactEditModel.ADAPTER_TYPE)).getCommandStack().execute(command);
                    }
                    webArtifactEdit.saveIfNecessary(this.getProgressMonitor());
                }
                catch (Exception exception) {
                    Logger.log(this, "Exception during update of web.xml", (Throwable)exception);
                    webArtifactEdit.dispose();
                }
            }
            finally {
                webArtifactEdit.dispose();
            }
        }
    }

    private final Command createUpdateWebEditModelCommand(WebArtifactEdit webEditModel) {
        ArrayList commands = new ArrayList();
        this.createUpdateWebEditModelCommands(commands, webEditModel);
        switch (commands.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (Command)commands.get(0);
            }
        }
        return new CompoundCommand(commands);
    }

    protected void createUpdateWebEditModelCommands(List commands, WebArtifactEdit webEditModel) {
        this.createAddServletCommands(commands, webEditModel);
        if (webEditModel.getJSPVersion() == 11) {
            this.createAddTaglibEntriesCommands(commands, webEditModel);
        }
    }

    private Servlet createAddServletCommands(List commands, WebArtifactEdit webEditModel) {
        Servlet servlet = TilesServletUtil.getTilesServlet(this.getComponent());
        if (servlet == null) {
            servlet = TilesServletUtil.getActionComponentTilesServlet(this.getComponent());
        }
        if (servlet == null) {
            WebapplicationFactory factory = WebapplicationPackage.eINSTANCE.getWebapplicationFactory();
            ServletType servletType = factory.createServletType();
            servletType.setClassName(SERVLET_CLASS_NAME);
            servlet = factory.createServlet();
            servlet.setServletName(SERVLET_NAME);
            servlet.setWebType((WebType)servletType);
            servlet.setLoadOnStartup(new Integer(TilesServletUtil.getAppropriateLoadOnStartupValue(this.getComponent())));
            commands.add(AddCommand.create((EditingDomain)this.getEditingDomain(webEditModel), (Object)webEditModel.getWebApp(), (Object)WebapplicationPackage.eINSTANCE.getWebApp_Servlets(), (Object)servlet));
        }
        this.createAddInitParamCommand(commands, webEditModel, servlet, DEFINITION_CONFIG_INITPARAM_NAME, this.getComponent().getRootFolder().getFolder("WEB-INF").getFile(TILES_DEFS_FILE).getRuntimePath().toString());
        return servlet;
    }

    private void createAddInitParamCommand(List commands, WebArtifactEdit webEditModel, Servlet servlet, String paramName, String paramValue) {
        int j2eeVersionId = webEditModel.getWebApp().getJ2EEVersionID();
        if (j2eeVersionId == 12 || j2eeVersionId == 13) {
            for (InitParam initParam : servlet.getParams()) {
                if (!paramName.equals(initParam.getParamName())) continue;
                return;
            }
            WebapplicationFactory factory = WebapplicationPackage.eINSTANCE.getWebapplicationFactory();
            InitParam initParam = factory.createInitParam();
            initParam.setParamName(paramName);
            initParam.setParamValue(paramValue);
            commands.add(AddCommand.create((EditingDomain)this.getEditingDomain(webEditModel), (Object)servlet, (Object)WebapplicationPackage.eINSTANCE.getServlet_Params(), (Object)initParam));
        } else {
            ParamValue initParam2;
            for (ParamValue initParam2 : servlet.getInitParams()) {
                if (!paramName.equals(initParam2.getName())) continue;
                return;
            }
            initParam2 = CommonFactory.eINSTANCE.createParamValue();
            initParam2.setName(paramName);
            initParam2.setValue(paramValue);
            commands.add(AddCommand.create((EditingDomain)this.getEditingDomain(webEditModel), (Object)servlet, (Object)WebapplicationPackage.eINSTANCE.getServlet_InitParams(), (Object)initParam2));
        }
    }

    protected EditingDomain getEditingDomain(WebArtifactEdit webEditModel) {
        return new AdapterFactoryEditingDomain(new AdapterFactory(){

            public boolean isFactoryForType(Object type) {
                return false;
            }

            public Object adapt(Object object, Object type) {
                return null;
            }

            public Adapter adapt(Notifier target, Object type) {
                return null;
            }

            public Adapter adaptNew(Notifier target, Object type) {
                return null;
            }

            public void adaptAllNew(Notifier notifier) {
            }
        }, (CommandStack)((ArtifactEditModel)webEditModel.getAdapter(ArtifactEditModel.ADAPTER_TYPE)).getCommandStack());
    }

    protected void createAddTaglibEntriesCommands(List commands, WebArtifactEdit webEditModel) {
        ArrayList<String> taglibs = new ArrayList<String>();
        String[] tldFiles = this.getTLDFiles();
        int i = 0;
        while (i < tldFiles.length) {
            Path path = new Path("WEB-INF");
            path = path.makeAbsolute().addTrailingSeparator();
            taglibs.add(path.append(tldFiles[i]).toString());
            ++i;
        }
        int j2eeVersion = webEditModel.getWebApp().getJ2EEVersionID();
        switch (j2eeVersion) {
            case 12: 
            case 13: {
                this.createAddPre1_4TaglibEntriesCommands(commands, webEditModel, taglibs);
                break;
            }
            default: {
                this.createAdd1_4TaglibEntriesCommands(commands, webEditModel, taglibs);
            }
        }
    }

    private void createAddPre1_4TaglibEntriesCommands(List commands, WebArtifactEdit webEditModel, List taglibs) {
        org.eclipse.jst.j2ee.webapplication.WebApp webApp = webEditModel.getWebApp();
        EList existingTaglibs = webApp.getTagLibs();
        WebapplicationFactory factory = WebapplicationPackage.eINSTANCE.getWebapplicationFactory();
        for (String taglibLocation : taglibs) {
            boolean containsTaglib = false;
            for (TagLibRef curTagLib : existingTaglibs) {
                if (!taglibLocation.equals(curTagLib.getTaglibLocation())) continue;
                containsTaglib = true;
                break;
            }
            if (containsTaglib) continue;
            TagLibRef taglib = factory.createTagLibRef();
            taglib.setTaglibLocation(taglibLocation);
            taglib.setTaglibURI(taglibLocation);
            commands.add(AddCommand.create((EditingDomain)this.getEditingDomain(webEditModel), (Object)webApp, (Object)WebapplicationPackage.eINSTANCE.getWebApp_TagLibs(), (Object)taglib));
        }
    }

    private void createAdd1_4TaglibEntriesCommands(List commands, WebArtifactEdit webEditModel, List taglibs) {
        org.eclipse.jst.j2ee.webapplication.WebApp webApp = webEditModel.getWebApp();
        JSPConfig jspConfig = webApp.getJspConfig();
        if (jspConfig == null) {
            jspConfig = JspFactory.eINSTANCE.createJSPConfig();
            commands.add(SetCommand.create((EditingDomain)this.getEditingDomain(webEditModel), (Object)webApp, (Object)WebapplicationPackage.eINSTANCE.getWebApp_JspConfig(), (Object)jspConfig));
        }
        EList existingTaglibs = jspConfig.getTagLibs();
        for (String taglibLocation : taglibs) {
            boolean containsTaglib = false;
            for (TagLibRefType curTagLib : existingTaglibs) {
                if (!taglibLocation.equals(curTagLib.getTaglibLocation())) continue;
                containsTaglib = true;
                break;
            }
            if (containsTaglib) continue;
            TagLibRefType taglib = JspFactory.eINSTANCE.createTagLibRefType();
            taglib.setTaglibLocation(taglibLocation);
            taglib.setTaglibURI(taglibLocation);
            commands.add(AddCommand.create((EditingDomain)this.getEditingDomain(webEditModel), (Object)jspConfig, (Object)JspPackage.eINSTANCE.getJSPConfig_TagLibs(), (Object)taglib));
        }
    }

    protected static IPath getWebXmlPath(IVirtualComponent component) {
        WebArtifactEdit webArtifact = WebArtifactEdit.getWebArtifactEditForRead((IVirtualComponent)component);
        IPath webXmlPath = null;
        try {
            if (webArtifact != null) {
                webXmlPath = webArtifact.getDeploymentDescriptorPath();
            }
        }
        finally {
            if (webArtifact != null) {
                webArtifact.dispose();
            }
        }
        return webXmlPath;
    }

    protected TilesDefsFileCreator getTilesDefsFileCreator() {
        return new TilesDefsFileCreator();
    }

    protected IFile getTilesDefsFile() {
        ITilesDefinitionFileProvider[] providers = TilesDefinitionProviderRegistry.getInstance().getProviders();
        HashSet<String> pathList = new HashSet<String>();
        int i = 0;
        while (providers != null && i < providers.length) {
            String[] paths = providers[i].getDefinitionFiles(this.component, null);
            if (paths != null) {
                pathList.addAll(Arrays.asList(paths));
            }
            ++i;
        }
        IPath webinfPath = this.getWEBINFPath();
        IFile file = this.getFile(webinfPath.append(TILES_DEFS_FILE));
        String filePath = TilesDefinitionUtil.getWebFilePath(this.component, file).toString();
        if (pathList.size() > 0 && !pathList.contains(filePath)) {
            filePath = pathList.iterator().next().toString();
            file = TilesDefinitionUtil.getWebFile(this.component, (IPath)new Path(filePath));
        }
        return file.exists() ? null : file;
    }

    protected void createTilesDefsFile() {
        IFile tilesDefsFile = this.getTilesDefsFile();
        if (tilesDefsFile != null) {
            try {
                TilesDefsFileCreator tdfCreator = this.getTilesDefsFileCreator();
                tdfCreator.writeTo(tilesDefsFile, this.getProgressMonitor());
            }
            catch (Exception e) {
                Logger.log((Object)this, e);
            }
        }
    }
}

